/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.block.tree;

import com.google.common.collect.Lists;
import gregtech.core.CoreModule;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.block.GTFOMetaBlocks;
import gregtechfoodoption.block.IVariantNamed;
import gregtechfoodoption.block.tree.LeafDecayHelper;
import gregtechfoodoption.worldgen.trees.GTFOTree;
import gregtechfoodoption.worldgen.trees.GTFOTrees;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GTFOBlockLeaves
extends BlockLeaves
implements IVariantNamed {
    public static final PropertyInteger VARIANT = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)3);
    private final int offset;

    public GTFOBlockLeaves(int offset) {
        this.offset = offset;
        this.func_149663_c("gtfo_leaves_" + offset);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)));
        GTFOMetaBlocks.GTFO_LEAVES.add(this);
        this.func_149647_a((CreativeTabs)GTFOValues.TAB_GTFO);
        Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
    }

    public BlockPlanks.EnumType func_176233_b(int i) {
        return null;
    }

    public GTFOTree getTreeFromState(IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)VARIANT) + this.offset * 4 >= GTFOTree.TREES.size()) {
            return GTFOTrees.LEMON_TREE;
        }
        return GTFOTree.TREES.get((Integer)state.func_177229_b((IProperty)VARIANT) + this.offset * 4);
    }

    @Nonnull
    public Item func_180660_a(@Nonnull IBlockState state, @Nonnull Random rand, int fortune) {
        return Item.func_150898_a((Block)this.getTreeFromState((IBlockState)state).saplingState.func_177230_c());
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 2) == 2)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf((meta & 0xC) >> 2));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            meta |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            meta |= 2;
        }
        return meta |= (Integer)state.func_177229_b((IProperty)VARIANT) << 2;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)))});
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < 4 && GTFOTree.TREES.size() > i + this.offset * 4; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i << 2));
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176237_a, field_176236_b, VARIANT});
    }

    @SideOnly(value=Side.CLIENT)
    public void registerColors() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, worldIn, pos, tintIndex) -> this.getTreeFromState(state).getBlockColor(state, worldIn, pos, tintIndex), new Block[]{this});
        Minecraft.func_71410_x().getItemColors().func_186731_a((stack, tintIndex) -> this.getTreeFromState(this.func_176203_a(stack.func_77952_i())).getItemColor(stack, tintIndex), new Block[]{this});
    }

    @Override
    public String getVariantTranslationKey(IBlockState state) {
        try {
            return "gregtechfoodoption.leaves." + this.getTreeFromState((IBlockState)state).name;
        }
        catch (IndexOutOfBoundsException e) {
            return "gregtechfoodoption.hello_buildcraft";
        }
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        if (!this.fancyLeaves()) {
            return super.func_180664_k();
        }
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        if (!this.fancyLeaves()) {
            return super.func_149662_c(state);
        }
        return false;
    }

    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        if (!this.fancyLeaves()) {
            return super.func_176225_a(blockState, blockAccess, pos, side);
        }
        return true;
    }

    private boolean fancyLeaves() {
        return CoreModule.proxy.isFancyGraphics();
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
        GTFOBlockLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)((GTFOBlockLeaves)state.func_177230_c()).getTreeFromState(state).getAppleDrop(chance));
    }

    public int func_180651_a(IBlockState state) {
        return ((Integer)state.func_177229_b((IProperty)VARIANT) << 1) + this.offset % 2 * 8;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, (Integer)state.func_177229_b((IProperty)VARIANT) << 2);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        LeafDecayHelper.leafDecay(this, worldIn, pos);
    }
}

