/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.block;

import com.google.common.collect.ImmutableMap;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.ItemMaterialInfo;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.common.ConfigHolder;
import gregtechfoodoption.block.GTFOBlockCasing;
import gregtechfoodoption.block.GTFOCrops;
import gregtechfoodoption.block.GTFOGlassCasing;
import gregtechfoodoption.block.GTFOMetalCasing;
import gregtechfoodoption.block.tree.GTFOBlockLeaves;
import gregtechfoodoption.block.tree.GTFOBlockLog;
import gregtechfoodoption.block.tree.GTFOBlockPlanks;
import gregtechfoodoption.block.tree.GTFOBlockSapling;
import gregtechfoodoption.worldgen.berries.GTFOBerries;
import gregtechfoodoption.worldgen.trees.GTFOTree;
import gregtechfoodoption.worldgen.trees.GTFOTrees;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GTFOMetaBlocks {
    public static GTFOBlockCasing GTFO_CASING;
    public static GTFOMetalCasing GTFO_METAL_CASING;
    public static GTFOGlassCasing GTFO_GLASS_CASING;
    public static List<GTFOBlockLeaves> GTFO_LEAVES;
    public static List<GTFOBlockLog> GTFO_LOGS;
    public static List<GTFOBlockPlanks> GTFO_PLANKS;
    public static List<GTFOBlockSapling> GTFO_SAPLINGS;

    public static void init() {
        int i;
        GTFO_CASING = new GTFOBlockCasing();
        GTFO_CASING.setRegistryName("gtfo_casing");
        GTFO_METAL_CASING = new GTFOMetalCasing();
        GTFO_METAL_CASING.setRegistryName("gtfo_metal_casing");
        GTFO_GLASS_CASING = new GTFOGlassCasing();
        GTFO_GLASS_CASING.setRegistryName("gtfo_glass_casing");
        GTFOTrees.init();
        GTFOBerries.init();
        for (i = 0; i <= (GTFOTree.TREES.size() - 1) / 4; ++i) {
            GTFOBlockLeaves leaves = new GTFOBlockLeaves(i);
            leaves.setRegistryName("gtfo_leaves_" + i);
        }
        for (i = 0; i <= (GTFOTree.TREES.size() - 1) / 4; ++i) {
            GTFOBlockLog log = new GTFOBlockLog(i);
            log.setRegistryName("gtfo_log_" + i);
        }
        for (i = 0; i <= (GTFOTree.TREES.size() - 1) / 8; ++i) {
            GTFOBlockSapling sapling = new GTFOBlockSapling(i);
            sapling.setRegistryName("gtfo_sapling_" + i);
        }
        for (i = 0; i <= (GTFOTree.TREES.size() - 1) / 16; ++i) {
            GTFOBlockPlanks planks = new GTFOBlockPlanks(i);
            planks.setRegistryName("gtfo_planks_" + i);
        }
        GTFOCrops.init();
        GTFOTree.TREES.forEach(GTFOTree::setupBlocks);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModels() {
        GTFOMetaBlocks.registerItemModel((Block)GTFO_CASING);
        GTFOMetaBlocks.registerItemModel((Block)GTFO_METAL_CASING);
        GTFOMetaBlocks.registerItemModel((Block)GTFO_GLASS_CASING);
        GTFO_LEAVES.forEach(GTFOMetaBlocks::registerItemModel);
        GTFO_SAPLINGS.forEach(GTFOMetaBlocks::registerItemModel);
        for (GTFOBlockSapling sapling : GTFO_SAPLINGS) {
            GTFOMetaBlocks.registerItemModel((Block)sapling);
            for (int v = 0; v < 8; ++v) {
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)sapling), (int)(v << 1), (ModelResourceLocation)new ModelResourceLocation(sapling.getRegistryName() + "_" + v, "inventory"));
            }
        }
        for (GTFOBlockLog log : GTFO_LOGS) {
            GTFOMetaBlocks.registerItemModelWithOverride((Block)log, ImmutableMap.of((Object)BlockLog.field_176299_a, (Object)BlockLog.EnumAxis.Y));
        }
        GTFO_PLANKS.forEach(GTFOMetaBlocks::registerItemModel);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModel(Block block) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), GTFOMetaBlocks.statePropertiesToString(state.func_177228_b())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModelWithOverride(Block block, Map<IProperty<?>, Comparable<?>> stateOverrides) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            HashMap stringProperties = new HashMap((Map<IProperty<?>, Comparable<?>>)state.func_177228_b());
            stringProperties.putAll(stateOverrides);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), GTFOMetaBlocks.statePropertiesToString(stringProperties)));
        }
    }

    public static void registerOreDict() {
        GTFO_LEAVES.forEach(leaves -> OreDictUnifier.registerOre((ItemStack)new ItemStack((Block)leaves, 1, Short.MAX_VALUE), (String)"treeLeaves"));
        GTFO_SAPLINGS.forEach(sapling -> OreDictUnifier.registerOre((ItemStack)new ItemStack((Block)sapling, 1, Short.MAX_VALUE), (String)"treeSapling"));
        GTFO_LOGS.forEach(log -> {
            OreDictUnifier.registerOre((ItemStack)new ItemStack((Block)log, 1, Short.MAX_VALUE), (OrePrefix)OrePrefix.log, (Material)Materials.Wood);
            if (!ConfigHolder.recipes.harderCharcoalRecipe) {
                GameRegistry.addSmelting((ItemStack)new ItemStack((Block)log, 1, Short.MAX_VALUE), (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
            }
        });
        GTFO_PLANKS.forEach(planks -> {
            OreDictUnifier.registerOre((ItemStack)new ItemStack((Block)planks, 1, Short.MAX_VALUE), (OrePrefix)OrePrefix.plank, (Material)Materials.Wood);
            OreDictUnifier.registerOre((ItemStack)new ItemStack((Block)planks, 1, Short.MAX_VALUE), (ItemMaterialInfo)new ItemMaterialInfo(new MaterialStack[]{new MaterialStack(Materials.Wood, 3628800L)}));
        });
    }

    private static String statePropertiesToString(Map<IProperty<?>, Comparable<?>> properties) {
        StringBuilder stringbuilder = new StringBuilder();
        List entries = properties.entrySet().stream().sorted(Comparator.comparing(c -> ((IProperty)c.getKey()).func_177701_a())).collect(Collectors.toList());
        for (Map.Entry entry : entries) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty property = (IProperty)entry.getKey();
            stringbuilder.append(property.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(GTFOMetaBlocks.getPropertyName(property, (Comparable)entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerStateMappers() {
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerColors() {
        GTFO_LEAVES.forEach(GTFOBlockLeaves::registerColors);
    }

    static {
        GTFO_LEAVES = new ArrayList<GTFOBlockLeaves>();
        GTFO_LOGS = new ArrayList<GTFOBlockLog>();
        GTFO_PLANKS = new ArrayList<GTFOBlockPlanks>();
        GTFO_SAPLINGS = new ArrayList<GTFOBlockSapling>();
    }
}

