/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class GTFOCrop
extends BlockCrops {
    public static final PropertyInteger DEFAULT_AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)5);
    private static final AxisAlignedBB CROPS_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    protected ItemStack seed;
    protected ItemStack crop;
    public static List<GTFOCrop> CROP_BLOCKS = new ArrayList<GTFOCrop>();
    private final String name;

    protected GTFOCrop(String name) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(0)));
        this.setRegistryName("gregtechfoodoption", "crop_" + name);
        CROP_BLOCKS.add(this);
        this.name = name;
        this.func_149663_c("gtfo_crop_" + name);
    }

    public static GTFOCrop create(String name) {
        return new GTFOCrop(name);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public int func_185526_g() {
        return 5;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        int age = this.func_185527_x(state);
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (age >= this.func_185526_g()) {
            if (!this.seed.func_190926_b()) {
                ItemStack seedStack = this.seed.func_77946_l();
                if (rand.nextInt(9) == 0) {
                    seedStack.func_190920_e(seedStack.func_190916_E() + 1);
                }
                drops.add((Object)seedStack);
            }
            int cropCount = 0;
            for (int i = 0; i < 3 + fortune; ++i) {
                if (rand.nextInt(2 * this.func_185526_g()) > age) continue;
                ++cropCount;
            }
            if (cropCount > 0) {
                ItemStack crop = this.crop.func_77946_l();
                crop.func_190920_e(cropCount);
                drops.add((Object)crop);
            }
        }
    }

    public Item func_149866_i() {
        return this.seed.func_77973_b();
    }

    public Item func_149865_P() {
        return this.crop.func_77973_b();
    }

    public ItemStack getCropStack() {
        return this.crop;
    }

    public void setSeed(ItemStack seed) {
        this.seed = seed;
    }

    public void setCrop(ItemStack crop) {
        this.crop = crop;
    }

    public int func_180651_a(IBlockState state) {
        return this.seed.func_77952_i();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return this.seed;
    }

    public ItemStack getSeedStack() {
        return this.seed;
    }

    public PropertyInteger func_185524_e() {
        return DEFAULT_AGE;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.func_185524_e()});
    }

    public String getName() {
        return this.name;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Random rand = world instanceof World ? world.field_73012_v : new Random();
        int age = this.func_185527_x(state);
        if (this.func_185525_y(state)) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (!this.seed.func_190926_b() && rand.nextInt(9) == 0) {
                ItemStack seedStack = this.seed.func_77946_l();
                drops.add(seedStack);
            }
            int cropCount = 0;
            for (int i = 0; i < 3; ++i) {
                if (rand.nextInt(2 * this.func_185526_g()) > age) continue;
                ++cropCount;
            }
            if (cropCount > 0) {
                ItemStack crop = this.crop.func_77946_l();
                crop.func_190920_e(cropCount);
                drops.add(crop);
            }
            for (ItemStack drop : drops) {
                if (playerIn.func_191521_c(drop)) continue;
                playerIn.func_71019_a(drop, false);
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(0)), 3);
            return true;
        }
        return false;
    }
}

