/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption;

import gregtech.api.GregTechAPI;
import gregtech.api.fluids.FluidBuilder;
import gregtech.api.fluids.attribute.FluidAttribute;
import gregtech.api.fluids.attribute.FluidAttributes;
import gregtech.api.items.metaitem.MetaOreDictItem;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.LocalizationUtils;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.item.GTFOMetaItems;
import gregtechfoodoption.item.GTFOProxyItem;
import gregtechfoodoption.materials.CleanerProperty;
import gregtechfoodoption.materials.FertilizerProperty;
import gregtechfoodoption.materials.LacingProperty;
import gregtechfoodoption.utils.GTFOUtils;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import java.util.Collections;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;

public class GTFOMaterialHandler {
    public static final PropertyKey<FertilizerProperty> FERTILIZER = new PropertyKey("gtfo_fertilizer", FertilizerProperty.class);
    public static final PropertyKey<LacingProperty> LACING = new PropertyKey("gtfo_lacing", LacingProperty.class);
    public static final PropertyKey<CleanerProperty> CLEANER = new PropertyKey("gtfo_cleaner", CleanerProperty.class);
    private static final Int2BooleanMap FOOD_RELATED_MATERIALS = new Int2BooleanArrayMap();
    public static final Material IsopropylChloride = GTFOMaterialHandler.fluidBuilder(21500, "isopropyl_chloride").components(new Object[]{Materials.Carbon, 3, Materials.Hydrogen, 7, Materials.Chlorine, 1}).build().setFormula("(CH3)2CHCl", true);
    public static final Material LemonExtract = GTFOMaterialHandler.fluidBuilderFood(21501, "lemon_extract").color(16574474).build();
    public static final Material LimeExtract = GTFOMaterialHandler.fluidBuilderFood(21502, "lime_extract").color(8778264).build();
    public static final Material OrangeExtract = GTFOMaterialHandler.fluidBuilderFood(21503, "orange_extract").color(16736512).build();
    public static final Material AppleExtract = GTFOMaterialHandler.fluidBuilderFood(21504, "apple_extract").color(15317592).build();
    public static final Material AppleCider = GTFOMaterialHandler.fluidBuilderFood(21505, "apple_cider").color(GTFOUtils.averageRGB(2.0f, 15317592, Materials.FermentedBiomass.getMaterialRGB())).build();
    public static final Material UnheatedCaneSyrup = GTFOMaterialHandler.fluidBuilderFood(21506, "unheated_cane_syrup").color(15790052).build();
    public static final Material CaneSyrup = GTFOMaterialHandler.fluidBuilderFood(21507, "cane_syrup").color(15921628).build();
    public static final Material PurpleDrink = GTFOMaterialHandler.fluidBuilderFood(21508, "purple_drink").color(11798015).build();
    public static final Material FryingOil = GTFOMaterialHandler.fluidBuilderFood(21509, "frying_oil").color(16769953).build();
    public static final Material HotFryingOil = GTFOMaterialHandler.fluidBuilderFood(21510, "hot_frying_oil", 483).color(16765286).build();
    public static final Material StarchFilledWater = GTFOMaterialHandler.fluidBuilder(21511, "starch_filled_water").color(13749182).build();
    public static final Material MushroomSoup = GTFOMaterialHandler.fluidBuilderFood(21512, "mushroom_soup", 343).color(15583919).build();
    public static final Material BeetrootSoup = GTFOMaterialHandler.fluidBuilderFood(21513, "beetroot_soup", 343).color(12734770).build();
    public static final Material ItalianBuffaloMilk = GTFOMaterialHandler.fluidBuilder(21514, "italian_buffalo_milk").color(16579573).build();
    public static final Material CrudeRennetSolution = GTFOMaterialHandler.fluidBuilder(21515, "crude_rennet_solution").color(11559706).build();
    public static final Material Whey = GTFOMaterialHandler.fluidBuilder(21516, "whey").color(16117658).build();
    public static final Material ActivatedBuffaloMilk = GTFOMaterialHandler.fluidBuilder(21517, "activated_buffalo_milk").color(0xFFF8CC).build();
    public static final Material WheySaltWaterMix = GTFOMaterialHandler.fluidBuilder(21518, "whey_salt_water_mix").color(15531134).build();
    public static final Material HeatedRicottaStarter = GTFOMaterialHandler.fluidBuilder(21519, "heated_ricotta_starter", 348).color(14612271).build();
    public static final Material AcidicMilkSolution = GTFOMaterialHandler.fluidBuilder(21520, "acidic_milk_solution").color(11716380).build();
    public static final Material CoagulatingRicottaSolution = GTFOMaterialHandler.fluidBuilder(21521, "coagulating_ricotta_solution").color(15726025).build();
    public static final Material TomatoSauce = GTFOMaterialHandler.fluidBuilderFood(21522, "tomato_sauce").color(16523799).build();
    public static final Material OliveOil = GTFOMaterialHandler.fluidBuilderFood(21523, "olive_oil").color(13753178).build();
    public static final Material Sludge = GTFOMaterialHandler.fluidBuilder(21524, "sludge").color(2364427).build();
    public static final Material AlkalineExtract = GTFOMaterialHandler.fluidBuilder(21525, "alkaline_extract").color(0x121110).build();
    public static final Material PotatoJuice = GTFOMaterialHandler.fluidBuilder(21526, "potato_juice").color(7891784).build();
    public static final Material Vodka = GTFOMaterialHandler.fluidBuilder(21527, "vodka").color(8218931).build();
    public static final Material Leninade = GTFOMaterialHandler.fluidBuilderFood(21528, "leninade").color(8545821).build();
    public static final Material PerchloricAcid = GTFOMaterialHandler.fluidBuilder(21529, "perchloric_acid", FluidAttributes.ACID).components(new Object[]{Materials.Hydrogen, 1, Materials.Chlorine, 1, Materials.Oxygen, 4}).build();
    public static final Material ChloroauricAcid = GregTechAPI.materialManager.getMaterial("chloroauric_acid") != null ? GregTechAPI.materialManager.getMaterial("chloroauric_acid") : GTFOMaterialHandler.fluidBuilder(21530, "chloroauric_acid", FluidAttributes.ACID).components(new Object[]{Materials.Hydrogen, 1, Materials.Gold, 1, Materials.Chlorine, 4}).build();
    public static final Material MoistAir = GTFOMaterialHandler.gasBuilder(21531, "moist_air", 273).color(8571135).build();
    public static final Material ColdMoistAir = GTFOMaterialHandler.gasBuilder(21532, "cold_moist_air", 243).color(7512831).build();
    public static final Material Albumen = GTFOMaterialHandler.fluidBuilderFood(21533, "albumen").color(0xFFFEF7).build();
    public static final Material Yolk = GTFOMaterialHandler.fluidBuilderFood(21534, "yolk").color(0xFFDF00).build();
    public static final Material Butter = GTFOMaterialHandler.fluidBuilderFood(21535, "butter").color(16772994).build();
    public static final Material RabbitStew = GTFOMaterialHandler.fluidBuilderFood(21536, "rabbit_stew", 343).color(14729376).build();
    public static final Material Stearin = GTFOMaterialHandler.fluidBuilder(21537, "stearin").color(0xFFCC66).flags(new MaterialFlag[]{MaterialFlags.DISABLE_DECOMPOSITION}).components(new Object[]{Materials.Carbon, 57, Materials.Hydrogen, 110, Materials.Oxygen, 6}).build();
    public static final Material SodiumStearate = GTFOMaterialHandler.fluidBuilder(21539, "sodium_stearate").components(new Object[]{Materials.Carbon, 18, Materials.Hydrogen, 35, Materials.Oxygen, 2, Materials.Sodium, 1}).flags(new MaterialFlag[]{MaterialFlags.DISABLE_DECOMPOSITION}).build().setFormula("C17H35COONa", true);
    public static final Material CitricAcid = GTFOMaterialHandler.fluidBuilder(21540, "citric_acid", FluidAttributes.ACID).color(13417825).components(new Object[]{Materials.Carbon, 5, Materials.Hydrogen, 7, Materials.Oxygen, 5}).build().setFormula("HOC(CH2CO2H)2", true);
    public static final Material HydrogenCyanide = GregTechAPI.materialManager.getMaterial("hydrogen_cyanide") != null ? GregTechAPI.materialManager.getMaterial("hydrogen_cyanide") : GTFOMaterialHandler.fluidBuilder(21541, "hydrogen_cyanide").color(7236190).components(new Object[]{Materials.Hydrogen, 1, Materials.Carbon, 1, Materials.Nitrogen, 1}).build();
    public static final Material Cream = GTFOMaterialHandler.fluidBuilderFood(21542, "cream").color(13554393).build();
    public static final Material SkimmedMilk = GTFOMaterialHandler.fluidBuilderFood(21543, "skimmed_milk").color(16252899).build();
    public static final Material SoyLecithin = GTFOMaterialHandler.fluidBuilder(21544, "soy_lecithin").color(10917434).build();
    public static final Material RawSoybeanOil = GTFOMaterialHandler.fluidBuilder(21545, "raw_soybean_oil").color(11359256).build();
    public static final Material HydratedSoybeanOil = GTFOMaterialHandler.fluidBuilder(21546, "hydrated_soybean_oil").color(13212797).build();
    public static final Material SoybeanOil = GTFOMaterialHandler.fluidBuilder(21547, "soybean_oil").color(15262889).build();
    public static final Material PasteurizedMilk = GTFOMaterialHandler.fluidBuilderFood(21548, "pasteurized_milk").color(16711155).build();
    public static final Material MilkColloid = GTFOMaterialHandler.fluidBuilderFood(21549, "milk_colloid").color(14735295).build();
    public static final Material IceCreamMixture = GTFOMaterialHandler.fluidBuilderFood(21550, "ice_cream_mixture").color(14597504).build();
    public static final Material Guaiacol = GTFOMaterialHandler.fluidBuilder(21551, "guaiacol").color(10893824).components(new Object[]{Materials.Carbon, 7, Materials.Hydrogen, 8, Materials.Oxygen, 2}).build();
    public static final Material Acetaldehyde = GTFOMaterialHandler.fluidBuilder(21552, "acetaldehyde").color(15987441).components(new Object[]{Materials.Carbon, 2, Materials.Hydrogen, 4, Materials.Oxygen, 1}).build();
    public static final Material Glyoxal = GTFOMaterialHandler.fluidBuilder(21553, "glyoxal").color(13223851).components(new Object[]{Materials.Carbon, 2, Materials.Hydrogen, 2, Materials.Oxygen, 2}).build();
    public static final Material GlyoxylicAcid = GTFOMaterialHandler.fluidBuilder(21554, "glyoxylic_acid", FluidAttributes.ACID).color(14276000).components(new Object[]{Materials.Carbon, 2, Materials.Hydrogen, 2, Materials.Oxygen, 3}).build();
    public static final Material MelonExtract = GTFOMaterialHandler.fluidBuilderFood(21555, "melon_extract").color(16546198).build();
    public static final Material MoltenUnsweetenedChocolate = GTFOMaterialHandler.fluidBuilderFood(21556, "molten_unsweetened_chocolate", 370).color(8077056).build();
    public static final Material CocoaButter = GTFOMaterialHandler.fluidBuilderFood(21557, "cocoa_butter").color(15064014).build();
    public static final Material MoltenDarkChocolate = GTFOMaterialHandler.fluidBuilderFood(21558, "molten_dark_chocolate", 360).color(4784646).build();
    public static final Material MoltenMilkChocolate = GTFOMaterialHandler.fluidBuilderFood(21559, "molten_milk_chocolate", 350).color(8672828).build();
    public static final Material SodiumArseniteSolution = GTFOMaterialHandler.fluidBuilder(21560, "sodium_arsenite_solution").color(GTFOUtils.averageRGB(2.0f, Materials.SodaAsh.getMaterialRGB(), Materials.Arsenic.getMaterialRGB())).components(new Object[]{Materials.Sodium, 1, Materials.Arsenic, 1, Materials.Oxygen, 2}).flags(new MaterialFlag[]{MaterialFlags.DISABLE_DECOMPOSITION}).build();
    public static final Material RubberSap = GTFOMaterialHandler.fluidBuilder(21561, "rubber_sap").color(16250588).build();
    public static final Material RainbowSap = GTFOMaterialHandler.fluidBuilderCustom(21562, "rainbow_sap").color(0xFFFFFF).build();
    public static final Material BlueVitriol = GregTechAPI.materialManager.getMaterial("blue_vitriol") != null ? GregTechAPI.materialManager.getMaterial("blue_vitriol") : GTFOMaterialHandler.fluidBuilder(21563, "blue_vitriol").color(4342494).components(new Object[]{Materials.Copper, 1, Materials.Sulfur, 1, Materials.Oxygen, 4}).build();
    public static final Material BakingSodaSolution = GTFOMaterialHandler.fluidBuilder(21564, "baking_soda_solution").color(Materials.SodiumBicarbonate.getMaterialRGB()).components(new Object[]{Materials.SodiumBicarbonate, 1, Materials.Water, 1}).flags(new MaterialFlag[]{MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING}).build();
    public static final Material BeerBatter = GTFOMaterialHandler.fluidBuilderFood(21565, "beer_batter").color(14995392).build();
    public static final Material WheatyJuice = GTFOMaterialHandler.fluidBuilderFood(21566, "wheaty_juice").color(11041624).build();
    public static final Material PoorQualityBeer = GTFOMaterialHandler.fluidBuilderFood(21567, "poor_quality_beer").color(11041624).build();
    public static final Material SodiumSulfate = new Material.Builder(21568, GTFOMaterialHandler.gtfoId("sodium_sulfate")).dust().components(new Object[]{Materials.Sodium, 2, Materials.Sulfur, 1, Materials.Oxygen, 4}).build();
    public static final Material Blood = GTFOMaterialHandler.fluidBuilder(21569, "blood", 310).color(6887957).build();
    public static final Material FertilizerSolution = GTFOMaterialHandler.fluidBuilder(21570, "fertilizer_solution").color(9729888).build();
    public static final Material Nilk = GTFOMaterialHandler.fluidBuilderFood(21571, "nilk").color(0x252626).build();
    public static final Material HighFructoseCornSyrupSolution = GTFOMaterialHandler.fluidBuilder(21572, "hfcs_solution").color(14924832).build();
    public static final Material XPhenothiazineIiPropylChloride = GTFOMaterialHandler.fluidBuilder(21573, "x_phenothiazine_ii_propyl_chloride").components(new Object[]{Materials.Carbon, 15, Materials.Hydrogen, 14, Materials.Nitrogen, 1, Materials.Sulfur, 1, Materials.Chlorine, 1}).flags(new MaterialFlag[]{MaterialFlags.DISABLE_DECOMPOSITION}).build();
    public static final Material AppleSyrup = GTFOMaterialHandler.fluidBuilderFood(21574, "apple_syrup").color(15917484).build();
    public static final Material AppleCandySyrup = GTFOMaterialHandler.fluidBuilderFood(21575, "apple_candy_syrup").color(15201710).build();
    public static final Material Etirps = GTFOMaterialHandler.fluidBuilderFood(21576, "etirps").color(11599731).build();
    public static final Material LemonLimeSodaSyrup = GTFOMaterialHandler.fluidBuilderFood(21577, "lemon_lime_soda_syrup").color(7798541).build();
    public static final Material CarbonatedWater = GTFOMaterialHandler.fluidBuilderFood(21578, "carbonated_water").color(0xF5FFFF).build();
    public static final Material CoughSyrup = GTFOMaterialHandler.fluidBuilder(21579, "cough_syrup").color(6036318).build();
    public static final Material LemonLimeSolution = GTFOMaterialHandler.fluidBuilderFood(21580, "lemon_lime_solution").color(12442458).build();
    public static final Material LemonLimeSludge = GTFOMaterialHandler.fluidBuilderFood(21581, "lemon_lime_sludge").color(7837958).build();
    public static final Material Aniline = GTFOMaterialHandler.fluidBuilder(21582, "aniline").color(5017885).components(new Object[]{Materials.Carbon, 6, Materials.Hydrogen, 7, Materials.Nitrogen, 1}).flags(new MaterialFlag[]{MaterialFlags.DISABLE_DECOMPOSITION}).build().setFormula("C6H5NH2", true);
    public static final Material HeatedWater = GTFOMaterialHandler.fluidBuilderFood(21583, "heated_water", 343).color(150406).build();
    public static final Material GelatinSolution = GTFOMaterialHandler.fluidBuilderFood(21584, "gelatin_solution").color(0xD3D3D3).build();
    public static final Material AceticAnhydride = GTFOMaterialHandler.fluidBuilder(21585, "acetic_anhydride").components(new Object[]{Materials.Carbon, 4, Materials.Hydrogen, 6, Materials.Oxygen, 3}).build();
    public static final Material Nitrophenols = GTFOMaterialHandler.fluidBuilder(21586, "nitrophenols").color(0xFFFFFF).build().setFormula("(C6H5NO3)(C6H5NO3)", true);
    public static final Material Egg = GTFOMaterialHandler.fluidBuilderFood(21587, "egg").color(0xFFFF0F).build();
    public static final Material UnpasteurizedSkimmedMilk = GTFOMaterialHandler.fluidBuilderFood(21588, "unpasteurized_skimmed_milk").color(0xFCFCF0).build();
    public static final Material ParmigianoReggianoStarter = GTFOMaterialHandler.fluidBuilder(21589, "parmigiano_reggiano_starter").color(15788736).build();
    public static final Material CurdlingParmigianoReggiano = GTFOMaterialHandler.fluidBuilder(21590, "curdling_parmigiano_reggiano").color(16774315).build();
    public static final Material Agrodolce = GTFOMaterialHandler.fluidBuilderFood(21591, "agrodolce").color(12194864).build();
    public static final Material Polenta = GTFOMaterialHandler.fluidBuilderFood(21592, "polenta").color(12298308).build();
    public static final Material Pesto = GTFOMaterialHandler.fluidBuilderFood(21593, "pesto").color(3182631).build();
    public static final Material BechamelSauce = GTFOMaterialHandler.fluidBuilderFood(21594, "bechamel_sauce").color(13744044).build();
    public static final Material ChickenBroth = GTFOMaterialHandler.fluidBuilderFood(21595, "chicken_broth").color(10772493).build();
    public static final Material VitelloTonnatoSauce = GTFOMaterialHandler.fluidBuilderFood(21596, "vitello_tonnato_sauce").color(13023934).build();
    public static final Material WhiteWine = GTFOMaterialHandler.fluidBuilder(21597, "white_wine").color(14139993).build();
    public static final Material MaceratedWhiteGrapes = GTFOMaterialHandler.fluidBuilder(21598, "macerated_white_grapes").color(9215297).build();
    public static final Material PressedWhiteWort = GTFOMaterialHandler.fluidBuilder(21599, "pressed_white_wort").color(14611327).build();
    public static final Material ClarifiedWhiteWort = GTFOMaterialHandler.fluidBuilder(21600, "clarified_white_wort").color(14214308).build();
    public static final Material VitelloTonnatoFlavorant = GTFOMaterialHandler.fluidBuilderFood(21601, "vitello_tonnato_flavorant").color(12758192).build();
    public static final Material RafanataMixture = GTFOMaterialHandler.fluidBuilderFood(21602, "rafanata_mixture").color(14463545).build();
    public static final Material CarbonaraSauce = GTFOMaterialHandler.fluidBuilderFood(21603, "carbonara_sauce").color(13479748).build();
    public static final Material PastaEFagioliBase = GTFOMaterialHandler.fluidBuilderFood(21604, "pasta_e_fagioli_base", 343).color(13916463).build();
    public static final Material MixedPastaEFagioli = GTFOMaterialHandler.fluidBuilderFood(21605, "mixed_pasta_e_fagioli", 343).color(14976552).build();
    public static final Material RedGrapesMust = GTFOMaterialHandler.fluidBuilder(21606, "red_grapes_must").color(13837650).build();
    public static final Material FermentedRedGrapesMust = GTFOMaterialHandler.fluidBuilder(21607, "fermented_red_grapes_must").color(11023185).build();
    public static final Material AlcoholicRedGrapeJuice = GTFOMaterialHandler.fluidBuilder(21608, "alcoholic_red_grape_juice").color(10747946).build();
    public static final Material RedWine = GTFOMaterialHandler.fluidBuilder(21609, "red_wine").color(6557990).build();
    public static final Material BologneseSauce = GTFOMaterialHandler.fluidBuilderFood(21610, "bolognese_sauce").color(7875092).build();
    public static final Material TomatoBologneseSauce = GTFOMaterialHandler.fluidBuilderFood(21611, "tomato_bolognese_sauce").color(13244687).build();
    public static final Material CranberryExtract = GTFOMaterialHandler.fluidBuilderFood(21612, "cranberry_extract").color(9178402).build();
    public static final Material EtirpsCranberry = GTFOMaterialHandler.fluidBuilderFood(21613, "etirps_cranberry").color(GTFOUtils.averageRGB(2.0f, CranberryExtract.getMaterialRGB(), 0xBBDDBB)).build();
    public static final Material CranberrySludge = GTFOMaterialHandler.fluidBuilderFood(21614, "cranberry_sludge").color(GTFOUtils.averageRGB(2.0f, CranberryExtract.getMaterialRGB(), 0x222222)).build();
    public static final Material CranberrySodaSyrup = GTFOMaterialHandler.fluidBuilderFood(21615, "cranberry_soda_syrup").color(GTFOUtils.averageRGB(2.0f, CranberryExtract.getMaterialRGB(), 0x333333)).build();
    public static final Material LingonberryJam = GTFOMaterialHandler.fluidBuilderFood(21616, "lingonberry_jam").color(6366765).build();
    public static final Material ElderberryJam = GTFOMaterialHandler.fluidBuilderFood(21617, "elderberry_jam").color(6242639).build();
    public static final Material SourCream = GTFOMaterialHandler.fluidBuilderFood(21618, "sour_cream").color(14933661).build();
    public static final Material LacticAcidBacteria = GTFOMaterialHandler.fluidBuilder(21619, "lactic_acid_bacteria").color(3608640).build();
    public static final Material FungalRennetSolution = GTFOMaterialHandler.fluidBuilder(21620, "fungal_rennet_solution").color(2784090).build();
    public static final Material EnderPearlSolution = GTFOMaterialHandler.fluidBuilder(21621, "ender_pearl_solution").components(new Object[]{Materials.EnderPearl, 1, Materials.Water, 1}).color(Materials.EnderPearl.getMaterialRGB()).build();
    public static final Material EnderSugarSolution = GTFOMaterialHandler.fluidBuilder(21622, "ender_sugar_solution").components(new Object[]{Materials.Beryllium, 1, Materials.Nitrogen, 2, Materials.Potassium, 1, Materials.Water, 1}).color(GTFOUtils.averageRGB(2.0f, EnderPearlSolution.getMaterialRGB(), Materials.Beryllium.getMaterialRGB())).build();
    public static final Material ChorusJuice = GTFOMaterialHandler.fluidBuilder(21623, "chorus_juice").color(10907872).build();
    public static final Material FermentedChorusJuice = GTFOMaterialHandler.fluidBuilder(21624, "fermented_chorus_juice").color(11921638).build();
    public static final Material Antaf = GTFOMaterialHandler.fluidBuilder(21625, "antaf").color(13940200).build();
    public static final Material VibrantExtract = GTFOMaterialHandler.fluidBuilder(21626, "vibrant_extract").color(4063223).build();
    public static final Material ApricotExtract = GTFOMaterialHandler.fluidBuilder(21627, "apricot_extract").color(14933661).build();
    public static final Material GrapeExtract = GTFOMaterialHandler.fluidBuilder(21628, "grape_extract").color(11023185).build();
    public static final Material SweetenedDilutedCaneSyrupMixture = GTFOMaterialHandler.fluidBuilder(21970, "sweetened_diluted_cane_syrup_mixture").color(14605512).build();
    public static final Material MarshmallowSyrupMixture = GTFOMaterialHandler.fluidBuilder(21971, "marshmallow_syrup_mixture").color(15130844).build();
    public static final Material MarshmallowFoam = GTFOMaterialHandler.fluidBuilder(21972, "marshmallow_foam").color(15130844).build();
    public static final Material SodiumCarbonateSolution = GTFOMaterialHandler.fluidBuilder(21973, "sodium_carbonate_solution").color(GTFOUtils.averageRGB(2.0f, 0xAAAAAA, Materials.SodaAsh.getMaterialRGB())).flags(new MaterialFlag[]{MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING}).components(new Object[]{Materials.Water, 1, Materials.SodaAsh, 1}).build();
    public static final Material Coffee = GTFOMaterialHandler.fluidBuilderFood(21990, "coffee", 368).color(3551534).build();
    public static final Material EnergizedCoffee = GTFOMaterialHandler.fluidBuilderFood(21991, "energized_coffee", 368).color(6904116).build();
    public static final MetaOreDictItem.OreDictValueItem COFFEE_GROUNDS = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1017, "coffee_grounds", 1709586, MaterialIconSet.DULL, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem SMALL_ROASTED_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1018, "roasted_coffee_small", 1709586, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem LARGE_ROASTED_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1019, "roasted_coffee_large", 1709586, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem SMALL_GRADED_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1020, "graded_coffee_small", 6511701, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem LARGE_GRADED_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1021, "graded_coffee_large", 6511701, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem SMALL_HULLED_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1022, "hulled_coffee_small", 8211222, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem LARGE_HULLED_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1023, "hulled_coffee_large", 8211222, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem SMALL_DRIED_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1024, "dried_coffee_small", 9201730, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem LARGE_DRIED_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1025, "dried_coffee_large", 9201730, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem SMALL_WET_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1026, "wet_coffee_small", 7693394, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem LARGE_WET_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1027, "wet_coffee_large", 7693394, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem SMALL_BASIC_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1028, "basic_coffee_small", 3875341, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem LARGE_BASIC_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1029, "basic_coffee_large", 3875341, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem UNSORTED_BASIC_COFFEE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1030, "basic_coffee_unsorted", 4333571, MaterialIconSet.GEM_VERTICAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem HotAppleHardCandy = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1084, "hot_apple_hard_candy", 7922475, MaterialIconSet.DULL, OrePrefix.plate);
    public static final MetaOreDictItem.OreDictValueItem CrushedHardCandy = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1093, "crushed_hard_candy", 5415682, MaterialIconSet.DULL, OrePrefix.crushed);
    public static final MetaOreDictItem.OreDictValueItem Promethazine = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1094, "promethazine", 16317150, MaterialIconSet.SAND, OrePrefix.dust, "C17H20N2S");
    public static final MetaOreDictItem.OreDictValueItem Codeine = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1095, "codeine", 16441074, MaterialIconSet.SAND, OrePrefix.dust, "C18H21NO3");
    public static final MetaOreDictItem.OreDictValueItem Phenothiazine = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1096, "phenothiazine", 6779740, MaterialIconSet.SAND, OrePrefix.dust, "C12H9NS");
    public static final MetaOreDictItem.OreDictValueItem Diphenylamine = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1097, "diphenylamine", 14914347, MaterialIconSet.SAND, OrePrefix.dust, "C12H11N");
    public static final MetaOreDictItem.OreDictValueItem CrushedPoppy = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1098, "crushed_poppy", 9701377, MaterialIconSet.ROUGH, OrePrefix.dust, "You monster.");
    public static final MetaOreDictItem.OreDictValueItem HardCandyPlate = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1099, "hard_candy", 7922475, MaterialIconSet.ROUGH, OrePrefix.plate);
    public static final MetaOreDictItem.OreDictValueItem HardCandyResin = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1100, "hard_candy", 7922475, MaterialIconSet.ROUGH, OrePrefix.plateDense);
    public static final MetaOreDictItem.OreDictValueItem Zest = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1092, "zest", 14221130, MaterialIconSet.SAND, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem PotatoStarch = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1101, "potato_starch", 14605489, MaterialIconSet.ROUGH, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem LargeMozzarellaCurd = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1102, "large_mozzarella_curd", 0xF5F5F5, MaterialIconSet.SHINY, OrePrefix.nugget);
    public static final MetaOreDictItem.OreDictValueItem SmallMozzarellaCurd = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1103, "small_mozzarella_curd", 0xF5F5F5, MaterialIconSet.SHINY, OrePrefix.nugget);
    public static final MetaOreDictItem.OreDictValueItem DriedMozzarellaCurd = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1104, "dried_mozzarella_curd", 16119012, MaterialIconSet.SHINY, OrePrefix.nugget);
    public static final MetaOreDictItem.OreDictValueItem SolidifiedMozzarellaCurd = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1105, "solidified_mozzarella_curd", 15592394, MaterialIconSet.SHINY, OrePrefix.nugget);
    public static final MetaOreDictItem.OreDictValueItem CoagulatedMilkCurd = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1106, "coagulated_milk_curd", 15590348, MaterialIconSet.SHINY, OrePrefix.nugget);
    public static final MetaOreDictItem.OreDictValueItem CutCurd = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1107, "cut_curd", 15590348, MaterialIconSet.SHINY, OrePrefix.round);
    public static final MetaOreDictItem.OreDictValueItem CookedCurd = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1108, "cooked_curd", 16771251, MaterialIconSet.SHINY, OrePrefix.round);
    public static final MetaOreDictItem.OreDictValueItem SaltedCurd = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1109, "salted_curd", 16242315, MaterialIconSet.SHINY, OrePrefix.round);
    public static final MetaOreDictItem.OreDictValueItem GorgonzolaCurd = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1110, "gorgonzola_curd", 0xE5E5F5, MaterialIconSet.SHINY, OrePrefix.nugget);
    public static final MetaOreDictItem.OreDictValueItem PenicilliumRoqueforti = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1111, "penicillium_roqueforti", 2784090, MaterialIconSet.ROUGH, OrePrefix.dust, "Bacteria");
    public static final MetaOreDictItem.OreDictValueItem BurntBananaPeel = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1112, "burnt_banana_peel", 0x121110, MaterialIconSet.ROUGH, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem AmmoniumPerchlorate = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1113, "ammonium_perchlorate", GTFOUtils.averageRGB(4.0f, Materials.Ammonia.getMaterialRGB(), Materials.Chlorine.getMaterialRGB(), Materials.Oxygen.getMaterialRGB(), Materials.Hydrogen.getMaterialRGB()), MaterialIconSet.DULL, OrePrefix.dust, "NH4ClO4");
    public static final MetaOreDictItem.OreDictValueItem PotassiumPerchlorate = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1114, "potassium_perchlorate", GTFOUtils.averageRGB(2.0f, AmmoniumPerchlorate.getMaterialRGB(), Materials.Potassium.getMaterialRGB()), MaterialIconSet.ROUGH, OrePrefix.dust, "KClO4");
    public static final MetaOreDictItem.OreDictValueItem MashedPotato = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1115, "mashed_potato", 16111775, MaterialIconSet.FINE, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem ToughMeat = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1116, "tough_meat", 10891304, MaterialIconSet.ROUGH, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem KubideMeat = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1117, "kubide_meat", 10159616, GTFOValues.Organic, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem BargMeat = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1118, "barg_meat", 0x7F0000, GTFOValues.Organic, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem Fat = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1119, "fat", 0xFFF200, GTFOValues.Organic, OrePrefix.ingot, "C57H110O6");
    public static final MetaOreDictItem.OreDictValueItem MeatIngot = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1120, "cooked_meat", 10891304, MaterialIconSet.ROUGH, OrePrefix.ingot);
    public static final MetaOreDictItem.OreDictValueItem SodiumPerchlorate = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1121, "sodium_perchlorate", GTFOUtils.averageRGB(3.0f, Materials.Sodium.getMaterialRGB(), Materials.Oxygen.getMaterialRGB(), 0xFFFFFF), MaterialIconSet.ROUGH, OrePrefix.dust, "NaClO4");
    public static final GTFOProxyItem SodiumChlorate = new GTFOProxyItem(() -> GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1122, "sodium_chlorate", GTFOUtils.averageRGB(2.0f, Materials.Sodium.getMaterialRGB(), Materials.Oxygen.getMaterialRGB()), MaterialIconSet.ROUGH, OrePrefix.dust, "NaClO3"), 1122, "sodium_chlorate", () -> OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)GregTechAPI.materialManager.getMaterial("sodium_chlorate")));
    public static final MetaOreDictItem.OreDictValueItem VanillylmandelicAcid = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1123, "vanillylmandelic_acid", 15921085, MaterialIconSet.ROUGH, OrePrefix.dust, "C9H10O5");
    public static final MetaOreDictItem.OreDictValueItem VanilglycolicAcid = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1124, "vanilglycolic_acid", 15460260, MaterialIconSet.DULL, OrePrefix.dust, "C9H8O5");
    public static final MetaOreDictItem.OreDictValueItem Vanillin = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1125, "vanillin", 0xFBFBFB, MaterialIconSet.SHINY, OrePrefix.dust, "C8H8O3");
    public static final GTFOProxyItem ArsenicTrioxide = new GTFOProxyItem(() -> GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1126, "arsenic_trioxide", GTFOUtils.averageRGB(2.0f, Materials.Arsenic.getMaterialRGB(), Materials.Oxygen.getMaterialRGB()), MaterialIconSet.ROUGH, OrePrefix.dust, "As2O3"), 1126, "arsenic_trioxide", () -> OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)GregTechAPI.materialManager.getMaterial("arsenic_trioxide")));
    public static final MetaOreDictItem.OreDictValueItem CupricHydrogenArsenite = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1127, "cupric_hydrogen_arsenite", 1048320, MaterialIconSet.SHINY, OrePrefix.dust, "CuHAsO3");
    public static final MetaOreDictItem.OreDictValueItem LaminatedDough = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1128, "laminated_dough", 13022395, MaterialIconSet.DULL, OrePrefix.plate);
    public static final MetaOreDictItem.OreDictValueItem CookedMinceMeat = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1129, "cooked_mince_meat", 4598565, MaterialIconSet.ROUGH, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem Aminophenol = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1130, "aminophenol", 0xFFFFFF, MaterialIconSet.SHINY, OrePrefix.dust, "C6H7NO");
    public static final MetaOreDictItem.OreDictValueItem IVNitrophenol = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1131, "ivnitrophenol", 0xFFFFE0, MaterialIconSet.SHINY, OrePrefix.dust, "C6H5NO3");
    public static final MetaOreDictItem.OreDictValueItem IINitrophenol = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1132, "iinitrophenol", 0xFFFF00, MaterialIconSet.SHINY, OrePrefix.dust, "C6H5NO3");
    public static final MetaOreDictItem.OreDictValueItem ShreddedParmesan = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1133, "shredded_parmesan", 14407348, MaterialIconSet.DULL, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem BlackPepper = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1134, "black_pepper", 131855, MaterialIconSet.DULL, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem Nutmeg = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1135, "nutmeg", 3742220, MaterialIconSet.DULL, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem GratedHorseradishRoot = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1136, "grated_horseradish_root", 15061697, MaterialIconSet.DULL, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem BoneChinaClay = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1137, "bone_china_clay", 0xEEC1C1, MaterialIconSet.DULL, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem BareCornKernel = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1001, "corn_kernel_bare", 16698208, MaterialIconSet.GEM_HORIZONTAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem CornKernel = GTFOMetaItems.SHAPED_ITEM.addFoodOreDictItem(1000, "corn_kernel", 16771696, MaterialIconSet.GEM_HORIZONTAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem SodiumCyanide = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1138, "sodium_cyanide", GTFOUtils.averageRGB(2.0f, HydrogenCyanide.getMaterialRGB(), Materials.Sodium.getMaterialRGB()), MaterialIconSet.DULL, OrePrefix.dust, "NaCN");
    public static final MetaOreDictItem.OreDictValueItem LithiumOxide = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1139, "lithium_oxide", GTFOUtils.averageRGB(2.0f, Materials.Lithium.getMaterialRGB(), 0), MaterialIconSet.DULL, OrePrefix.dust, "Li2O");
    public static final GTFOProxyItem LithiumCarbonate = new GTFOProxyItem(() -> GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1140, "lithium_carbonate", GTFOUtils.averageRGB(2.0f, Materials.Lithium.getMaterialRGB(), Materials.CarbonDioxide.getMaterialRGB()), MaterialIconSet.DULL, OrePrefix.dust, "Li2CO3"), 1140, "lithium_carbonate", () -> OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)GregTechAPI.materialManager.getMaterial("lithium_carbonate")));
    public static final MetaOreDictItem.OreDictValueItem BoneAsh = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1141, "bone_ash", 0xFEFDFE, MaterialIconSet.DULL, OrePrefix.dust);
    public static final MetaOreDictItem.OreDictValueItem UnfiredPorcelainTile = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1142, "unfired_porcelain_tile", 0xC2C2C4, MaterialIconSet.ROUGH, OrePrefix.plate);
    public static final MetaOreDictItem.OreDictValueItem BiscuitPorcelainTile = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1143, "bisque_porcelain_tile", 0xFEFEE8, MaterialIconSet.ROUGH, OrePrefix.plate);
    public static final MetaOreDictItem.OreDictValueItem GlazedPorcelainTile = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1144, "glazed_porcelain_tile", 0xEEEEEE, MaterialIconSet.SHINY, OrePrefix.plate);
    public static final MetaOreDictItem.OreDictValueItem BlackGlazedPorcelainTile = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1145, "black_glazed_porcelain_tile", 0x111111, MaterialIconSet.SHINY, OrePrefix.plate);
    public static final MetaOreDictItem.OreDictValueItem COCOA_HULL = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1035, "cocoa_hull", 3550245, MaterialIconSet.GEM_HORIZONTAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem COCOA_NIB = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1036, "cocoa_nib", 6510915, MaterialIconSet.GEM_HORIZONTAL, OrePrefix.gemChipped);
    public static final MetaOreDictItem.OreDictValueItem CHOCOLATE_LIQUOR = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1037, "chocolate_liquor", 6510915, GTFOValues.Organic, OrePrefix.crushed);
    public static final MetaOreDictItem.OreDictValueItem CHOCOLATE_LIQUOR_REFINED = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1038, "chocolate_liquor_refined", 6313256, GTFOValues.Organic, OrePrefix.crushed);
    public static final MetaOreDictItem.OreDictValueItem CHOCOLATE_LIQUOR_DUTCHED = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1039, "chocolate_liquor_dutched", 6902083, GTFOValues.Organic, OrePrefix.crushed);
    public static final MetaOreDictItem.OreDictValueItem PRESS_CAKE_DUTCHED = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1040, "press_cake_dutched", 10059374, MaterialIconSet.DULL, OrePrefix.plateDense);
    public static final MetaOreDictItem.OreDictValueItem PRESS_CAKE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1041, "press_cake", 9734273, MaterialIconSet.DULL, OrePrefix.plateDense);
    public static final MetaOreDictItem.OreDictValueItem PRESS_CAKE_GRADED = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1042, "press_cake_graded", 10911592, MaterialIconSet.DULL, OrePrefix.plateDense);
    public static final MetaOreDictItem.OreDictValueItem HOT_MILK_CHOCOLATE = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1043, "milk_chocolate", 6515809, MaterialIconSet.DULL, OrePrefix.ingotHot);
    public static final MetaOreDictItem.OreDictValueItem MATTER_MARSHMALLOW = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1044, "matter_marshmallow", 15130844, GTFOValues.Organic, OrePrefix.crushed);
    public static final MetaOreDictItem.OreDictValueItem MATTER_GRAHAM = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1045, "matter_graham", 15778397, GTFOValues.Organic, OrePrefix.crushed);
    public static final MetaOreDictItem.OreDictValueItem MATTER_GRAHAM_HOT = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1046, "matter_graham_hot", 16769441, GTFOValues.Organic, OrePrefix.crushed);
    public static final MetaOreDictItem.OreDictValueItem CHUNK_GRAHAM_HOT = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1047, "matter_graham_hot", 16769441, MaterialIconSet.DULL, OrePrefix.plateDense);
    public static final MetaOreDictItem.OreDictValueItem WAFER_GRAHAM_HOT = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1048, "matter_graham_hot", 16769441, MaterialIconSet.DULL, OrePrefix.plate);
    public static final MetaOreDictItem.OreDictValueItem CRACKER_GRAHAM_UNGRADED = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1049, "cracker_graham_ungraded", 15778397, MaterialIconSet.DULL, OrePrefix.plate);
    public static final MetaOreDictItem.OreDictValueItem CHOCOLATE_LIQUOR_PRESSED = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1050, "chocolate_liquor_pressed", 10910042, GTFOValues.Organic, OrePrefix.crushed);
    public static final MetaOreDictItem.OreDictValueItem CHOCOLATE_LIQUOR_DUTCHED_PRESSED = GTFOMetaItems.SHAPED_ITEM.addOreDictItem(1051, "chocolate_liquor_dutched_pressed", 11236688, GTFOValues.Organic, OrePrefix.crushed);
    public static final Material Paracetamol = new Material.Builder(21900, GTFOMaterialHandler.gtfoId("paracetamol")).dust().color(17824).iconSet(MaterialIconSet.SHINY).components(new Object[]{Materials.Carbon, 8, Materials.Hydrogen, 9, Materials.Nitrogen, 1, Materials.Oxygen, 2}).build();

    public static void onMaterialsInit() {
        Materials.Iron.addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_FRAME});
        Materials.BismuthBronze.addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_FRAME});
        Materials.Aluminium.addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_DENSE});
        Materials.StainlessSteel.addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_DENSE, MaterialFlags.GENERATE_SPRING_SMALL});
        Materials.Titanium.addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_DENSE});
        Materials.Aluminium.addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_DENSE});
        Materials.Water.setProperty(FERTILIZER, (IMaterialProperty)new FertilizerProperty(5));
        Blood.setProperty(FERTILIZER, (IMaterialProperty)new FertilizerProperty(30));
        FertilizerSolution.setProperty(FERTILIZER, (IMaterialProperty)new FertilizerProperty(15));
        Materials.DistilledWater.setProperty(CLEANER, (IMaterialProperty)new CleanerProperty(2));
        SodiumStearate.setProperty(CLEANER, (IMaterialProperty)new CleanerProperty(16));
        ChorusJuice.setFormula("(C6H12O6)?", true);
    }

    public static Material.Builder fluidBuilder(int id, String name) {
        return new Material.Builder(id, GTFOMaterialHandler.gtfoId("gtfo_" + name)).liquid();
    }

    public static Material.Builder fluidBuilderFood(int id, String name) {
        FOOD_RELATED_MATERIALS.put(id, true);
        return new Material.Builder(id, GTFOMaterialHandler.gtfoId("gtfo_" + name)).liquid();
    }

    public static Material.Builder fluidBuilderFood(int id, String name, int temp) {
        FOOD_RELATED_MATERIALS.put(id, true);
        return new Material.Builder(id, GTFOMaterialHandler.gtfoId("gtfo_" + name)).liquid(new FluidBuilder().temperature(temp));
    }

    public static Material.Builder fluidBuilderCustom(int id, String name) {
        return new Material.Builder(id, GTFOMaterialHandler.gtfoId("gtfo_" + name)).liquid(new FluidBuilder().customStill());
    }

    public static Material.Builder gasBuilder(int id, String name, int temp) {
        return new Material.Builder(id, GTFOMaterialHandler.gtfoId("gtfo_" + name)).gas(new FluidBuilder().temperature(temp));
    }

    public static Material.Builder fluidBuilder(int id, String name, FluidAttribute attribute) {
        return new Material.Builder(id, GTFOMaterialHandler.gtfoId("gtfo_" + name)).liquid(new FluidBuilder().attribute(attribute));
    }

    public static Material.Builder fluidBuilder(int id, String name, int temp) {
        return new Material.Builder(id, GTFOMaterialHandler.gtfoId("gtfo_" + name)).liquid(new FluidBuilder().temperature(temp));
    }

    public static void registerPropertyTooltips() {
        for (Material material : GregTechAPI.materialManager.getRegisteredMaterials()) {
            CleanerProperty cleanerProperty;
            LacingProperty lacingProperty;
            FertilizerProperty fertilizerProperty = (FertilizerProperty)material.getProperty(FERTILIZER);
            if (fertilizerProperty != null) {
                FluidTooltipUtil.registerTooltip((Fluid)material.getFluid(), () -> Collections.singletonList(LocalizationUtils.format((String)"gregtechfoodoption.fluid.fertilizer", (Object[])new Object[]{fertilizerProperty.getBoostPercentage()})));
            }
            if ((lacingProperty = (LacingProperty)material.getProperty(LACING)) != null) {
                FluidTooltipUtil.registerTooltip((Fluid)material.getFluid(), () -> Collections.singletonList(LocalizationUtils.format((String)"gregtechfoodoption.fluid.lacing", (Object[])new Object[0])));
            }
            if ((cleanerProperty = (CleanerProperty)material.getProperty(CLEANER)) == null) continue;
            FluidTooltipUtil.registerTooltip((Fluid)material.getFluid(), () -> Collections.singletonList(LocalizationUtils.format((String)"gregtechfoodoption.fluid.cleaning", (Object[])new Object[]{cleanerProperty.getCleaningPower()})));
        }
    }

    public static ResourceLocation gtfoId(String path) {
        return new ResourceLocation("gregtech", path);
    }

    public static boolean isFoodRelated(Material material) {
        return FOOD_RELATED_MATERIALS.containsKey(material.getId());
    }
}

