/*
 * Decompiled with CFR 0.152.
 */
package io.github.yamporg.darkness.asm;

import io.github.yamporg.darkness.ModConfig;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;

public final class EntityRendererHooks {
    public static void onUpdateLightmap(EntityRenderer renderer, float partialTicks) {
        if (!renderer.field_78536_aa) {
            return;
        }
        WorldClient world = renderer.field_78531_r.field_71441_e;
        if (world == null) {
            return;
        }
        if (renderer.field_78531_r.field_71439_g.func_70644_a(MobEffects.field_76439_r)) {
            return;
        }
        if (world.func_175658_ac() > 0) {
            return;
        }
        if (EntityRendererHooks.blacklistDim(world.field_73011_w)) {
            return;
        }
        EntityRendererHooks.updateLuminance(renderer, partialTicks, (World)world);
    }

    private static boolean blacklistDim(WorldProvider dim) {
        DimensionType dimType = dim.func_186058_p();
        if (dimType == DimensionType.THE_END && !ModConfig.darkEnd) {
            return true;
        }
        return EntityRendererHooks.blacklistContains(dim, dimType) ^ ModConfig.invertBlacklist;
    }

    private static boolean blacklistContains(WorldProvider dim, DimensionType dimType) {
        String dimName = dimType.func_186065_b();
        for (String blacklistName : ModConfig.blacklistByName) {
            if (!blacklistName.equals(dimName)) continue;
            return true;
        }
        int dimID = dim.getDimension();
        for (int blacklistID : ModConfig.blacklistByID) {
            if (dimID != blacklistID) continue;
            return true;
        }
        return false;
    }

    private static boolean isDark(WorldProvider dim, DimensionType dimType) {
        if (dimType == DimensionType.OVERWORLD) {
            return ModConfig.darkOverworld;
        }
        if (dimType == DimensionType.NETHER) {
            return ModConfig.darkNether;
        }
        if (dimType == DimensionType.THE_END) {
            return ModConfig.darkEnd;
        }
        if (dim.func_191066_m()) {
            return ModConfig.darkDefault;
        }
        return ModConfig.darkSkyless;
    }

    private static float getMoonBrightness(float partialTicks, World world) {
        float[] phaseFactors;
        int moonPhase;
        WorldProvider dim = world.field_73011_w;
        DimensionType dimType = dim.func_186058_p();
        if (!EntityRendererHooks.isDark(dim, dimType)) {
            return 1.0f;
        }
        if (!dim.func_191066_m()) {
            return 0.0f;
        }
        float angle = world.func_72826_c(partialTicks);
        if (angle <= 0.25f || 0.75f <= angle) {
            return 1.0f;
        }
        float moon = !ModConfig.hardcore ? ((moonPhase = dim.func_76559_b(world.func_72820_D())) < (phaseFactors = ModConfig.moonPhaseFactors).length ? phaseFactors[moonPhase] : world.func_130001_d()) : 0.0f;
        float w = angle <= 0.3f || 0.7f <= angle ? 20.0f * (Math.abs(angle - 0.5f) - 0.2f) : 0.0f;
        return EntityRendererHooks.lerp(w * w, moon, 1.0f);
    }

    private static void updateLuminance(EntityRenderer renderer, float partialTicks, World world) {
        WorldProvider dim = world.field_73011_w;
        DimensionType dimType = dim.func_186058_p();
        float[] brightnessTable = dim.func_177497_p();
        boolean dimDark = EntityRendererHooks.isDark(dim, dimType);
        float sunBrightness = world.func_72971_b(1.0f);
        float moonBrightness = EntityRendererHooks.getMoonBrightness(partialTicks, world);
        for (int i = 0; i < 256; ++i) {
            int skyIndex = i / 16;
            int blockIndex = i % 16;
            float skyFactor = 1.0f - (float)skyIndex / 15.0f;
            skyFactor = 1.0f - skyFactor * skyFactor * skyFactor * skyFactor;
            float min = (skyFactor *= moonBrightness) * 0.05f;
            float rawAmbient = sunBrightness * skyFactor;
            float minAmbient = rawAmbient * (1.0f - min) + min;
            float skyBase = brightnessTable[skyIndex] * minAmbient;
            min = 0.35f * skyFactor;
            float skyRed = skyBase * (rawAmbient * (1.0f - min) + min);
            float skyGreen = skyBase * (rawAmbient * (1.0f - min) + min);
            float skyBlue = skyBase;
            if (renderer.field_82831_U > 0.0f) {
                float d = renderer.field_82831_U - renderer.field_82832_V;
                float m = renderer.field_82832_V + partialTicks * d;
                skyRed = skyRed * (1.0f - m) + skyRed * 0.7f * m;
                skyGreen = skyGreen * (1.0f - m) + skyGreen * 0.6f * m;
                skyBlue = skyBlue * (1.0f - m) + skyBlue * 0.6f * m;
            }
            float blockFactor = 1.0f;
            if (dimDark) {
                blockFactor = 1.0f - (float)blockIndex / 15.0f;
                blockFactor = 1.0f - blockFactor * blockFactor * blockFactor * blockFactor;
            }
            float flicker = renderer.field_78514_e * 0.1f + 1.5f;
            float blockBase = blockFactor * brightnessTable[blockIndex] * flicker;
            min = 0.4f * blockFactor;
            float blockGreen = blockBase * ((blockBase * (1.0f - min) + min) * (1.0f - min) + min);
            float blockBlue = blockBase * (blockBase * blockBase * (1.0f - min) + min);
            float red = skyRed + blockBase;
            float green = skyGreen + blockGreen;
            float blue = skyBlue + blockBlue;
            float f = Math.max(skyFactor, blockFactor);
            min = 0.03f * f;
            red = red * (0.99f - min) + min;
            green = green * (0.99f - min) + min;
            blue = blue * (0.99f - min) + min;
            if (dimType == DimensionType.THE_END) {
                red = skyFactor * 0.22f + blockBase * 0.75f;
                green = skyFactor * 0.28f + blockGreen * 0.75f;
                blue = skyFactor * 0.25f + blockBlue * 0.75f;
            }
            red = MathHelper.func_76131_a((float)red, (float)0.0f, (float)1.0f);
            green = MathHelper.func_76131_a((float)green, (float)0.0f, (float)1.0f);
            blue = MathHelper.func_76131_a((float)blue, (float)0.0f, (float)1.0f);
            float gamma = renderer.field_78531_r.field_71474_y.field_74333_Y * f;
            float invRed = 1.0f - red;
            float invGreen = 1.0f - green;
            float invBlue = 1.0f - blue;
            invRed = 1.0f - invRed * invRed * invRed * invRed;
            invGreen = 1.0f - invGreen * invGreen * invGreen * invGreen;
            invBlue = 1.0f - invBlue * invBlue * invBlue * invBlue;
            red = red * (1.0f - gamma) + invRed * gamma;
            green = green * (1.0f - gamma) + invGreen * gamma;
            blue = blue * (1.0f - gamma) + invBlue * gamma;
            min = 0.03f * f;
            red = red * (0.99f - min) + min;
            green = green * (0.99f - min) + min;
            blue = blue * (0.99f - min) + min;
            red = MathHelper.func_76131_a((float)red, (float)0.0f, (float)1.0f);
            green = MathHelper.func_76131_a((float)green, (float)0.0f, (float)1.0f);
            blue = MathHelper.func_76131_a((float)blue, (float)0.0f, (float)1.0f);
            float lTarget = EntityRendererHooks.luminance(red, green, blue);
            int c = renderer.field_78504_Q[i];
            renderer.field_78504_Q[i] = EntityRendererHooks.darken(c, lTarget);
        }
    }

    private static int darken(int c, float lTarget) {
        float r = (float)(c & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c >> 16 & 0xFF) / 255.0f;
        float l = EntityRendererHooks.luminance(r, g, b);
        if (l <= 0.0f) {
            return c;
        }
        if (lTarget >= l) {
            return c;
        }
        float f = lTarget / l;
        c = -16777216;
        c |= Math.round(f * r * 255.0f);
        c |= Math.round(f * g * 255.0f) << 8;
        return c |= Math.round(f * b * 255.0f) << 16;
    }

    private static float luminance(float r, float g, float b) {
        return r * 0.2126f + g * 0.7152f + b * 0.0722f;
    }

    private static float lerp(float f, float g, float h) {
        return g + f * (h - g);
    }
}

