/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders.util;

public class MathHelper {
    public static int clamp(int x, int a, int b) {
        return Math.max(Math.min(x, b), a);
    }

    public static float clamp(float x, float a, float b) {
        return Math.max(Math.min(x, b), a);
    }

    public static double clamp(double x, double a, double b) {
        return Math.max(Math.min(x, b), a);
    }

    public static float lerp(float a, float b, float t) {
        return a * (1.0f - t) + b * t;
    }

    public static float clampedLerp(float a, float b, float t) {
        return MathHelper.lerp(a, b, MathHelper.clamp(t, 0.0f, 1.0f));
    }

    public static float easeInOutQuad(float t) {
        return (double)t < 0.5 ? 2.0f * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 2.0) / 2.0f;
    }

    public static float easeInOutQuad(float a, float b, float t) {
        return MathHelper.lerp(a, b, MathHelper.easeInOutQuad(t));
    }

    public static float clampedEaseInOutQuad(float t) {
        return MathHelper.easeInOutQuad(MathHelper.clamp(t, 0.0f, 1.0f));
    }

    public static float clampedEaseInOutQuad(float a, float b, float t) {
        return MathHelper.lerp(a, b, MathHelper.clampedEaseInOutQuad(t));
    }

    public static float easeOutCubic(float t) {
        return 1.0f - (float)Math.pow(1.0f - t, 3.0);
    }

    public static float easeOutCubic(float a, float b, float t) {
        return MathHelper.lerp(a, b, MathHelper.easeOutCubic(t));
    }

    public static float clampedEaseOutCubic(float t) {
        return MathHelper.easeOutCubic(MathHelper.clamp(t, 0.0f, 1.0f));
    }

    public static float clampedEaseOutCubic(float a, float b, float t) {
        return MathHelper.lerp(a, b, MathHelper.clampedEaseOutCubic(t));
    }
}

