/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders.util;

import bedrockbreaker.graduatedcylinders.api.IProxyFluidStack;
import bedrockbreaker.graduatedcylinders.util.MathHelper;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiFluidSprite
extends Gui {
    public IProxyFluidStack fluidStack;
    public TextureAtlasSprite sprite;
    public int tankIndex;
    public int renderIndex;
    public float x = 0.0f;
    public float y = 0.0f;
    public float width = 0.0f;
    public float height = 0.0f;
    public int color = -1;
    public float transitionLength = 5.0f;
    public float elapsedTime = 5.0f;
    public float startX = 0.0f;
    public float startY = 0.0f;
    public float startWidth = 0.0f;
    public float startHeight = 0.0f;
    public int startOpacity = 255;
    public float endX = 0.0f;
    public float endY = 0.0f;
    public float endWidth = 0.0f;
    public float endHeight = 0.0f;
    public int endOpacity = 255;

    public GuiFluidSprite(IProxyFluidStack fluidStack, float x, float y, float width, float height, int tankIndex, int renderIndex) {
        this.sprite = fluidStack.getSprite();
        this.fluidStack = fluidStack;
        this.tankIndex = tankIndex;
        this.renderIndex = renderIndex;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = fluidStack.getColor();
        this.startX = x;
        this.startY = y;
        this.startWidth = width;
        this.startHeight = height;
        this.startOpacity = this.color;
        this.endX = x;
        this.endY = y;
        this.endWidth = width;
        this.endHeight = height;
        this.endOpacity = this.color;
    }

    public void render(float partialTicks) {
        this.elapsedTime += partialTicks;
        float t = this.elapsedTime / this.transitionLength;
        this.x = this.x == this.endX ? this.x : (float)Math.round(MathHelper.clampedEaseInOutQuad(this.startX, this.endX, t));
        this.y = this.y == this.endY ? this.y : (float)Math.round(MathHelper.clampedEaseInOutQuad(this.startY, this.endY, t));
        this.width = this.width == this.endWidth ? this.width : (float)Math.round(MathHelper.clampedEaseInOutQuad(this.startWidth, this.endWidth, t));
        this.height = this.height == this.endHeight ? this.height : (float)Math.round(MathHelper.clampedEaseInOutQuad(this.startHeight, this.endHeight, t));
        int n = this.color = this.color >>> 24 == this.endOpacity ? this.color : this.color & 0xFFFFFF | Math.round(MathHelper.clampedEaseOutCubic(this.startOpacity, this.endOpacity, t)) << 24;
        if (this.color >>> 24 == 0) {
            return;
        }
        GlStateManager.func_179131_c((float)((float)(this.color >>> 16 & 0xFF) / 255.0f), (float)((float)(this.color >>> 8 & 0xFF) / 255.0f), (float)((float)(this.color & 0xFF) / 255.0f), (float)((float)(this.color >>> 24) / 255.0f));
        this.func_175175_a((int)this.x, (int)this.y, this.sprite, (int)this.width, (int)this.height);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setX(float x) {
        this.x = x;
        this.startX = x;
        this.endX = x;
    }

    public void setY(float y) {
        this.y = y;
        this.startY = y;
        this.endY = y;
    }

    public void setPos(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    public void animateMove(float x, float y) {
        this.startX = this.x;
        this.startY = this.y;
        this.endX = x;
        this.endY = y;
        this.elapsedTime = 0.0f;
    }

    public void setWidth(float width) {
        this.width = width;
        this.endWidth = width;
    }

    public void setHeight(float height) {
        this.height = height;
        this.endHeight = height;
    }

    public void setDimensions(float width, float height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void animateScale(float width, float height) {
        this.startWidth = this.width;
        this.endWidth = width;
        this.startHeight = this.height;
        this.endHeight = height;
        this.elapsedTime = 0.0f;
    }

    public void setOpacity(int opacity) {
        this.color = this.color & 0xFFFFFF | (opacity & 0xFF) << 24;
        this.endOpacity = opacity;
    }

    public void animateOpacity(int opacity) {
        this.startOpacity = this.color >>> 24;
        this.endOpacity = opacity;
        this.elapsedTime = 0.0f;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return (float)mouseX >= this.x && (float)mouseX < this.x + this.width && (float)mouseY >= this.y && (float)mouseY < this.y + this.height;
    }
}

