/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders.proxy.handler;

import bedrockbreaker.graduatedcylinders.api.IProxyFluidHandlerItem;
import bedrockbreaker.graduatedcylinders.api.IProxyFluidStack;
import bedrockbreaker.graduatedcylinders.api.IProxyTankProperties;
import bedrockbreaker.graduatedcylinders.proxy.handler.GasHandler;
import bedrockbreaker.graduatedcylinders.proxy.stack.GasStackGC;
import bedrockbreaker.graduatedcylinders.proxy.tankproperties.GasTankPropertiesItem;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class GasHandlerItem
implements IProxyFluidHandlerItem {
    protected IGasItem gasHandlerItem;
    protected ItemStack itemStack;

    public GasHandlerItem(IGasItem gasHandlerItem, ItemStack itemStack) {
        this.gasHandlerItem = gasHandlerItem;
        this.itemStack = itemStack;
    }

    @Override
    public GasStackGC loadFluidStackFromNBT(NBTTagCompound nbt) {
        GasStack gasStack = GasStack.readFromNBT((NBTTagCompound)nbt);
        return gasStack == null ? null : new GasStackGC(gasStack);
    }

    @Override
    public boolean isMatchingHandlerType(TileEntity tileEntity, EnumFacing side) {
        return tileEntity instanceof IGasHandler;
    }

    @Override
    public GasHandler getMatchingHandler(TileEntity tileEntity, EnumFacing side) {
        return new GasHandler((IGasHandler)tileEntity, side);
    }

    @Override
    public IProxyTankProperties getTankProperties(int tankIndex) {
        return new GasTankPropertiesItem(this.gasHandlerItem, this.itemStack);
    }

    @Override
    public int getNumTanks() {
        return 1;
    }

    @Override
    public int fill(IProxyFluidStack resource, boolean doFill) {
        if (!(resource instanceof GasStackGC)) {
            return 0;
        }
        GasStack resourceStack = ((GasStackGC)resource).gasStack;
        GasStack storedGas = this.gasHandlerItem.getGas(this.itemStack);
        if (resourceStack == null || resource.getAmount() <= 0 || storedGas != null && !resourceStack.isGasEqual(storedGas)) {
            return 0;
        }
        int toFill = Math.min(this.gasHandlerItem.getMaxGas(this.itemStack) - (storedGas == null ? 0 : storedGas.amount), resource.getAmount());
        if (toFill > 0 && doFill) {
            this.gasHandlerItem.setGas(this.itemStack, new GasStack(resourceStack.getGas(), toFill + (storedGas == null ? 0 : storedGas.amount)));
        }
        return toFill;
    }

    @Override
    @Nullable
    public GasStackGC drain(int maxAmount, boolean doDrain) {
        if (this.gasHandlerItem.getGas(this.itemStack) == null || maxAmount <= 0) {
            return null;
        }
        GasStack removedGas = new GasStack(this.gasHandlerItem.getGas(this.itemStack).getGas(), Math.min(this.gasHandlerItem.getGas((ItemStack)this.itemStack).amount, maxAmount));
        if (removedGas.amount <= 0) {
            return null;
        }
        if (doDrain) {
            this.gasHandlerItem.setGas(this.itemStack, new GasStack(removedGas.getGas(), this.gasHandlerItem.getGas((ItemStack)this.itemStack).amount - removedGas.amount));
        }
        return new GasStackGC(removedGas);
    }

    @Override
    @Nullable
    public GasStackGC drain(IProxyFluidStack resource, boolean doDrain) {
        if (!(resource instanceof GasStackGC)) {
            return null;
        }
        GasStack resourceStack = ((GasStackGC)resource).gasStack;
        if (resourceStack == null || resource.getAmount() <= 0 || !resourceStack.isGasEqual(this.gasHandlerItem.getGas(this.itemStack))) {
            return null;
        }
        GasStack removedGas = new GasStack(this.gasHandlerItem.getGas(this.itemStack).getGas(), Math.min(this.gasHandlerItem.getGas((ItemStack)this.itemStack).amount, resource.getAmount()));
        if (removedGas.amount <= 0) {
            return null;
        }
        if (doDrain) {
            this.gasHandlerItem.setGas(this.itemStack, new GasStack(removedGas.getGas(), this.gasHandlerItem.getGas((ItemStack)this.itemStack).amount - removedGas.amount));
        }
        return new GasStackGC(removedGas);
    }

    @Override
    public ItemStack getContainer() {
        return this.itemStack;
    }
}

