/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders.network;

import bedrockbreaker.graduatedcylinders.FluidTransferGui;
import bedrockbreaker.graduatedcylinders.api.IProxyFluidHandlerItem;
import bedrockbreaker.graduatedcylinders.api.IProxyFluidStack;
import bedrockbreaker.graduatedcylinders.util.BufferHelper;
import bedrockbreaker.graduatedcylinders.util.FluidHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketOpenFluidGUI
implements IMessage {
    private ItemStack heldItem;
    private BlockPos pos;
    private ArrayList<ArrayList<FluidHelper.TransferrableFluidResult>> transferResults = new ArrayList();
    private int heldTankIndex;
    private int side;
    private int blockTankIndex;
    private ArrayList<ArrayList<Integer>> blockTankCapacities = new ArrayList();
    private ArrayList<IProxyFluidStack> heldFluidStacks = new ArrayList();
    private ArrayList<ArrayList<IProxyFluidStack>> blockFluidStacks = new ArrayList();

    public PacketOpenFluidGUI() {
    }

    public PacketOpenFluidGUI(ItemStack heldItem, BlockPos pos, ArrayList<ArrayList<FluidHelper.TransferrableFluidResult>> transferResults, int heldTankIndex, int side, int blockTankIndex, ArrayList<ArrayList<Integer>> blockTankCapacities, ArrayList<IProxyFluidStack> heldFluidStacks, ArrayList<ArrayList<IProxyFluidStack>> blockFluidStacks) {
        this.heldItem = heldItem;
        this.pos = pos;
        this.transferResults = transferResults;
        this.heldTankIndex = heldTankIndex;
        this.side = side;
        this.blockTankIndex = blockTankIndex;
        this.blockTankCapacities = blockTankCapacities;
        this.heldFluidStacks = heldFluidStacks;
        this.blockFluidStacks = blockFluidStacks;
    }

    public void fromBytes(ByteBuf buffer) {
        try {
            this.heldItem = new ItemStack(ByteBufUtils.readTag((ByteBuf)buffer));
            this.pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            this.side = buffer.readInt();
            int numSidedTransferResults = buffer.readInt();
            for (int i = 0; i < numSidedTransferResults; ++i) {
                this.transferResults.add(new ArrayList());
                int numTransferResults = buffer.readInt();
                for (int j = 0; j < numTransferResults; ++j) {
                    this.transferResults.get(i).add(BufferHelper.readTransferrableFluidResult(buffer));
                }
            }
            IProxyFluidHandlerItem fluidHandler = FluidHelper.getProxyFluidHandler(this.heldItem);
            this.heldTankIndex = buffer.readInt();
            int numHeldFluidStacks = buffer.readInt();
            for (int i = 0; i < numHeldFluidStacks; ++i) {
                this.heldFluidStacks.add(BufferHelper.readFluidStack(buffer, fluidHandler));
            }
            this.blockTankIndex = buffer.readInt();
            int numSidedBlockTankCapacities = buffer.readInt();
            for (int i = 0; i < numSidedBlockTankCapacities; ++i) {
                int numBlockTankCapacities = buffer.readInt();
                this.blockTankCapacities.add(new ArrayList());
                for (int j = 0; j < numBlockTankCapacities; ++j) {
                    this.blockTankCapacities.get(i).add(buffer.readInt());
                }
            }
            int numSidedBlockFluidStacks = buffer.readInt();
            for (int i = 0; i < numSidedBlockFluidStacks; ++i) {
                int numBlockFluidStacks = buffer.readInt();
                this.blockFluidStacks.add(new ArrayList());
                for (int j = 0; j < numBlockFluidStacks; ++j) {
                    this.blockFluidStacks.get(i).add(BufferHelper.readFluidStack(buffer, fluidHandler));
                }
            }
        }
        catch (IndexOutOfBoundsException error) {
            System.out.println(error);
        }
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.heldItem.func_77955_b(new NBTTagCompound()));
        buffer.writeInt(this.pos.func_177958_n());
        buffer.writeInt(this.pos.func_177956_o());
        buffer.writeInt(this.pos.func_177952_p());
        buffer.writeInt(this.side);
        buffer.writeInt(this.transferResults.size());
        for (ArrayList<FluidHelper.TransferrableFluidResult> arrayList : this.transferResults) {
            buffer.writeInt(arrayList.size());
            for (FluidHelper.TransferrableFluidResult transferResult : arrayList) {
                BufferHelper.writeTransferrableFluidResult(buffer, transferResult);
            }
        }
        buffer.writeInt(this.heldTankIndex);
        buffer.writeInt(this.heldFluidStacks.size());
        for (IProxyFluidStack iProxyFluidStack : this.heldFluidStacks) {
            BufferHelper.writeFluidStack(buffer, iProxyFluidStack);
        }
        buffer.writeInt(this.blockTankIndex);
        buffer.writeInt(this.blockTankCapacities.size());
        for (ArrayList arrayList : this.blockTankCapacities) {
            buffer.writeInt(arrayList.size());
            for (Integer capacity : arrayList) {
                buffer.writeInt(capacity.intValue());
            }
        }
        buffer.writeInt(this.blockFluidStacks.size());
        for (ArrayList arrayList : this.blockFluidStacks) {
            buffer.writeInt(arrayList.size());
            for (IProxyFluidStack fluidStack : arrayList) {
                BufferHelper.writeFluidStack(buffer, fluidStack);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketOpenFluidGUI, IMessage> {
        public IMessage onMessage(PacketOpenFluidGUI message, MessageContext context) {
            if (context.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(context.netHandler).func_152344_a(() -> FluidTransferGui.open(message.heldItem, message.pos, message.transferResults, message.heldTankIndex, message.side, message.blockTankIndex, message.blockTankCapacities, message.heldFluidStacks, message.blockFluidStacks));
            return null;
        }
    }
}

