/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wile.engineersdecor.blocks.BlockDecorWall;

public class BlockDecorFence
extends BlockDecorWall {
    protected static final AxisAlignedBB[] AABB_BY_INDEX = BlockDecorFence.mkAABBs(1.5, 0.5, 16.0);
    protected static final AxisAlignedBB[] CLIP_AABB_BY_INDEX = BlockDecorFence.mkAABBs(1.5, 0.5, 24.0);
    protected static final AxisAlignedBB[][] AABB_LIST_BY_INDEX = BlockDecorFence.mkCAABBs(1.5, 0.5, 16.0);
    protected static final AxisAlignedBB[][] CLIP_AABB_LIST_BY_INDEX = BlockDecorFence.mkCAABBs(1.5, 0.5, 24.0);

    public BlockDecorFence(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound) {
        super(registryName, config, material, hardness, resistance, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_BY_INDEX[BlockDecorFence.getAABBIndex(this.func_176221_a(state, source, pos))];
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        AxisAlignedBB[] bbs = CLIP_AABB_LIST_BY_INDEX[BlockDecorFence.getAABBIndex(isActualState ? state : this.func_176221_a(state, (IBlockAccess)world, pos))];
        for (int i = 0; i < bbs.length; ++i) {
            BlockDecorFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bbs[i]);
        }
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return CLIP_AABB_BY_INDEX[BlockDecorFence.getAABBIndex(this.func_176221_a(state, world, pos))];
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP ? BlockFaceShape.CENTER : (face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.CENTER_SMALL);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, NORTH, EAST, WEST, SOUTH});
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean n = this.canWallConnectTo(world, pos, EnumFacing.NORTH);
        boolean e = this.canWallConnectTo(world, pos, EnumFacing.EAST);
        boolean s = this.canWallConnectTo(world, pos, EnumFacing.SOUTH);
        boolean w = this.canWallConnectTo(world, pos, EnumFacing.WEST);
        boolean nopole = n && s && !e && !w || !n && !s && e && w;
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(!nopole)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(n)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(e)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(s)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(w));
    }
}

