/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.render;

import alexiil.mc.mod.load.CLSLog;
import alexiil.mc.mod.load.json.ConfigManager;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.SimpleResource;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class FontRendererSeparate
extends FontRenderer {
    private static final BufferedImage EMPTY_IMAGE = new BufferedImage(1, 1, 5);
    private final Map<ResourceLocation, BufferedImage> textureData = new HashMap<ResourceLocation, BufferedImage>();
    private final Map<ResourceLocation, Integer> textureLocations = new HashMap<ResourceLocation, Integer>();
    private boolean __cls__replaced__underline;
    private boolean __cls__replaced__strikethrough;

    public FontRendererSeparate(GameSettings settings, ResourceLocation location, TextureManager textureManagerIn, boolean unicode) {
        super(settings, location, textureManagerIn, unicode);
        this.loadTex(location);
        for (int i = 0; i < 256; ++i) {
            if (i == 8 || 216 <= i && i <= 248) continue;
            this.loadTex(new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", i)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage loadTex(ResourceLocation location) {
        try (InputStream stream = ConfigManager.getInputStream(location);){
            BufferedImage img = TextureUtil.func_177053_a((InputStream)stream);
            if (img == null) {
                CLSLog.warn("Failed to read a texture from " + location + " - " + stream);
                BufferedImage bufferedImage2 = EMPTY_IMAGE;
                return bufferedImage2;
            }
            this.textureData.put(location, img);
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        catch (FileNotFoundException e) {
            CLSLog.warn("loadTex(" + location + ") : " + e);
            return EMPTY_IMAGE;
        }
        catch (IOException e) {
            CLSLog.warn("loadTex(" + location + ") : " + e);
            return EMPTY_IMAGE;
        }
    }

    protected void bindTexture(ResourceLocation location) {
        if (this.textureLocations == null) {
            return;
        }
        Integer value = this.textureLocations.get(location);
        if (value == null) {
            BufferedImage img = this.textureData.computeIfAbsent(location, this::loadTex);
            if (img == null || img == EMPTY_IMAGE) {
                CLSLog.warn("Non-cached texture: '" + location + "'");
                return;
            }
            int next = GL11.glGenTextures();
            TextureUtil.func_110987_a((int)next, (BufferedImage)img);
            this.textureLocations.put(location, next);
            value = next;
        }
        GL11.glBindTexture((int)3553, (int)value);
    }

    protected IResource getResource(ResourceLocation location) throws IOException {
        if ("config".equals(location.func_110624_b())) {
            InputStream stream = ConfigManager.getInputStream(location);
            InputStream metaStream = null;
            try {
                metaStream = ConfigManager.getInputStream(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".mcmeta"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new SimpleResource("cls config", location, stream, metaStream, Minecraft.func_71410_x().func_110438_M().field_110621_c);
        }
        return super.getResource(location);
    }

    public void destroy() {
        for (Integer value : this.textureLocations.values()) {
            GL11.glDeleteTextures((int)value);
        }
        this.textureLocations.clear();
    }

    protected void setColor(float r, float g, float b, float a) {
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    protected void enableAlpha() {
        GL11.glEnable((int)6406);
    }

    protected void doDraw(float width) {
        if (this.__cls__replaced__strikethrough || this.__cls__replaced__underline) {
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder bb = tess.func_178180_c();
            GL11.glDisable((int)3553);
            bb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            if (this.__cls__replaced__strikethrough) {
                int halfHeight = this.field_78288_b / 2;
                bb.func_181662_b((double)this.field_78295_j, (double)(this.field_78296_k + (float)halfHeight), 0.0).func_181675_d();
                bb.func_181662_b((double)(this.field_78295_j + width), (double)(this.field_78296_k + (float)halfHeight), 0.0).func_181675_d();
                bb.func_181662_b((double)(this.field_78295_j + width), (double)(this.field_78296_k + (float)halfHeight - 1.0f), 0.0).func_181675_d();
                bb.func_181662_b((double)this.field_78295_j, (double)(this.field_78296_k + (float)halfHeight - 1.0f), 0.0).func_181675_d();
            }
            if (this.__cls__replaced__underline) {
                bb.func_181662_b((double)(this.field_78295_j - 1.0f), (double)(this.field_78296_k + (float)this.field_78288_b), 0.0).func_181675_d();
                bb.func_181662_b((double)(this.field_78295_j + width), (double)(this.field_78296_k + (float)this.field_78288_b), 0.0).func_181675_d();
                bb.func_181662_b((double)(this.field_78295_j + width), (double)(this.field_78296_k + (float)this.field_78288_b - 1.0f), 0.0).func_181675_d();
                bb.func_181662_b((double)(this.field_78295_j - 1.0f), (double)(this.field_78296_k + (float)this.field_78288_b - 1.0f), 0.0).func_181675_d();
            }
            tess.func_78381_a();
            GL11.glEnable((int)3553);
        }
        this.field_78295_j += width;
    }
}

