/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.coremod;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClsTransformer
implements IClassTransformer,
Opcodes {
    public static final Logger LOG = LogManager.getLogger((String)"cls.transform");
    private static final String OWNER_MAIN_SPLASH_RENDERER;
    private static final String OWNER_ASM_CALLBACKS;
    private static final String MC_FONT_RENDERER = "net.minecraft.client.gui.FontRenderer";
    private static String fontRendererUnderlineName;
    private static String fontRendererStrikethroughName;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.equals("net.minecraftforge.fml.client.SplashProgress")) {
            return ClsTransformer.transformSplashProgress(basicClass);
        }
        if (name.equals("net.minecraftforge.fml.client.SplashProgress$Texture")) {
            return ClsTransformer.transformSplashProgress_Texture(basicClass);
        }
        if (name.startsWith("net.minecraftforge.fml.client.SplashProgress$")) {
            return ClsTransformer.transformSplashProgress_3(basicClass);
        }
        if (name.equals("alexiil.mc.mod.load.render.MainSplashRenderer")) {
            return ClsTransformer.transformMainSplashRenderer(basicClass);
        }
        if (name.equals("alexiil.mc.mod.load.render.FontRendererSeparate")) {
            return ClsTransformer.transformFontRendererSeparate(basicClass);
        }
        if (transformedName.equals(MC_FONT_RENDERER)) {
            return ClsTransformer.transformFontRenderer(basicClass);
        }
        return basicClass;
    }

    private static byte[] transformSplashProgress(byte[] before) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        for (FieldNode f : classNode.fields) {
            if (!f.name.equals("logoTexture")) continue;
            f.access = 9;
        }
        for (MethodNode m : classNode.methods) {
            String desc;
            String name;
            String owner;
            InsnList list;
            if (m.name.equals("finish")) {
                list = new InsnList();
                owner = OWNER_MAIN_SPLASH_RENDERER;
                name = "finish";
                desc = "()V";
                list.add((AbstractInsnNode)new MethodInsnNode(184, owner, name, desc, false));
                AbstractInsnNode from = null;
                for (AbstractInsnNode node : m.instructions) {
                    if (!(node instanceof MethodInsnNode)) continue;
                    MethodInsnNode method = (MethodInsnNode)node;
                    if (!method.name.equals("checkThreadState")) continue;
                    from = node;
                    break;
                }
                m.instructions.insert(from, list);
                continue;
            }
            if (m.name.equals("pause")) {
                list = new InsnList();
                list.add((AbstractInsnNode)new LdcInsnNode((Object)1));
                owner = OWNER_MAIN_SPLASH_RENDERER;
                name = "pause";
                desc = "Z";
                list.add((AbstractInsnNode)new FieldInsnNode(179, owner, name, desc));
                m.instructions.insert(list);
                continue;
            }
            if (!m.name.equals("resume")) continue;
            list = new InsnList();
            list.add((AbstractInsnNode)new LdcInsnNode((Object)0));
            owner = OWNER_MAIN_SPLASH_RENDERER;
            name = "pause";
            desc = "Z";
            list.add((AbstractInsnNode)new FieldInsnNode(179, owner, name, desc));
            m.instructions.insert(list);
        }
        ClsTransformer.changeLineNumbers(classNode);
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private static byte[] transformSplashProgress_3(byte[] before) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        String desc_resource_location = Type.getDescriptor(ResourceLocation.class);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("run")) continue;
            ListIterator iter = m.instructions.iterator();
            boolean found = false;
            while (iter.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)iter.next();
                if (found) {
                    iter.remove();
                    continue;
                }
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.name.equals("glDisable")) continue;
                found = true;
            }
            String owner = "net/minecraftforge/fml/client/SplashProgress";
            String name = "logoTexture";
            String desc = "Lnet/minecraftforge/fml/client/SplashProgress$Texture;";
            m.instructions.add((AbstractInsnNode)new FieldInsnNode(178, owner, name, desc));
            owner = OWNER_MAIN_SPLASH_RENDERER;
            name = "mojangLogoTex";
            m.instructions.add((AbstractInsnNode)new FieldInsnNode(179, owner, name, desc));
            m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            owner = classNode.name;
            name = "val$fontLoc";
            desc = desc_resource_location;
            m.instructions.add((AbstractInsnNode)new FieldInsnNode(180, owner, name, desc));
            owner = OWNER_MAIN_SPLASH_RENDERER;
            name = "fontLoc";
            desc = desc_resource_location;
            m.instructions.add((AbstractInsnNode)new FieldInsnNode(179, owner, name, desc));
            owner = OWNER_MAIN_SPLASH_RENDERER;
            name = "run";
            desc = "()V";
            m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, owner, name, desc, false));
            m.instructions.add((AbstractInsnNode)new InsnNode(177));
            m.tryCatchBlocks.clear();
        }
        ClsTransformer.changeLineNumbers(classNode);
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private static byte[] transformSplashProgress_Texture(byte[] before) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        classNode.access = 1;
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private static byte[] transformMainSplashRenderer(byte[] before) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        String nameTexture = "net/minecraftforge/fml/client/SplashProgress$Texture";
        String descTexture = "L" + nameTexture + ";";
        for (FieldNode field : classNode.fields) {
            if (!field.desc.contains("DummyTexture")) continue;
            field.desc = descTexture;
        }
        for (MethodNode method : classNode.methods) {
            for (AbstractInsnNode node : method.instructions) {
                if (node instanceof FieldInsnNode) {
                    FieldInsnNode fld = (FieldInsnNode)node;
                    if (!fld.desc.contains("DummyTexture")) continue;
                    fld.desc = descTexture;
                    continue;
                }
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode m = (MethodInsnNode)node;
                if (!m.owner.contains("DummyTexture")) continue;
                m.owner = nameTexture;
            }
        }
        ClsTransformer.changeLineNumbers(classNode);
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private static byte[] transformFontRendererSeparate(byte[] before) {
        LOG.info("Transforming CLS.FontRendererSeparate");
        if (fontRendererStrikethroughName.contains("ClsWentWrong")) {
            LOG.warn("Transformed before minecraft's FontRenderer!");
            LOG.warn(" (force-loading FontRenderer)");
            try {
                Class<?> cls = Class.forName(MC_FONT_RENDERER);
                if (cls == null) {
                    throw new IllegalStateException(MC_FONT_RENDERER);
                }
                LOG.info("Loaded " + cls);
            }
            catch (ClassNotFoundException e) {
                throw new Error(e);
            }
        }
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            for (AbstractInsnNode i : m.instructions) {
                if (!(i instanceof FieldInsnNode)) continue;
                FieldInsnNode fn = (FieldInsnNode)i;
                if ("__cls__replaced__underline".equals(fn.name)) {
                    fn.name = fontRendererUnderlineName;
                    continue;
                }
                if (!"__cls__replaced__strikethrough".equals(fn.name)) continue;
                fn.name = fontRendererStrikethroughName;
            }
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private static byte[] transformFontRenderer(byte[] before) {
        LOG.info("Transforming Minecraft.FontRenderer");
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        List fields = classNode.fields;
        ArrayList<FieldNode> boolFields = new ArrayList<FieldNode>();
        for (FieldNode n : fields) {
            if (!"Z".equals(n.desc) || (n.access & 8) != 0) continue;
            boolFields.add(n);
        }
        FieldNode fldUnderline = (FieldNode)boolFields.get(5);
        FieldNode fldStrike = (FieldNode)boolFields.get(6);
        fontRendererUnderlineName = fldUnderline.name;
        fontRendererStrikethroughName = fldStrike.name;
        if ((fldUnderline.access & 1) == 0) {
            fldUnderline.access &= 0xFFFFFFFD;
            fldUnderline.access |= 4;
        }
        if ((fldStrike.access & 1) == 0) {
            fldStrike.access &= 0xFFFFFFFD;
            fldStrike.access |= 4;
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private static void changeLineNumbers(ClassNode node) {
    }

    private static void changeLineNumbers(MethodNode m) {
        for (AbstractInsnNode insn : m.instructions) {
            if (!(insn instanceof LineNumberNode)) continue;
            LineNumberNode ln = (LineNumberNode)insn;
            ln.line += 10000;
        }
    }

    protected static void showMethod(MethodNode m, int from) {
        LOG.info("Showing Method...");
        for (int i = from; i < m.instructions.size(); ++i) {
            LOG.info("  -" + ClsTransformer.getInsn(m.instructions.get(i)));
        }
    }

    protected static MethodNode getMethod(ClassNode node, String name) {
        for (MethodNode m : node.methods) {
            if (!m.name.equals(name)) continue;
            return m;
        }
        return null;
    }

    protected static String getInsn(AbstractInsnNode ins) {
        if (ins instanceof MethodInsnNode) {
            MethodInsnNode n = (MethodInsnNode)ins;
            return n.owner + "," + n.name + "," + n.desc;
        }
        if (ins instanceof FieldInsnNode) {
            FieldInsnNode n = (FieldInsnNode)ins;
            return n.owner + "," + n.name + "," + n.desc;
        }
        if (ins instanceof VarInsnNode) {
            VarInsnNode n = (VarInsnNode)ins;
            return n.getOpcode() + " " + n.var;
        }
        return ins.getOpcode() + ":" + ins.getClass().getSimpleName();
    }

    static {
        fontRendererUnderlineName = "ClsWentWrong_Underline";
        fontRendererStrikethroughName = "ClsWentWrong_Strikethrough";
        OWNER_MAIN_SPLASH_RENDERER = "alexiil/mc/mod/load/render/MainSplashRenderer";
        OWNER_ASM_CALLBACKS = "alexiil/mc/mod/load/coremod/Callbacks";
    }
}

