/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load;

import alexiil.mc.mod.load.Translation;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ModLoadingListener {
    public static volatile ModStage stage = null;
    public static final List<String> modIds = new ArrayList<String>();
    private static final List<ModLoadingListener> listeners = new ArrayList<ModLoadingListener>();
    private final ModContainer mod;

    public static void setup() {
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            if (!(mod instanceof FMLModContainer)) continue;
            EventBus bus = null;
            try {
                Field f = FMLModContainer.class.getDeclaredField("eventBus");
                f.setAccessible(true);
                bus = (EventBus)f.get(mod);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (bus == null) continue;
            bus.register((Object)new ModLoadingListener(mod));
        }
    }

    public ModLoadingListener(ModContainer mod) {
        this.mod = mod;
        modIds.add(mod.getModId());
        listeners.add(this);
    }

    @Subscribe
    public void construct(FMLConstructionEvent event) {
        ModLoadingListener.doProgress(LoaderStage.CONSTRUCT, this);
    }

    @Subscribe
    public void preinit(FMLPreInitializationEvent event) {
        ModLoadingListener.doProgress(LoaderStage.PRE_INIT, this);
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        ModLoadingListener.doProgress(LoaderStage.INIT, this);
    }

    @Subscribe
    public void postinit(FMLPostInitializationEvent event) {
        ModLoadingListener.doProgress(LoaderStage.POST_INIT, this);
    }

    @Subscribe
    public void loadComplete(FMLLoadCompleteEvent event) {
        ModLoadingListener.doProgress(LoaderStage.LOAD_COMPLETE, this);
    }

    private static void doProgress(LoaderStage state, ModLoadingListener mod) {
        ModStage ms = stage;
        if (ms == null) {
            ms = mod == null ? new ModStage(state, 0) : new ModStage(state, listeners.indexOf(mod));
        }
        stage = ms.getNext();
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class ModStage {
        public final LoaderStage state;
        public final int index;

        public String toString() {
            return "ModStage [state=" + (Object)((Object)this.state) + ", index=" + this.index + "]";
        }

        public ModStage(LoaderStage state, int index) {
            this.state = state;
            this.index = index;
        }

        public ModStage getNext() {
            int ind = this.index + 1;
            LoaderStage s = this.state;
            if (ind == listeners.size() || s.isLoneState) {
                ind = 0;
                int ord = s.ordinal() + 1;
                if (ord == LoaderStage.values().length) {
                    return this;
                }
                s = LoaderStage.values()[ord];
                if (s.shouldSkip) {
                    return new ModStage(s, ind).getNext();
                }
            }
            return new ModStage(s, ind);
        }

        public String getDisplayText() {
            return this.state.translate();
        }

        public String getSubDisplayText() {
            if (this.state.isLoneState) {
                return "";
            }
            return ((ModLoadingListener)listeners.get(this.index)).mod.getName();
        }

        public int getSubProgress(int max) {
            return this.index * max / listeners.size();
        }
    }

    public static enum LoaderStage {
        CONSTRUCT("construction", 0),
        PRE_INIT("pre_initialization", 0),
        LITE_LOADER_INIT("lite", true, true, 0),
        INIT("initialization", 0),
        POST_INIT("post_initialization", 1),
        LOAD_COMPLETE("completed", 1);

        public final boolean isAfterReload1;
        private String translatedName = null;
        final String name;
        final boolean isLoneState;
        final boolean shouldSkip;

        private LoaderStage(String name, boolean loneState, boolean skip, int state) {
            this.isAfterReload1 = state > 0;
            this.isLoneState = loneState;
            this.name = name;
            this.shouldSkip = skip;
        }

        private LoaderStage(String name, int state) {
            this(name, false, false, state);
        }

        public String translate() {
            if (this.translatedName != null) {
                return this.translatedName;
            }
            this.translatedName = Translation.translate("customloadingscreen.modstate." + this.name);
            return this.translatedName;
        }
    }
}

