/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.shaded.org.jctools.queues.atomic.unpadded;

import github.kasuminova.stellarcore.shaded.org.jctools.queues.MessagePassingQueue;
import github.kasuminova.stellarcore.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import github.kasuminova.stellarcore.shaded.org.jctools.queues.atomic.unpadded.BaseSpscLinkedAtomicUnpaddedArrayQueue;
import github.kasuminova.stellarcore.shaded.org.jctools.util.Pow2;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SpscUnboundedAtomicUnpaddedArrayQueue<E>
extends BaseSpscLinkedAtomicUnpaddedArrayQueue<E> {
    public SpscUnboundedAtomicUnpaddedArrayQueue(int chunkSize) {
        AtomicReferenceArray buffer;
        int chunkCapacity = Math.max(Pow2.roundToPowerOfTwo(chunkSize), 16);
        long mask = chunkCapacity - 1;
        this.producerBuffer = buffer = AtomicQueueUtil.allocateRefArray(chunkCapacity + 1);
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
    }

    @Override
    final boolean offerColdPath(AtomicReferenceArray<E> buffer, long mask, long pIndex, int offset, E v, MessagePassingQueue.Supplier<? extends E> s) {
        long lookAheadStep = (mask + 1L) / 4L;
        long pBufferLimit = pIndex + lookAheadStep;
        if (null == AtomicQueueUtil.lvRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(pBufferLimit, mask))) {
            this.producerBufferLimit = pBufferLimit - 1L;
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else if (null == AtomicQueueUtil.lvRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(pIndex + 1L, mask))) {
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else {
            AtomicReferenceArray newBuffer;
            this.producerBuffer = newBuffer = AtomicQueueUtil.allocateRefArray((int)(mask + 2L));
            this.producerBufferLimit = pIndex + mask - 1L;
            this.linkOldToNew(pIndex, buffer, offset, newBuffer, offset, v == null ? s.get() : v);
        }
        return true;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill((MessagePassingQueue.Supplier)s, (int)this.producerMask);
    }

    @Override
    public int capacity() {
        return -1;
    }
}

