/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.tlm;

import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.BonesItem;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.CubesItem;
import github.kasuminova.stellarcore.client.pool.TLMCubesItemPool;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.mixin.util.CanonicalizationCubesItem;
import java.util.List;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BonesItem.class}, remap=false)
public class MixinBonesItem {
    @Shadow
    private List<Float> pivot;
    @Shadow
    private List<Float> rotation;
    @Shadow
    private List<CubesItem> cubes;
    @Unique
    private boolean stellar_core$canonicalized = false;

    @Inject(method={"getCubes"}, at={@At(value="HEAD")})
    private void injectGetCubes(CallbackInfoReturnable<List<CubesItem>> cir) {
        this.stellar_core$canonicalize();
    }

    @Inject(method={"getPivot"}, at={@At(value="HEAD")})
    private void injectGetPivot(CallbackInfoReturnable<List<Float>> cir) {
        this.stellar_core$canonicalize();
    }

    @Inject(method={"getRotation"}, at={@At(value="HEAD")})
    private void injectGetRotation(CallbackInfoReturnable<List<Float>> cir) {
        this.stellar_core$canonicalize();
    }

    @Unique
    private void stellar_core$canonicalize() {
        if (!StellarCoreConfig.PERFORMANCE.tlm.modelDataCanonicalization) {
            return;
        }
        if (!this.stellar_core$canonicalized) {
            TLMCubesItemPool.INSTANCE.canonicalizeAsync(this.pivot, canonicalizedPivot -> {
                this.pivot = canonicalizedPivot;
            });
            TLMCubesItemPool.INSTANCE.canonicalizeAsync(this.rotation, canonicalizedRotation -> {
                this.rotation = canonicalizedRotation;
            });
            if (this.cubes != null) {
                for (CubesItem cube : this.cubes) {
                    ((CanonicalizationCubesItem)cube).stellar_core$canonicalize();
                }
            }
            this.stellar_core$canonicalized = true;
        }
    }
}

