/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.techguns;

import com.google.gson.JsonObject;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import techguns.items.guns.GenericGun;
import techguns.recipes.AmmoSumRecipeFactory;

@Mixin(value={AmmoSumRecipeFactory.class})
public class MixinAmmoSumRecipe {
    @Shadow(remap=false)
    @Final
    protected static ResourceLocation GROUP;

    @Inject(method={"parse"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void parse(JsonContext context, JsonObject json, CallbackInfoReturnable<IRecipe> cir) {
        if (!StellarCoreConfig.BUG_FIXES.techguns.fixAmmoSumRecipeFactory) {
            return;
        }
        ShapedOreRecipe rec = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.height = rec.getRecipeHeight();
        primer.width = rec.getRecipeWidth();
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = rec.func_192400_c();
        cir.setReturnValue((Object)new ShapedOreRecipe(GROUP, rec.func_77571_b(), primer){

            @Nonnull
            public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
                int ammoSum = 0;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    Item item;
                    if (inv.func_70301_a(i).func_190926_b() || !((item = inv.func_70301_a(i).func_77973_b()) instanceof GenericGun)) continue;
                    GenericGun g = (GenericGun)item;
                    ammoSum += g.getCurrentAmmo(inv.func_70301_a(i));
                }
                ItemStack out = super.func_77572_b(inv);
                NBTTagCompound tags = out.func_77978_p();
                if (tags == null) {
                    tags = new NBTTagCompound();
                    out.func_77982_d(tags);
                }
                tags.func_74777_a("ammo", (short)ammoSum);
                return out;
            }
        });
    }
}

