/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.scalingguis;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import spazley.scalingguis.ScalingGUIs;
import spazley.scalingguis.config.JsonHelper;

@Mixin(value={JsonHelper.class})
public class MixinJsonHelper {
    @Shadow(remap=false)
    private static Gson GSON;

    @Inject(method={"getKeyList"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void getKeyList(JsonObject jsonObjectIn, CallbackInfoReturnable<List<String>> cir) {
        if (!StellarCoreConfig.BUG_FIXES.scalingGuis.fixJsonHelper) {
            return;
        }
        Map map = (Map)GSON.fromJson((JsonElement)jsonObjectIn, LinkedHashMap.class);
        ArrayList keyList = new ArrayList(map.keySet());
        keyList.removeIf(s -> !MixinJsonHelper.isClassExists(s));
        cir.setReturnValue(keyList);
    }

    @Unique
    private static boolean isClassExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception var6) {
            ScalingGUIs.logger.error("Unknown class '" + className + "'. Removing from check list. Will be left in json assets.scalingguis.file.", (Throwable)var6);
            return false;
        }
    }
}

