/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.nco;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.HashedItemStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BasicRecipeHandler.class}, remap=false)
public abstract class MixinBasicRecipeHandler
extends AbstractRecipeHandler<BasicRecipe> {
    @Shadow
    @Final
    public boolean isShapeless;
    @Unique
    private volatile Map<HashedItemStack, List<BasicRecipe>> stellar_core$itemRecipeCache = null;
    @Unique
    private volatile Map<FluidStack, List<BasicRecipe>> stellar_core$fluidRecipeCache = null;

    @Inject(method={"isValidItemInput(Lnet/minecraft/item/ItemStack;I)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectIsValidItemInput(ItemStack stack, int slot, CallbackInfoReturnable<Boolean> cir) {
        if (!StellarCoreConfig.PERFORMANCE.nuclearCraftOverhauled.basicRecipeImprovements) {
            return;
        }
        cir.setReturnValue((Object)this.stellar_core$isValidItemInput(stack, slot));
    }

    @Inject(method={"isValidFluidInput(Lnet/minecraftforge/fluids/FluidStack;I)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectIsValidFluidInput(FluidStack stack, int tankNumber, CallbackInfoReturnable<Boolean> cir) {
        if (!StellarCoreConfig.PERFORMANCE.nuclearCraftOverhauled.basicRecipeImprovements) {
            return;
        }
        cir.setReturnValue((Object)this.stellar_core$isValidFluidInput(stack, tankNumber));
    }

    @Unique
    private boolean stellar_core$isValidItemInput(ItemStack stack, int index) {
        BasicRecipe recipe;
        HashedItemStack hashedStack = HashedItemStack.ofMetaUnsafe(stack);
        List cached = this.stellar_core$getItemRecipeCache().get(hashedStack);
        if (cached != null && cached.size() > index && (recipe = cached.get(index)) != null && this.stellar_core$isItemRecipeValid(stack, index, recipe)) {
            return true;
        }
        for (BasicRecipe recipe2 : this.recipeList) {
            if (!this.stellar_core$isItemRecipeValid(stack, index, recipe2)) continue;
            if (cached == null) {
                cached = this.stellar_core$getItemRecipeCache().computeIfAbsent(hashedStack.copy(), k -> new ObjectArrayList());
            }
            while (cached.size() <= index) {
                cached.add(null);
            }
            cached.set(index, recipe2);
            return true;
        }
        return false;
    }

    @Unique
    private boolean stellar_core$isItemRecipeValid(ItemStack stack, int index, BasicRecipe recipe) {
        if (this.isShapeless) {
            for (IItemIngredient input : recipe.getItemIngredients()) {
                if (!input.match((Object)stack, IngredientSorption.NEUTRAL).matches()) continue;
                return true;
            }
        } else {
            return ((IItemIngredient)recipe.getItemIngredients().get(index)).match((Object)stack, IngredientSorption.NEUTRAL).matches();
        }
        return false;
    }

    @Unique
    private boolean stellar_core$isValidFluidInput(FluidStack stack, int index) {
        BasicRecipe recipe;
        List cached = this.stellar_core$getFluidRecipeCache().get(stack);
        if (cached != null && cached.size() > index && (recipe = cached.get(index)) != null && this.stellar_core$isFluidRecipeValid(stack, index, recipe)) {
            return true;
        }
        for (BasicRecipe recipe2 : this.recipeList) {
            if (!this.stellar_core$isFluidRecipeValid(stack, index, recipe2)) continue;
            if (cached == null) {
                cached = this.stellar_core$getFluidRecipeCache().computeIfAbsent(stack.copy(), k -> new ObjectArrayList());
            }
            while (cached.size() <= index) {
                cached.add(null);
            }
            cached.set(index, recipe2);
            return true;
        }
        return false;
    }

    @Unique
    private boolean stellar_core$isFluidRecipeValid(FluidStack stack, int index, BasicRecipe recipe) {
        if (this.isShapeless) {
            for (IFluidIngredient input : recipe.getFluidIngredients()) {
                if (!input.match((Object)stack, IngredientSorption.NEUTRAL).matches()) continue;
                return true;
            }
        } else {
            return ((IFluidIngredient)recipe.getFluidIngredients().get(index)).match((Object)stack, IngredientSorption.NEUTRAL).matches();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private Map<HashedItemStack, List<BasicRecipe>> stellar_core$getItemRecipeCache() {
        if (this.stellar_core$itemRecipeCache == null) {
            MixinBasicRecipeHandler mixinBasicRecipeHandler = this;
            synchronized (mixinBasicRecipeHandler) {
                if (this.stellar_core$itemRecipeCache == null) {
                    this.stellar_core$itemRecipeCache = Collections.synchronizedMap(new WeakHashMap());
                }
            }
        }
        return this.stellar_core$itemRecipeCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private Map<FluidStack, List<BasicRecipe>> stellar_core$getFluidRecipeCache() {
        if (this.stellar_core$fluidRecipeCache == null) {
            MixinBasicRecipeHandler mixinBasicRecipeHandler = this;
            synchronized (mixinBasicRecipeHandler) {
                if (this.stellar_core$fluidRecipeCache == null) {
                    this.stellar_core$fluidRecipeCache = Collections.synchronizedMap(new WeakHashMap());
                }
            }
        }
        return this.stellar_core$fluidRecipeCache;
    }
}

