/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.minecraft.texture_load;

import com.llamalad7.mixinextras.sugar.Local;
import github.kasuminova.stellarcore.client.texture.SpriteBufferedImageCache;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.StellarLog;
import github.kasuminova.stellarcore.shaded.org.jctools.maps.NonBlockingHashSet;
import github.kasuminova.stellarcore.shaded.org.jctools.maps.NonBlockingIdentityHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import net.minecraft.client.renderer.texture.ITextureMapPopulator;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TextureMap.class})
public abstract class MixinTextureMap {
    @Final
    @Shadow
    private Map<String, TextureAtlasSprite> field_110574_e;
    @Shadow
    private int field_147636_j;
    @Unique
    private int stellar_core$prevMipMapLevels;
    @Unique
    private Set<TextureAtlasSprite> stellar_core$cachedTextures;
    @Unique
    private Set<ResourceLocation> stellar_core$cachedLocations;

    @Shadow
    protected abstract ResourceLocation func_184396_a(TextureAtlasSprite var1);

    @Inject(method={"loadSprites"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/ITextureMapPopulator;registerSprites(Lnet/minecraft/client/renderer/texture/TextureMap;)V", shift=At.Shift.AFTER)})
    private void injectLoadSpritesAfter(IResourceManager resourceManager, ITextureMapPopulator iconCreatorIn, CallbackInfo ci) {
        SpriteBufferedImageCache.INSTANCE.clear();
        this.stellar_core$cachedTextures = Collections.newSetFromMap(new NonBlockingIdentityHashMap());
        this.stellar_core$cachedLocations = new NonBlockingHashSet<ResourceLocation>();
        Future<Integer> detectMaxMipmapLevelTask = this.stellar_core$initializeOptifineTask(resourceManager);
        this.field_110574_e.values().parallelStream().forEach(sprite -> {
            ResourceLocation location = this.func_184396_a((TextureAtlasSprite)sprite);
            if (sprite.hasCustomLoader(resourceManager, location)) {
                return;
            }
            IResource resource = null;
            try {
                PngSizeInfo pngSizeInfo = PngSizeInfo.func_188532_a((IResource)resourceManager.func_110536_a(location));
                resource = resourceManager.func_110536_a(location);
                boolean hasAnimation = resource.func_110526_a("animation") != null;
                sprite.func_188538_a(pngSizeInfo, hasAnimation);
                BufferedImage image = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
                int[] rgb = image.getRGB(0, 0, image.getWidth(), image.getHeight(), new int[image.getWidth() * image.getHeight()], 0, image.getWidth());
                SpriteBufferedImageCache.INSTANCE.put((TextureAtlasSprite)sprite, image, rgb);
                this.stellar_core$cachedTextures.add((TextureAtlasSprite)sprite);
                this.stellar_core$cachedLocations.add(location);
                if (resource != null) {
                    SpriteBufferedImageCache.INSTANCE.put((TextureAtlasSprite)sprite, resource);
                }
            }
            catch (Throwable e) {
                try {
                    StellarLog.LOG.warn((Object)e);
                    if (resource != null) {
                        SpriteBufferedImageCache.INSTANCE.put((TextureAtlasSprite)sprite, resource);
                    }
                }
                catch (Throwable throwable) {
                    if (resource != null) {
                        SpriteBufferedImageCache.INSTANCE.put((TextureAtlasSprite)sprite, resource);
                    }
                    throw throwable;
                }
            }
        });
        this.stellar_core$cachedTextures = new ReferenceOpenHashSet(this.stellar_core$cachedTextures);
        this.stellar_core$cachedLocations = new ObjectOpenHashSet(this.stellar_core$cachedLocations);
        if (!FMLClientHandler.instance().hasOptifine()) {
            return;
        }
        if (this.field_147636_j >= 4) {
            try {
                this.stellar_core$prevMipMapLevels = detectMaxMipmapLevelTask.get();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            this.field_147636_j = 3;
        }
    }

    @Inject(method={"loadTextureAtlas"}, at={@At(value="RETURN")})
    private void injectLoadTextureTail(IResourceManager resourceManager, CallbackInfo ci) {
        this.stellar_core$cachedTextures.clear();
        this.stellar_core$cachedLocations.clear();
        SpriteBufferedImageCache.INSTANCE.clear();
    }

    @Redirect(method={"generateMipmaps"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/IResourceManager;getResource(Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/client/resources/IResource;"))
    private IResource redirectGenerateMipmapsGetResource(IResourceManager instance, ResourceLocation resourceLocation, @Local(name={"texture"}) TextureAtlasSprite texture) throws IOException {
        IResource resource = SpriteBufferedImageCache.INSTANCE.getResourceAndRemove(texture);
        if (resource != null) {
            return resource;
        }
        return instance.func_110536_a(resourceLocation);
    }

    @Redirect(method={"loadTexture(Lnet/minecraft/client/renderer/texture/Stitcher;Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraftforge/fml/common/ProgressManager$ProgressBar;II)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/IResource;getMetadata(Ljava/lang/String;)Lnet/minecraft/client/resources/data/IMetadataSection;"), require=0, expect=0)
    private IMetadataSection redirectLoadTextureGetMetadata(IResource instance, String s) {
        if (instance != null) {
            return instance.func_110526_a(s);
        }
        return null;
    }

    @Redirect(method={"loadTexture(Lnet/minecraft/client/renderer/texture/Stitcher;Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraftforge/fml/common/ProgressManager$ProgressBar;II)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;loadSprite(Lnet/minecraft/client/renderer/texture/PngSizeInfo;Z)V"), require=0, expect=0)
    private void redirectLoadTextureLoadSprite(TextureAtlasSprite instance, PngSizeInfo sizeInfo, boolean animations) throws Exception {
        if (!this.stellar_core$cachedTextures.contains(instance)) {
            instance.func_188538_a(sizeInfo, animations);
        }
    }

    @Redirect(method={"loadTexture(Lnet/minecraft/client/renderer/texture/Stitcher;Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraftforge/fml/common/ProgressManager$ProgressBar;II)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/PngSizeInfo;makeFromResource(Lnet/minecraft/client/resources/IResource;)Lnet/minecraft/client/renderer/texture/PngSizeInfo;"), require=0, expect=0)
    private PngSizeInfo redirectLoadTextureMakeFromResource(IResource pngsizeinfo) throws Throwable {
        if (pngsizeinfo != null) {
            return PngSizeInfo.func_188532_a((IResource)pngsizeinfo);
        }
        return null;
    }

    @Redirect(method={"loadTexture(Lnet/minecraft/client/renderer/texture/Stitcher;Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraftforge/fml/common/ProgressManager$ProgressBar;II)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/IResourceManager;getResource(Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/client/resources/IResource;"), require=0, expect=0)
    private IResource redirectLoadTextureGetResource(IResourceManager instance, ResourceLocation resourceLocation) throws IOException {
        if (!this.stellar_core$cachedLocations.contains(resourceLocation)) {
            if (StellarCoreConfig.DEBUG.enableDebugLog) {
                StellarLog.LOG.info("[StellarCore-DEBUG] Loading uncached texture resource: {}", (Object)resourceLocation);
            }
            return instance.func_110536_a(resourceLocation);
        }
        return null;
    }

    @Unique
    private Future<Integer> stellar_core$initializeOptifineTask(IResourceManager resourceManager) {
        if (!FMLClientHandler.instance().hasOptifine() || this.field_147636_j < 4) {
            return null;
        }
        Method detectMaxMipmapLevel = ReflectionHelper.findMethod(TextureMap.class, (String)"detectMaxMipmapLevel", null, (Class[])new Class[]{Map.class, IResourceManager.class});
        return CompletableFuture.supplyAsync(() -> {
            try {
                return (int)((Integer)detectMaxMipmapLevel.invoke((Object)((TextureMap)this), this.field_110574_e, resourceManager));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Inject(method={"loadSprites"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureMap;initMissingImage()V")})
    private void injectLoadSpritesBeforeInitMissingImage(IResourceManager resourceManager, ITextureMapPopulator iconCreatorIn, CallbackInfo ci) {
        if (!FMLClientHandler.instance().hasOptifine()) {
            return;
        }
        if (this.stellar_core$prevMipMapLevels >= 4) {
            this.field_147636_j = this.stellar_core$prevMipMapLevels;
        }
    }

    @Redirect(method={"loadTextureAtlas"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/IResource;getMetadata(Ljava/lang/String;)Lnet/minecraft/client/resources/data/IMetadataSection;"), require=0, expect=0)
    private IMetadataSection redirectLoadTextureAtlasGetMetadata(IResource instance, String s) {
        if (instance != null) {
            return instance.func_110526_a(s);
        }
        return null;
    }

    @Redirect(method={"loadTextureAtlas"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;loadSprite(Lnet/minecraft/client/renderer/texture/PngSizeInfo;Z)V"), require=0, expect=0)
    private void redirectLoadTextureAtlasLoadSprite(TextureAtlasSprite instance, PngSizeInfo sizeInfo, boolean animations) throws Exception {
        if (!this.stellar_core$cachedTextures.contains(instance)) {
            instance.func_188538_a(sizeInfo, animations);
        }
    }

    @Redirect(method={"loadTextureAtlas"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/PngSizeInfo;makeFromResource(Lnet/minecraft/client/resources/IResource;)Lnet/minecraft/client/renderer/texture/PngSizeInfo;"), require=0, expect=0)
    private PngSizeInfo redirectLoadTextureAtlasMakeFromResource(IResource pngsizeinfo) throws Throwable {
        if (pngsizeinfo != null) {
            return PngSizeInfo.func_188532_a((IResource)pngsizeinfo);
        }
        return null;
    }

    @Redirect(method={"loadTextureAtlas"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/IResourceManager;getResource(Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/client/resources/IResource;"), require=0, expect=0)
    private IResource redirectLoadTextureAtlasGetResource(IResourceManager instance, ResourceLocation resourceLocation) throws IOException {
        if (!this.stellar_core$cachedLocations.contains(resourceLocation)) {
            if (StellarCoreConfig.DEBUG.enableDebugLog) {
                StellarLog.LOG.info("[StellarCore-DEBUG] Loading uncached texture resource: {}", (Object)resourceLocation);
            }
            return instance.func_110536_a(resourceLocation);
        }
        return null;
    }
}

