/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.minecraft.stitcher;

import github.kasuminova.stellarcore.client.texture.StitcherCache;
import github.kasuminova.stellarcore.common.util.StellarLog;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.texture.Stitcher;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Stitcher.class})
public abstract class MixinStitcher {
    @Final
    @Shadow
    private Set<Stitcher.Holder> field_94319_a;
    @Final
    @Shadow
    private List<Stitcher.Slot> field_94317_b;
    @Shadow
    private int field_94318_c;
    @Shadow
    private int field_94315_d;
    @Unique
    private long stellar_core$startTime;

    @Inject(method={"doStitch"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectDoStitch(CallbackInfo ci) {
        this.stellar_core$startTime = System.currentTimeMillis();
        StitcherCache cache = StitcherCache.getActiveCache();
        if (cache == null) {
            StellarLog.LOG.info("[StellarCore-MixinStitcher] Current TextureMap has no cache found, skipping...");
            return;
        }
        cache.parseTag((Stitcher)this, this.field_94319_a);
        StitcherCache.State cacheState = cache.getCacheState();
        if (cacheState == StitcherCache.State.AVAILABLE) {
            this.stellar_core$applyCache(cache);
            StellarLog.LOG.info("[StellarCore-MixinStitcher] Stitched {} texture sprites, cache state: {}, took {}ms.", (Object)this.field_94319_a.size(), (Object)cacheState, (Object)(System.currentTimeMillis() - this.stellar_core$startTime));
            ci.cancel();
        } else {
            cache.clear();
        }
    }

    @Inject(method={"doStitch"}, at={@At(value="RETURN")})
    private void injectDoStitchTail(CallbackInfo ci) {
        StitcherCache cache = StitcherCache.getActiveCache();
        if (cache == null) {
            return;
        }
        this.stellar_core$storeCache(cache);
        StellarLog.LOG.info("[StellarCore-MixinStitcher] Stitched {} texture sprites, cache state: {}, took {}ms.", (Object)this.field_94319_a.size(), (Object)StitcherCache.State.UNAVAILABLE, (Object)(System.currentTimeMillis() - this.stellar_core$startTime));
    }

    @Unique
    private void stellar_core$applyCache(StitcherCache cache) {
        this.field_94317_b.clear();
        this.field_94317_b.addAll(cache.getSlots());
        this.field_94318_c = cache.getWidth();
        this.field_94315_d = cache.getHeight();
        this.stellar_core$storeCache(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void stellar_core$storeCache(StitcherCache cache) {
        StitcherCache stitcherCache = cache;
        synchronized (stitcherCache) {
            if (cache.getCacheState() == StitcherCache.State.AVAILABLE) {
                cache.clear();
                StellarLog.LOG.info("[StellarCore-MixinStitcher] Stitching cache is already available, skipped storing...");
                return;
            }
            CompletableFuture.runAsync(() -> {
                StitcherCache stitcherCache = cache;
                synchronized (stitcherCache) {
                    long startTime = System.currentTimeMillis();
                    StellarLog.LOG.info("[StellarCore-MixinStitcher] Storing stitcher cache...");
                    cache.cache(this.field_94319_a, this.field_94317_b, this.field_94318_c, this.field_94315_d);
                    cache.writeToFile();
                    cache.clear();
                    StellarLog.LOG.info("[StellarCore-MixinStitcher] Stored stitcher cache, took {}ms.", (Object)(System.currentTimeMillis() - startTime));
                }
            });
        }
        StitcherCache.setActiveMap(null);
    }
}

