/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.minecraft.forge;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import github.kasuminova.stellarcore.common.util.StellarEnvironment;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ASMDataTable.class})
public abstract class MixinASMDataTable {
    @Shadow(remap=false)
    private Map<ModContainer, SetMultimap<String, ASMDataTable.ASMData>> containerAnnotationData;
    @Unique
    private final AtomicReference<Map<ModContainer, SetMultimap<String, ASMDataTable.ASMData>>> stellar_core$atomicRef = new AtomicReference<Object>(null);
    @Unique
    private final AtomicBoolean stellar_core$initializingData = new AtomicBoolean(false);

    @Shadow(remap=false)
    public abstract SetMultimap<String, ASMDataTable.ASMData> getAnnotationsFor(ModContainer var1);

    @Inject(method={"getAnnotationsFor"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void getAnnotationsFor(ModContainer container, CallbackInfoReturnable<SetMultimap<String, ASMDataTable.ASMData>> cir) {
        if (this.stellar_core$initializingData.get()) {
            return;
        }
        this.stellar_core$getAnnotationsForInternal(container, cir);
    }

    @Redirect(method={"getAnnotationsFor"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;collect(Ljava/util/stream/Collector;)Ljava/lang/Object;", remap=false), remap=false)
    private Object ensureInitialized(Stream<Pair<ModContainer, ImmutableSetMultimap<String, ASMDataTable.ASMData>>> instance, Collector<Pair<ModContainer, ImmutableSetMultimap<String, ASMDataTable.ASMData>>, ?, ImmutableMap<ModContainer, SetMultimap<String, ASMDataTable.ASMData>>> collector) {
        ImmutableMap<ModContainer, SetMultimap<String, ASMDataTable.ASMData>> result = instance.collect(collector);
        this.stellar_core$atomicRef.set((Map<ModContainer, SetMultimap<String, ASMDataTable.ASMData>>)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void stellar_core$getAnnotationsForInternal(ModContainer container, CallbackInfoReturnable<SetMultimap<String, ASMDataTable.ASMData>> cir) {
        if (this.containerAnnotationData != null) {
            cir.setReturnValue(this.containerAnnotationData.get(container));
            return;
        }
        Class<ASMDataTable> clazz = ASMDataTable.class;
        synchronized (ASMDataTable.class) {
            if (this.containerAnnotationData != null) {
                cir.setReturnValue(this.containerAnnotationData.get(container));
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (this.stellar_core$atomicRef.get() != null) {
                this.containerAnnotationData = this.stellar_core$atomicRef.get();
                cir.setReturnValue(this.containerAnnotationData.get(container));
            }
            this.stellar_core$initializeData(container);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            cir.setReturnValue(this.containerAnnotationData.get(container));
            return;
        }
    }

    @Unique
    private void stellar_core$initializeData(ModContainer container) {
        this.stellar_core$initializingData.set(true);
        ForkJoinPool pool = new ForkJoinPool(Math.max(2, StellarEnvironment.getConcurrency() / 2));
        ((ForkJoinTask)pool.submit(() -> this.getAnnotationsFor(container))).join();
        pool.shutdown();
        this.stellar_core$initializingData.set(false);
    }
}

