/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.minecraft.advancements;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.advancements.CriterionProgress;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={CriterionProgress.class})
public class MixinCriterionProgress {
    @Unique
    private static final ThreadLocal<SimpleDateFormat> DATE_TIME_FORMATTER = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z"));

    @Redirect(method={"serialize"}, at=@At(value="INVOKE", target="Ljava/text/SimpleDateFormat;format(Ljava/util/Date;)Ljava/lang/String;", remap=false), remap=true)
    private String redirectSerializeFormat(SimpleDateFormat instance, Date date) {
        return DATE_TIME_FORMATTER.get().format(date);
    }

    @Redirect(method={"fromDateTime"}, at=@At(value="INVOKE", target="Ljava/text/SimpleDateFormat;parse(Ljava/lang/String;)Ljava/util/Date;", remap=false), remap=true)
    private static Date redirectFromDateTimeParse(SimpleDateFormat instance, String s) throws ParseException {
        return DATE_TIME_FORMATTER.get().parse(s);
    }
}

