/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.mets;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import javax.annotation.Nonnull;
import net.lrsoft.mets.item.battery.ThoriumBattery;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ThoriumBattery.class})
public abstract class MixinThoriumBattery
extends Item {
    @Shadow(remap=false)
    public abstract double getMaxCharge(ItemStack var1);

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        if (!StellarCoreConfig.FEATURES.ic2.electricItemNonDurability) {
            return super.showDurabilityBar(stack);
        }
        return true;
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        if (!StellarCoreConfig.FEATURES.ic2.electricItemNonDurability) {
            return super.getDurabilityForDisplay(stack);
        }
        NBTTagCompound tNBT = stack.func_77978_p();
        double charge = tNBT == null ? 0.0 : tNBT.func_74769_h("charge");
        double maxCharge = this.getMaxCharge(stack);
        if (maxCharge > 0.0) {
            return 1.0 - charge / maxCharge;
        }
        return super.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        if (!StellarCoreConfig.FEATURES.ic2.electricItemNonDurability) {
            return super.getRGBDurabilityForDisplay(stack);
        }
        return 8900346;
    }
}

