/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.mets;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import ic2.api.item.IElectricItem;
import ic2.core.util.Util;
import net.lrsoft.mets.util.ItemStackUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStackUtils.class})
public class MixinItemStackUtils {
    @Inject(method={"getCurrentTex"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void injectGetCurrentTex(ItemStack stack, int texLevel, CallbackInfoReturnable<Integer> cir) {
        Item item;
        if (!StellarCoreConfig.FEATURES.ic2.electricItemNonDurability || !((item = stack.func_77973_b()) instanceof IElectricItem)) {
            return;
        }
        IElectricItem eItem = (IElectricItem)item;
        NBTTagCompound tNBT = stack.func_77978_p();
        double charge = tNBT == null ? 0.0 : tNBT.func_74769_h("charge");
        double maxCharge = eItem.getMaxCharge(stack);
        int level = maxCharge > 0.0 ? (int)Math.round(Util.limit((double)(charge / maxCharge * (double)texLevel), (double)0.0, (double)texLevel)) : 0;
        cir.setReturnValue((Object)level);
    }
}

