/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.ic2;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import ic2.core.item.armor.ItemArmorElectric;
import ic2.core.item.armor.ItemArmorIC2;
import ic2.core.ref.ItemName;
import javax.annotation.Nonnull;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ItemArmorElectric.class})
public abstract class MixinItemArmorElectric
extends ItemArmorIC2 {
    @Shadow(remap=false)
    public abstract double getMaxCharge(ItemStack var1);

    public MixinItemArmorElectric(ItemName name, String armorName, EntityEquipmentSlot armorType) {
        super(name, ItemArmor.ArmorMaterial.DIAMOND, armorName, armorType, null);
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        if (!StellarCoreConfig.FEATURES.ic2.electricItemNonDurability) {
            return super.showDurabilityBar(stack);
        }
        return true;
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        if (!StellarCoreConfig.FEATURES.ic2.electricItemNonDurability) {
            return super.getDurabilityForDisplay(stack);
        }
        NBTTagCompound tNBT = stack.func_77978_p();
        double charge = tNBT == null ? 0.0 : tNBT.func_74769_h("charge");
        double maxCharge = this.getMaxCharge(stack);
        if (maxCharge > 0.0) {
            return 1.0 - charge / maxCharge;
        }
        return super.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        if (!StellarCoreConfig.FEATURES.ic2.electricItemNonDurability) {
            return super.getRGBDurabilityForDisplay(stack);
        }
        return 8900346;
    }
}

