/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.fluxnetworks;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.StellarEnvironment;
import github.kasuminova.stellarcore.mixin.util.IStellarFluxNetwork;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sonar.fluxnetworks.common.CommonProxy;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;

@Mixin(value={CommonProxy.class}, remap=false)
public class MixinCommonProxy {
    @Inject(method={"onServerTick"}, at={@At(value="HEAD")})
    private void injectOnServerTick(TickEvent.ServerTickEvent event, CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.fluxNetworks.parallelNetworkCalculation || !StellarEnvironment.shouldParallel()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            Collection networks = FluxNetworkCache.instance.getAllNetworks();
            ObjectArrayList runnableList = new ObjectArrayList(networks.size() + 1);
            networks.stream().filter(IStellarFluxNetwork.class::isInstance).map(IStellarFluxNetwork.class::cast).map(IStellarFluxNetwork::getCycleStartRunnable).forEach(((List)runnableList)::add);
            runnableList.parallelStream().forEach(Runnable::run);
        }
    }
}

