/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.ebwizardry;

import electroblob.wizardry.data.DispenserCastingData;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.mod.Mods;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DispenserCastingData.class}, remap=false)
public abstract class MixinDispenserCastingData {
    @Inject(method={"onWorldTickEvent"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectOnWorldTickEvent(TickEvent.WorldTickEvent event, CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.ebWizardry.dispenserCastingData) {
            return;
        }
        if (!Mods.TICK_CENTRAL.loaded()) {
            ci.cancel();
            return;
        }
        if (event.phase == TickEvent.Phase.START || event.world.field_147482_g.size() <= 5000) {
            return;
        }
        ci.cancel();
        try {
            MixinDispenserCastingData.stellar_core$executeParallel(event.world.field_147482_g);
        }
        catch (NullPointerException | ConcurrentModificationException e) {
            MixinDispenserCastingData.stellar_core$executeParallel(new ArrayList<TileEntity>(event.world.field_147482_g));
        }
    }

    @Unique
    private static void stellar_core$executeParallel(List<TileEntity> tileEntityList) {
        tileEntityList.parallelStream().filter(TileEntityDispenser.class::isInstance).map(TileEntityDispenser.class::cast).map(DispenserCastingData::get).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedList::new)).forEach(DispenserCastingData::update);
    }
}

