/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.customstartinggear;

import com.brandon3055.csg.DataManager;
import com.brandon3055.csg.LogHelper;
import com.brandon3055.csg.lib.PlayerSlot;
import com.brandon3055.csg.lib.StackReference;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.UTF8FileReader;
import github.kasuminova.stellarcore.common.util.UTF8FileWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DataManager.class})
public class MixinDataManager {
    @Shadow(remap=false)
    public static Map<PlayerSlot, StackReference> spawnInventory;
    @Shadow(remap=false)
    public static Map<String, Map<PlayerSlot, StackReference>> kits;
    @Shadow(remap=false)
    private static File configFile;

    @Inject(method={"saveConfig"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void saveConfig(CallbackInfo ci) throws IOException {
        if (!StellarCoreConfig.BUG_FIXES.customStartingGear.dataManager) {
            return;
        }
        ci.cancel();
        if (spawnInventory == null) {
            LogHelper.error((Object)"Could not save config because inventory array was null!");
            return;
        }
        JsonObject obj = new JsonObject();
        JsonObject inv = new JsonObject();
        spawnInventory.forEach((playerSlot, stackReference) -> inv.addProperty(playerSlot.toString(), stackReference.toString()));
        obj.add("inventory", (JsonElement)inv);
        if (!kits.isEmpty()) {
            JsonObject kitsObj = new JsonObject();
            kits.forEach((name, kit) -> {
                JsonObject kitObj = new JsonObject();
                kit.forEach((playerSlot, stackReference) -> kitObj.addProperty(playerSlot.toString(), stackReference.toString()));
                kitsObj.add(name, (JsonElement)kitObj);
            });
            obj.add("kits", (JsonElement)kitsObj);
        }
        JsonWriter writer = new JsonWriter((Writer)new UTF8FileWriter(configFile));
        writer.setIndent("  ");
        Streams.write((JsonElement)obj, (JsonWriter)writer);
        writer.flush();
        IOUtils.closeQuietly((Closeable)writer);
    }

    @Inject(method={"loadConfig"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void loadConfig(CallbackInfo ci) throws IOException {
        if (!StellarCoreConfig.BUG_FIXES.customStartingGear.dataManager) {
            return;
        }
        ci.cancel();
        if (!configFile.exists()) {
            spawnInventory = null;
            LogHelper.warn((Object)"Custom Spawn Inventory has not been configured yet! Canceling config load!");
            return;
        }
        JsonParser parser = new JsonParser();
        UTF8FileReader reader = new UTF8FileReader(configFile);
        JsonElement element = parser.parse((Reader)reader);
        IOUtils.closeQuietly((Reader)reader);
        if (!element.isJsonObject()) {
            LogHelper.warn((Object)"Detected invalid config json! Canceling config load!");
            return;
        }
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("inventory") && obj.get("inventory").isJsonObject()) {
            LogHelper.info((Object)"Reading starting inventory config");
            spawnInventory = new HashMap<PlayerSlot, StackReference>();
            JsonObject inv = obj.get("inventory").getAsJsonObject();
            inv.entrySet().forEach(entry -> {
                PlayerSlot slot = PlayerSlot.fromString((String)((String)entry.getKey()));
                StackReference stack = StackReference.fromString((String)((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString());
                spawnInventory.put(slot, stack);
            });
            LogHelper.info((Object)("Loaded " + spawnInventory.size() + " starting items."));
        }
        if (obj.has("kits") && obj.get("kits").isJsonObject()) {
            LogHelper.info((Object)"Reading kits from config");
            JsonObject kits = obj.get("kits").getAsJsonObject();
            kits.entrySet().forEach(entry -> {
                String name = (String)entry.getKey();
                JsonObject items = ((JsonElement)entry.getValue()).getAsJsonObject();
                Map kitMap = DataManager.kits.computeIfAbsent(name, s -> new HashMap());
                items.entrySet().forEach(kitEntry -> {
                    PlayerSlot slot = PlayerSlot.fromString((String)((String)kitEntry.getKey()));
                    StackReference stack = StackReference.fromString((String)((JsonElement)kitEntry.getValue()).getAsJsonPrimitive().getAsString());
                    kitMap.put(slot, stack);
                });
                LogHelper.info((Object)("Loaded " + kitMap.size() + " items for kit " + name));
            });
        }
    }
}

