/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.ctm;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.StellarEnvironment;
import github.kasuminova.stellarcore.shaded.org.jctools.maps.NonBlockingHashMap;
import github.kasuminova.stellarcore.shaded.org.jctools.queues.atomic.MpscLinkedAtomicQueue;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.chisel.ctm.CTM;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.client.model.parsing.ModelLoaderCTM;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.util.ResourceUtil;
import team.chisel.ctm.client.util.TextureMetadataHandler;

@Mixin(value={TextureMetadataHandler.class}, remap=false)
public abstract class MixinTextureMetadataHandler {
    @Final
    @Shadow
    private static Class<?> vanillaModelWrapperClass;
    @Final
    @Shadow
    private static Field modelWrapperModel;
    @Final
    @Shadow
    private static Class<?> multipartModelClass;
    @Final
    @Shadow
    private static Field multipartPartModels;
    @Unique
    private final Map<ResourceLocation, Boolean> stellar_core$wrappedModelsConcurrent = new NonBlockingHashMap<ResourceLocation, Boolean>();

    @Nonnull
    @Shadow
    protected abstract IBakedModel wrap(IModel var1, IBakedModel var2) throws IOException;

    @Inject(method={"onModelBake"}, at={@At(value="HEAD")}, cancellable=true)
    public void onModelBake(ModelBakeEvent event, CallbackInfo ci) {
        Tuple tuple;
        if (!StellarCoreConfig.PERFORMANCE.ctm.textureMetadataHandler || !StellarEnvironment.shouldParallel()) {
            return;
        }
        ci.cancel();
        Map stateModels = (Map)ReflectionHelper.getPrivateValue(ModelLoader.class, (Object)event.getModelLoader(), (String[])new String[]{"stateModels"});
        IRegistry registry = event.getModelRegistry();
        MpscLinkedAtomicQueue wrappedConcurrent = new MpscLinkedAtomicQueue();
        registry.func_148742_b().parallelStream().forEach(mrl -> {
            IModel rootModel = (IModel)stateModels.get(mrl);
            if (rootModel == null || rootModel instanceof IModelCTM || ModelLoaderCTM.parsedLocations.contains(mrl)) {
                return;
            }
            ArrayDeque<Object> dependencies = new ArrayDeque<Object>();
            ObjectOpenHashSet seenModels = new ObjectOpenHashSet();
            dependencies.push(mrl);
            seenModels.add(mrl);
            boolean shouldWrap = this.stellar_core$wrappedModelsConcurrent.getOrDefault(mrl, Boolean.FALSE);
            while (!shouldWrap && !dependencies.isEmpty()) {
                IModel model;
                ResourceLocation dep = (ResourceLocation)dependencies.pop();
                try {
                    model = dep == mrl ? rootModel : ModelLoaderRegistry.getModel((ResourceLocation)dep);
                }
                catch (Exception e) {
                    continue;
                }
                Object textures = new ObjectOpenHashSet(model.getTextures());
                if (vanillaModelWrapperClass.isAssignableFrom(model.getClass())) {
                    ModelBlock parent;
                    try {
                        parent = ((ModelBlock)MixinTextureMetadataHandler.modelWrapperModel.get((Object)model)).field_178315_d;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    while (parent != null) {
                        textures.addAll(parent.field_178318_c.values().stream().filter(s -> !s.startsWith("#")).map(ResourceLocation::new).collect(Collectors.toSet()));
                        parent = parent.field_178315_d;
                    }
                }
                ObjectOpenHashSet newDependencies = new ObjectOpenHashSet(model.getDependencies());
                if (multipartModelClass.isAssignableFrom(model.getClass())) {
                    Map partModels;
                    try {
                        partModels = (Map)multipartPartModels.get(model);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    textures = partModels.values().stream().map(IModel::getTextures).flatMap(Collection::stream).collect(Collectors.toSet());
                    newDependencies.addAll(partModels.values().stream().flatMap(m -> m.getDependencies().stream()).collect(Collectors.toList()));
                }
                for (ResourceLocation tex : textures) {
                    IMetadataSectionCTM meta = null;
                    try {
                        meta = ResourceUtil.getMetadata((ResourceLocation)ResourceUtil.spriteToAbsolute((ResourceLocation)tex));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (meta == null) continue;
                    shouldWrap = true;
                    break;
                }
                for (ResourceLocation newDependency : newDependencies) {
                    if (!seenModels.add(newDependency)) continue;
                    dependencies.push(newDependency);
                }
            }
            this.stellar_core$wrappedModelsConcurrent.put((ResourceLocation)mrl, shouldWrap ? Boolean.TRUE : Boolean.FALSE);
            if (shouldWrap) {
                try {
                    IBakedModel wrapped = this.wrap(rootModel, (IBakedModel)registry.func_82594_a(mrl));
                    wrappedConcurrent.offer(new Tuple(mrl, (Object)wrapped));
                    dependencies.clear();
                }
                catch (IOException e) {
                    CTM.logger.error("Could not wrap model " + mrl + ". Aborting...", (Throwable)e);
                }
            }
        });
        while ((tuple = (Tuple)wrappedConcurrent.poll()) != null) {
            registry.func_82595_a((Object)((ModelResourceLocation)tuple.func_76341_a()), (Object)((IBakedModel)tuple.func_76340_b()));
        }
        this.stellar_core$wrappedModelsConcurrent.clear();
    }
}

