/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.botania;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.BlockPos2ValueMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.common.block.tile.TilePylon;

@Mixin(value={TilePylon.class})
public class MixinTilePylon {
    @Unique
    private final Map<BlockPos, IBlockState> stellar_core$stateCache = BlockPos2ValueMap.create();

    @Inject(method={"update"}, at={@At(value="HEAD"), @At(value="RETURN")})
    private void injectUpdateStartAndEnd(CallbackInfo ci) {
        this.stellar_core$stateCache.clear();
    }

    @Redirect(method={"update", "getBlockForMeta", "portalOff"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"))
    private IBlockState redirectGetBlockState(World instance, BlockPos pos) {
        if (!StellarCoreConfig.PERFORMANCE.botania.pylonImprovements) {
            return instance.func_180495_p(pos);
        }
        return this.stellar_core$stateCache.computeIfAbsent(pos, arg_0 -> ((World)instance).func_180495_p(arg_0));
    }
}

