/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.botania;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import net.minecraft.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.common.entity.EntitySpark;

@Mixin(value={EntitySpark.class})
public abstract class MixinEntitySpark {
    @Unique
    private boolean stellarcore$receiveLeastOne = false;
    @Unique
    private int stellarcore$failureCounter = 1;

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="Lvazkii/botania/common/entity/EntitySpark;getUpgrade()Lvazkii/botania/api/mana/spark/SparkUpgradeType;", remap=false)}, cancellable=true)
    private void injectOnUpdatePre(CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.botania.sparkImprovements) {
            return;
        }
        if (((Entity)this).field_70170_p.func_82737_E() % (long)this.stellarcore$failureCounter != 0L) {
            ci.cancel();
        }
    }

    @Redirect(method={"onUpdate"}, at=@At(value="INVOKE", target="Lvazkii/botania/api/mana/spark/ISparkAttachable;recieveMana(I)V", remap=false))
    private void redirectReceiveMana(ISparkAttachable attachable, int mana) {
        attachable.recieveMana(mana);
        if (!StellarCoreConfig.PERFORMANCE.botania.sparkImprovements) {
            return;
        }
        if (mana != 0) {
            this.stellarcore$receiveLeastOne = true;
        }
    }

    @Inject(method={"onUpdate"}, at={@At(value="TAIL")})
    private void injectOnUpdateTail(CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.botania.sparkImprovements) {
            return;
        }
        if (this.stellarcore$receiveLeastOne) {
            if (this.stellarcore$failureCounter > 1) {
                --this.stellarcore$failureCounter;
            }
        } else if (this.stellarcore$failureCounter < StellarCoreConfig.PERFORMANCE.botania.sparkMaxWorkDelay) {
            this.stellarcore$failureCounter = Math.min(this.stellarcore$failureCounter + 2, StellarCoreConfig.PERFORMANCE.botania.sparkMaxWorkDelay);
        }
    }
}

