/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.bloodmagic;

import WayofTime.bloodmagic.altar.BloodAltar;
import WayofTime.bloodmagic.tile.TileAltar;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={BloodAltar.class})
public class MixinBloodAltar {
    @Shadow(remap=false)
    private TileAltar tileAltar;

    private static void sendUpdatePacketToNearPlayers(TileAltar altar, World world, BlockPos blockPos) {
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            return;
        }
        server.func_152344_a(() -> {
            if (altar.func_145837_r()) {
                return;
            }
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                double distance;
                if (player.field_70170_p != world || !((distance = player.func_180425_c().func_185332_f(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p())) <= 16.0)) continue;
                player.field_71135_a.func_147359_a((Packet)altar.func_189518_D_());
            }
        });
    }

    @Redirect(method={"startCycle"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;notifyBlockUpdate(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;I)V", remap=true), remap=false)
    public void onStartCycleNotifyUpdate(World world, BlockPos blockPos, IBlockState pos, IBlockState oldState, int newState) {
        if (!StellarCoreConfig.PERFORMANCE.bloodMagic.bloodAltar) {
            world.func_184138_a(blockPos, pos, oldState, newState);
            return;
        }
        MixinBloodAltar.sendUpdatePacketToNearPlayers(this.tileAltar, world, blockPos);
    }

    @Redirect(method={"update"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;notifyBlockUpdate(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;I)V", remap=true), remap=false)
    public void onUpdateNotifyUpdate(World world, BlockPos blockPos, IBlockState pos, IBlockState oldState, int newState) {
        if (!StellarCoreConfig.PERFORMANCE.bloodMagic.bloodAltar) {
            world.func_184138_a(blockPos, pos, oldState, newState);
            return;
        }
        MixinBloodAltar.sendUpdatePacketToNearPlayers(this.tileAltar, world, blockPos);
    }

    @Redirect(method={"updateAltar"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;notifyBlockUpdate(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;I)V", remap=true), remap=false)
    public void onUpdateAltarCycleNotifyUpdate(World world, BlockPos blockPos, IBlockState pos, IBlockState oldState, int newState) {
        if (!StellarCoreConfig.PERFORMANCE.bloodMagic.bloodAltar) {
            world.func_184138_a(blockPos, pos, oldState, newState);
            return;
        }
        MixinBloodAltar.sendUpdatePacketToNearPlayers(this.tileAltar, world, blockPos);
    }
}

