/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.util;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.util.ReportedException;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class LargeNBTUtils {
    public static NBTTagCompound readCompressed(InputStream is) throws IOException {
        NBTTagCompound nbttagcompound;
        try (DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(is)));){
            nbttagcompound = LargeNBTUtils.readInfinityDepth(datainputstream, NBTSizeTracker.field_152451_a);
        }
        return nbttagcompound;
    }

    public static NBTTagCompound readInfinityDepth(DataInput input, NBTSizeTracker accounter) throws IOException {
        NBTBase nbtbase = LargeNBTUtils.read(input, Integer.MIN_VALUE, accounter);
        if (nbtbase instanceof NBTTagCompound) {
            return (NBTTagCompound)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    private static NBTBase read(DataInput input, int depth, NBTSizeTracker accounter) throws IOException {
        byte b0 = input.readByte();
        accounter.func_152450_a(8L);
        if (b0 == 0) {
            return new NBTTagEnd();
        }
        NBTSizeTracker.readUTF((NBTSizeTracker)accounter, (String)input.readUTF());
        accounter.func_152450_a(32L);
        NBTBase nbtbase = LargeNBTUtils.invokeCreate(b0);
        try {
            LargeNBTUtils.invokeRead(nbtbase, input, depth, accounter);
            return nbtbase;
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)ioexception, (String)"Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("NBT Tag");
            crashreportcategory.func_71507_a("Tag type", (Object)b0);
            throw new ReportedException(crashreport);
        }
    }

    private static NBTBase invokeCreate(byte id) {
        try {
            return (NBTBase)ReflectionHelper.findMethod(NBTBase.class, (String)"create", (String)"func_150284_a", (Class[])new Class[]{Byte.TYPE}).invoke(null, id);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static void invokeRead(NBTBase instance, DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        try {
            ReflectionHelper.findMethod(NBTBase.class, (String)"read", (String)"func_152446_a", (Class[])new Class[]{DataInput.class, Integer.TYPE, NBTSizeTracker.class}).invoke((Object)instance, input, depth, sizeTracker);
        }
        catch (Throwable ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new RuntimeException(ex);
        }
    }
}

