/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.util;

import com.google.common.collect.Iterators;
import github.kasuminova.stellarcore.common.mod.Mods;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;

public class BlockPosSet
implements Set<BlockPos> {
    protected final LongSet internal = new LongOpenHashSet();

    @Nonnull
    public static Set<BlockPos> create() {
        if (Mods.CUBIC_CHUNKS.loaded()) {
            return new ObjectOpenHashSet();
        }
        return new BlockPosSet();
    }

    @Override
    public int size() {
        return this.internal.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internal.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof BlockPos) {
            return this.internal.contains(((BlockPos)o).func_177986_g());
        }
        return false;
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        return Iterators.transform((Iterator)this.internal.iterator(), BlockPos::func_177969_a);
    }

    @Nonnull
    public BlockPos[] toArray() {
        BlockPos[] arr = new BlockPos[this.internal.size()];
        LongIterator it = this.internal.iterator();
        int i = 0;
        while (it.hasNext()) {
            arr[i] = BlockPos.func_177969_a((long)it.nextLong());
            ++i;
        }
        return arr;
    }

    @Override
    @Nonnull
    public <T> T[] toArray(T[] a) {
        if (a.length < this.internal.size()) {
            return this.toArray();
        }
        LongIterator it = this.internal.iterator();
        int i = 0;
        while (it.hasNext()) {
            a[i] = BlockPos.func_177969_a((long)it.nextLong());
            ++i;
        }
        return a;
    }

    @Override
    public boolean add(BlockPos pos) {
        return this.internal.add(pos.func_177986_g());
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof BlockPos) {
            return this.internal.remove(((BlockPos)o).func_177986_g());
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends BlockPos> c) {
        for (BlockPos blockPos : c) {
            this.add(blockPos);
        }
        return !c.isEmpty();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<BlockPos> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified = this.remove(o);
        }
        return modified;
    }

    @Override
    public void clear() {
        this.internal.clear();
    }
}

