/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.pool;

import github.kasuminova.stellarcore.common.util.StellarLog;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;

public class NBTTagPrimitivePool {
    private static final NBTTagByte[] TAG_BYTES = new NBTTagByte[256];
    private static final NBTTagShort[] TAG_SHORTS = new NBTTagShort[65536];
    private static final NBTTagInt[] TAG_INTS = new NBTTagInt[65536];
    private static final NBTTagLong[] TAG_LONGS = new NBTTagLong[65536];
    private static final NBTTagFloat[] TAG_FLOATS = new NBTTagFloat[65536];
    private static final NBTTagDouble[] TAG_DOUBLES = new NBTTagDouble[65536];
    private static final float EPSILON = 1.0E-7f;
    public static final int BYTE_OFFSET = 128;
    public static final int SHORT_OFFSET = 32768;
    public static final int MINIMUM = Short.MIN_VALUE;
    public static final int MAXIMUM = Short.MAX_VALUE;

    public static NBTTagByte getTagByte(NBTTagByte tag) {
        return TAG_BYTES[tag.func_150290_f() + 128];
    }

    public static NBTTagByte getTagByte(byte b) {
        return TAG_BYTES[b + 128];
    }

    public static NBTTagShort getTagShort(NBTTagShort tag) {
        return TAG_SHORTS[tag.func_150289_e() + 32768];
    }

    public static NBTTagShort getTagShort(short s) {
        return TAG_SHORTS[s + 32768];
    }

    public static NBTTagInt getTagInt(NBTTagInt tag) {
        int value = tag.func_150287_d();
        return value < Short.MIN_VALUE || value > Short.MAX_VALUE ? tag : TAG_INTS[value + 32768];
    }

    public static NBTTagInt getTagInt(int i) {
        return i < Short.MIN_VALUE || i > Short.MAX_VALUE ? new NBTTagInt(i) : TAG_INTS[i + 32768];
    }

    public static NBTTagLong getTagLong(NBTTagLong tag) {
        long value = tag.func_150291_c();
        return value < -32768L || value > 32767L ? tag : TAG_LONGS[(int)(value + 32768L)];
    }

    public static NBTTagLong getTagLong(long l) {
        return l < -32768L || l > 32767L ? new NBTTagLong(l) : TAG_LONGS[(int)(l + 32768L)];
    }

    public static NBTTagFloat getTagFloat(NBTTagFloat tag) {
        float value = tag.func_150288_h();
        return NBTTagPrimitivePool.isFloatInteger(value) ? (value < -32768.0f || value > 32767.0f ? tag : TAG_FLOATS[(int)value + 32768]) : tag;
    }

    public static NBTTagFloat getTagFloat(float f) {
        return NBTTagPrimitivePool.isFloatInteger(f) ? (f < -32768.0f || f > 32767.0f ? new NBTTagFloat(f) : TAG_FLOATS[(int)f + 32768]) : new NBTTagFloat(f);
    }

    public static NBTTagDouble getTagDouble(NBTTagDouble tag) {
        double value = tag.func_150286_g();
        return NBTTagPrimitivePool.isDoubleInteger(value) ? (value < -32768.0 || value > 32767.0 ? tag : TAG_DOUBLES[(int)value + 32768]) : tag;
    }

    public static NBTTagDouble getTagDouble(double d) {
        return NBTTagPrimitivePool.isDoubleInteger(d) ? (d < -32768.0 || d > 32767.0 ? new NBTTagDouble(d) : TAG_DOUBLES[(int)d + 32768]) : new NBTTagDouble(d);
    }

    public static boolean isFloatInteger(float value) {
        return Math.abs(value - (float)Math.round(value)) < 1.0E-7f;
    }

    public static boolean isDoubleInteger(double value) {
        return Math.abs(value - (double)Math.round(value)) < (double)1.0E-7f;
    }

    static {
        long start = System.currentTimeMillis();
        Arrays.setAll(TAG_BYTES, i -> new NBTTagByte((byte)(i - 128)));
        Arrays.setAll(TAG_SHORTS, i -> new NBTTagShort((short)(i - 32768)));
        Arrays.setAll(TAG_INTS, i -> new NBTTagInt(i - 32768));
        Arrays.setAll(TAG_LONGS, i -> new NBTTagLong((long)(i - 32768)));
        Arrays.setAll(TAG_FLOATS, i -> new NBTTagFloat((float)(i - 32768)));
        Arrays.setAll(TAG_DOUBLES, i -> new NBTTagDouble((double)(i - 32768)));
        StellarLog.LOG.info("[StellarCore-NBTTagPrimitivePool] PrimitiveType NBTTagPrimitivePool initialized, took {}ms.", (Object)(System.currentTimeMillis() - start));
    }
}

