/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.pool;

import github.kasuminova.stellarcore.common.pool.CanonicalizeTask;
import github.kasuminova.stellarcore.common.pool.CanonicalizeWorker;
import github.kasuminova.stellarcore.common.pool.DeferredCanonicalizable;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class AsyncCanonicalizePoolBase<T> {
    protected final CanonicalizeWorker<T> worker = new CanonicalizeWorker(this.getName());

    public AsyncCanonicalizePoolBase() {
        this.worker.start();
    }

    public void canonicalizeAsync(T target, Consumer<T> callback) {
        this.worker.offer(new CanonicalizeTask<Object>(() -> this.canonicalize(target), callback));
    }

    public void canonicalizeDeferred(DeferredCanonicalizable<T> target) {
        this.worker.defer(target);
    }

    public abstract T canonicalize(@Nullable T var1);

    public CanonicalizeWorker<T> getWorker() {
        return this.worker;
    }

    public abstract long getProcessedCount();

    public abstract int getUniqueCount();

    public abstract void clear();

    protected abstract String getName();
}

