/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.config.element;

import github.kasuminova.stellarcore.common.config.element.Category;
import github.kasuminova.stellarcore.common.config.element.ConfigElement;
import github.kasuminova.stellarcore.common.config.element.ElementBoolean;
import github.kasuminova.stellarcore.common.config.element.ElementDouble;
import github.kasuminova.stellarcore.common.config.element.ElementInteger;
import github.kasuminova.stellarcore.common.config.element.ElementTypeAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConfigElements {
    private static final Map<Class<?>, ElementTypeAdapter> TYPE_ADAPTERS = new HashMap();

    public static ConfigElement getConfigElement(Object object, Field field) {
        if (object == null && !Modifier.isStatic(field.getModifiers())) {
            return null;
        }
        ElementTypeAdapter adapter = TYPE_ADAPTERS.get(field.getType());
        if (adapter != null) {
            if (Modifier.isFinal(field.getModifiers())) {
                return null;
            }
            if (Modifier.isStatic(field.getModifiers())) {
                return adapter.get(null, field);
            }
            return adapter.get(object, field);
        }
        if (object != null) {
            Class<?> objectClass = object.getClass();
            if (objectClass.getSuperclass() == Object.class) {
                return new Category(object, field, ConfigElements.getConfigElements(object, objectClass.getFields()));
            }
        } else if (Modifier.isStatic(field.getModifiers())) {
            return new Category(null, field, ConfigElements.getConfigElements(null, field.getType().getFields()));
        }
        return null;
    }

    public static List<ConfigElement> getConfigElements(Class<?> classObject) {
        return ConfigElements.getConfigElements(null, classObject.getFields());
    }

    public static List<ConfigElement> getConfigElements(Object object, Field[] fields) {
        return Arrays.stream(fields).map(field -> ConfigElements.getConfigElement(object, field)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void registerTypeAdapter(Class<?> type, ElementTypeAdapter adapter) {
        TYPE_ADAPTERS.put(type, adapter);
    }

    static {
        ConfigElements.registerTypeAdapter(Boolean.TYPE, ElementBoolean::new);
        ConfigElements.registerTypeAdapter(Boolean.class, ElementBoolean::new);
        ConfigElements.registerTypeAdapter(Integer.TYPE, ElementInteger::new);
        ConfigElements.registerTypeAdapter(Integer.class, ElementInteger::new);
        ConfigElements.registerTypeAdapter(Double.TYPE, ElementDouble::new);
        ConfigElements.registerTypeAdapter(Double.class, ElementDouble::new);
    }
}

