/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.client.texture;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.LargeNBTUtils;
import github.kasuminova.stellarcore.common.util.StellarLog;
import github.kasuminova.stellarcore.mixin.minecraft.stitcher.AccessorStitcher;
import github.kasuminova.stellarcore.mixin.util.AccessorStitcherHolder;
import github.kasuminova.stellarcore.mixin.util.AccessorStitcherSlot;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class StitcherCache {
    private static final String CACHE_FILE_NAME = "config" + File.separator + "stellarcore_stitcher_cache_{}.dat";
    private static final Map<TextureMap, StitcherCache> CREATED_STITCHER_CACHE = new Reference2ObjectOpenHashMap();
    private static TextureMap activeMapToStitch = null;
    private final String name;
    private final File cacheFile;
    private final Map<String, Stitcher.Holder> holders = new Object2ObjectOpenHashMap();
    private final List<Stitcher.Slot> slots = new ObjectArrayList();
    private final TextureMap cacheFor;
    private Future<Void> readTask;
    private NBTTagCompound readTag = null;
    private int width = 0;
    private int height = 0;
    private State cacheState = State.UNKNOWN;

    private StitcherCache(String name, TextureMap cacheFor) {
        this.name = name;
        this.cacheFile = new File(CACHE_FILE_NAME.replace("{}", name));
        this.cacheFor = cacheFor;
        this.readTask = CompletableFuture.runAsync(this::readFromFile);
        StellarLog.LOG.info("[StellarCore-StitcherCache] Created stitcher cache for `{}`.", (Object)cacheFor.getBasePath());
        StellarLog.LOG.info("[StellarCore-StitcherCache] Stitcher file cache `{}` reader task started.", (Object)cacheFor.getBasePath());
    }

    public static StitcherCache create(String name, TextureMap cacheFor) {
        StitcherCache cache = CREATED_STITCHER_CACHE.get(cacheFor);
        if (cache != null) {
            cache.checkReadTaskState();
            cache.readTask = CompletableFuture.runAsync(cache::readFromFile);
            StellarLog.LOG.info("[StellarCore-StitcherCache] Stitcher file cache `{}` reader task restarted.", (Object)cacheFor.getBasePath());
            return cache;
        }
        cache = new StitcherCache(name, cacheFor);
        CREATED_STITCHER_CACHE.put(cacheFor, cache);
        return cache;
    }

    public static StitcherCache getActiveCache() {
        if (activeMapToStitch == null) {
            return null;
        }
        return CREATED_STITCHER_CACHE.get(activeMapToStitch);
    }

    public static void setActiveMap(TextureMap activeMap) {
        activeMapToStitch = activeMap;
    }

    public void writeToFile() {
        try {
            if (this.cacheFile.exists() && !this.cacheFile.delete()) {
                throw new IOException("Cannot delete file " + this.cacheFile.getAbsolutePath());
            }
            if (!this.cacheFile.createNewFile()) {
                throw new IOException("Cannot create file " + this.cacheFile.getAbsolutePath());
            }
            FileOutputStream fos = new FileOutputStream(this.cacheFile);
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.toNBT(), (OutputStream)fos);
            fos.close();
            StellarLog.LOG.info("[StellarCore-StitcherCache] Successfully write stitcher cache file to `{}`.", (Object)this.cacheFile.getAbsolutePath());
        }
        catch (Throwable e) {
            StellarLog.LOG.error("[StellarCore-StitcherCache] Failed to write stitcher cache file! Please report it.", e);
        }
    }

    public void readFromFile() {
        if (!this.cacheFile.exists()) {
            this.cacheState = State.UNAVAILABLE;
            StellarLog.LOG.info("[StellarCore-StitcherCache] Stitcher cache file is unavailable (File not found).");
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.cacheFile);
            this.readTag = LargeNBTUtils.readCompressed(fis);
            fis.close();
            this.cacheState = State.TAG_READY;
            StellarLog.LOG.info("[StellarCore-StitcherCache] Successfully read stitcher cache file from `{}`.", (Object)this.cacheFile.getAbsolutePath());
        }
        catch (Throwable e) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.cacheState = State.UNAVAILABLE;
            StellarLog.LOG.warn("[StellarCore-StitcherCache] Failed to read stitcher cache file, it may be broken.", e);
        }
    }

    public void parseTag(Stitcher stitcher, Set<Stitcher.Holder> targetHolders) {
        this.checkReadTaskState();
        if (this.cacheState != State.TAG_READY) {
            return;
        }
        try {
            this.fromNBT(this.readTag, stitcher);
            this.cacheState = this.holdersEquals(targetHolders) ? State.AVAILABLE : State.UNAVAILABLE;
            StellarLog.LOG.info("[StellarCore-StitcherCache] Stitcher cache parsed, state: {}.", (Object)this.cacheState);
        }
        catch (Throwable e) {
            StellarLog.LOG.warn("[StellarCore-StitcherCache] Failed to parse stitcher cache file, it may be broken.", e);
        }
    }

    public boolean holdersEquals(Set<Stitcher.Holder> targetHolders) {
        if (targetHolders.size() != this.holders.size()) {
            StellarLog.LOG.warn("[StellarCore-StitcherCache] Stitcher cache is unavailable, holders size not equals ({} \u2260 {}).", (Object)targetHolders.size(), (Object)this.holders.size());
            return false;
        }
        Object2ObjectOpenHashMap holders = new Object2ObjectOpenHashMap(this.holders);
        for (Stitcher.Holder holder : targetHolders) {
            Stitcher.Holder cachedHolder = (Stitcher.Holder)holders.get(holder.func_98150_a().func_94215_i());
            if (cachedHolder == null || !StitcherCache.holderEquals(cachedHolder, holder)) {
                if (cachedHolder == null) {
                    StellarLog.LOG.warn("[StellarCore-StitcherCache] Stitcher cache is unavailable, holder `{}` not found in cache.", (Object)holder.func_98150_a().func_94215_i());
                } else {
                    StellarLog.LOG.warn("[StellarCore-StitcherCache] Stitcher cache is unavailable, holder `{}` not equals.", (Object)holder.func_98150_a().func_94215_i());
                }
                return false;
            }
            holders.remove(holder.func_98150_a().func_94215_i());
        }
        if (!holders.isEmpty()) {
            StellarLog.LOG.warn("[StellarCore-StitcherCache] Stitcher cache is unavailable, {} holders not found in runtime.", (Object)holders.size());
            if (StellarCoreConfig.DEBUG.enableDebugLog) {
                holders.keySet().forEach(holderName -> StellarLog.LOG.warn("[StellarCore-StitcherCache] Holder `{}` not found in runtime.", holderName));
            }
            return false;
        }
        return true;
    }

    public void cache(Set<Stitcher.Holder> holders, List<Stitcher.Slot> slots, int width, int height) {
        this.holders.clear();
        this.slots.clear();
        holders.forEach(holder -> this.holders.put(holder.func_98150_a().func_94215_i(), (Stitcher.Holder)holder));
        this.slots.addAll(slots);
        this.width = width;
        this.height = height;
        this.cacheState = State.AVAILABLE;
    }

    public void clear() {
        this.holders.clear();
        this.slots.clear();
        this.readTag = null;
        this.width = 0;
        this.height = 0;
        this.cacheState = State.UNKNOWN;
    }

    public String getName() {
        return this.name;
    }

    public File getCacheFile() {
        return this.cacheFile;
    }

    public State getCacheState() {
        return this.cacheState;
    }

    public TextureMap getCacheFor() {
        return this.cacheFor;
    }

    public List<Stitcher.Slot> getSlots() {
        return this.slots;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList holdersTag = new NBTTagList();
        this.holders.values().stream().map(this::writeHolderNBT).forEach(arg_0 -> ((NBTTagList)holdersTag).func_74742_a(arg_0));
        tag.func_74782_a("holders", (NBTBase)holdersTag);
        NBTTagList slotsTag = new NBTTagList();
        this.slots.stream().map(StitcherCache::writeSlotNBT).forEach(arg_0 -> ((NBTTagList)slotsTag).func_74742_a(arg_0));
        tag.func_74782_a("slots", (NBTBase)slotsTag);
        tag.func_74768_a("width", this.width);
        tag.func_74768_a("height", this.height);
        return tag;
    }

    private NBTTagCompound writeHolderNBT(Stitcher.Holder holder) {
        NBTTagCompound holderTag = new NBTTagCompound();
        holderTag.func_74778_a("sprite", holder.func_98150_a().func_94215_i());
        holderTag.func_74757_a("rotated", holder.func_94195_e());
        if (holder.func_98150_a() == this.cacheFor.func_174944_f()) {
            holderTag.func_74757_a("empty", true);
        }
        return holderTag;
    }

    private static NBTTagCompound writeSlotNBT(Stitcher.Slot slot) {
        AccessorStitcherSlot slotAccessor = (AccessorStitcherSlot)slot;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("originX", slot.func_94186_b());
        tag.func_74768_a("originY", slot.func_94185_c());
        tag.func_74768_a("width", slotAccessor.width());
        tag.func_74768_a("height", slotAccessor.height());
        NBTTagList subSlotsTag = new NBTTagList();
        List<Stitcher.Slot> subSlots = slotAccessor.subSlots();
        if (subSlots != null && !subSlots.isEmpty()) {
            subSlots.stream().map(StitcherCache::writeSlotNBT).forEach(arg_0 -> ((NBTTagList)subSlotsTag).func_74742_a(arg_0));
        }
        tag.func_74782_a("subSlots", (NBTBase)subSlotsTag);
        Stitcher.Holder holder = slot.func_94183_a();
        if (holder == null) {
            tag.func_74757_a("holderEmpty", true);
        } else {
            tag.func_74778_a("holder", holder.func_98150_a().func_94215_i());
        }
        return tag;
    }

    private void checkReadTaskState() {
        if (this.readTask != null && !this.readTask.isDone()) {
            try {
                this.readTask.get();
            }
            catch (Throwable e) {
                StellarLog.LOG.error("[StellarCore-StitcherCache] Failed to read stitcher cache file! Please report it.", e);
            }
        }
    }

    private void fromNBT(NBTTagCompound tag, Stitcher stitcher) {
        this.holders.clear();
        this.slots.clear();
        NBTTagList holdersTagList = tag.func_150295_c("holders", 10);
        IntStream.range(0, holdersTagList.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)holdersTagList).func_150305_b(arg_0)).forEach(holderTag -> {
            Stitcher.Holder holder = this.readHolderNBT((NBTTagCompound)holderTag, stitcher);
            if (holder == null) {
                StellarLog.LOG.warn("[StellarCore-StitcherCache] Found null holder cache: `{}`, ignored.", (Object)holderTag.func_74779_i("sprite"));
                return;
            }
            this.holders.put(holder.func_98150_a().func_94215_i(), holder);
        });
        NBTTagList slotsTagList = tag.func_150295_c("slots", 10);
        int bound = slotsTagList.func_74745_c();
        for (int i2 = 0; i2 < bound; ++i2) {
            this.slots.add(null);
        }
        IntStream.range(0, bound).parallel().forEach(i -> this.slots.set(i, this.readSlotNBT(slotsTagList.func_150305_b(i))));
        this.width = tag.func_74762_e("width");
        this.height = tag.func_74762_e("height");
    }

    private Stitcher.Holder readHolderNBT(NBTTagCompound tag, Stitcher stitcher) {
        int maxTileDimension;
        TextureAtlasSprite sprite = this.cacheFor.getTextureExtry(tag.func_74779_i("sprite"));
        if (sprite == null) {
            if (tag.func_74767_n("empty")) {
                sprite = this.cacheFor.func_174944_f();
            } else {
                return null;
            }
        }
        AccessorStitcher stitcherAccessor = (AccessorStitcher)stitcher;
        Stitcher.Holder holder = new Stitcher.Holder(sprite, stitcherAccessor.getMipmapLevelStitcher());
        boolean rotated = tag.func_74767_n("rotated");
        if (holder.func_94195_e() != rotated) {
            holder.func_94194_d();
        }
        if ((maxTileDimension = stitcherAccessor.getMaxTileDimension()) > 0) {
            holder.func_94196_a(maxTileDimension);
        }
        return holder;
    }

    private Stitcher.Slot readSlotNBT(NBTTagCompound tag) {
        int originX = tag.func_74762_e("originX");
        int originY = tag.func_74762_e("originY");
        int width = tag.func_74762_e("width");
        int height = tag.func_74762_e("height");
        Stitcher.Slot slot = new Stitcher.Slot(originX, originY, width, height);
        AccessorStitcherSlot slotAccessor = (AccessorStitcherSlot)slot;
        NBTTagList subSlotsTag = tag.func_150295_c("subSlots", 10);
        if (subSlotsTag.func_74745_c() > 0) {
            ArrayList<Stitcher.Slot> subSlots = new ArrayList<Stitcher.Slot>();
            int bound = subSlotsTag.func_74745_c();
            for (int i = 0; i < bound; ++i) {
                NBTTagCompound tagAt = subSlotsTag.func_150305_b(i);
                Stitcher.Slot readSlotNBT = this.readSlotNBT(tagAt);
                subSlots.add(readSlotNBT);
            }
            slotAccessor.setSubSlots(subSlots);
        }
        if (!tag.func_74767_n("holderEmpty")) {
            Stitcher.Holder holder = this.holders.get(tag.func_74779_i("holder"));
            slotAccessor.setHolder(holder);
        }
        return slot;
    }

    private static boolean holderEquals(Stitcher.Holder self, Stitcher.Holder another) {
        AccessorStitcherHolder selfAccessor = (AccessorStitcherHolder)self;
        AccessorStitcherHolder anotherHolderAccessor = (AccessorStitcherHolder)another;
        if (selfAccessor.realWidth() == anotherHolderAccessor.realWidth()) {
            if (selfAccessor.realHeight() == anotherHolderAccessor.realHeight()) {
                if (self.func_94195_e() == another.func_94195_e()) {
                    if (selfAccessor.scaleFactor() == anotherHolderAccessor.scaleFactor()) {
                        return true;
                    }
                    StellarLog.LOG.warn("[StellarCore-StitcherCache] Holder `{}` and `{}` are not equal (ScaleFactor {} \u2260 {}).", (Object)self.func_98150_a().func_94215_i(), (Object)another.func_98150_a().func_94215_i(), (Object)Float.valueOf(selfAccessor.scaleFactor()), (Object)Float.valueOf(anotherHolderAccessor.scaleFactor()));
                } else {
                    StellarLog.LOG.warn("[StellarCore-StitcherCache] Holder `{}` and `{}` are not equal (Rotated {} \u2260 {}).", (Object)self.func_98150_a().func_94215_i(), (Object)another.func_98150_a().func_94215_i(), (Object)self.func_94195_e(), (Object)another.func_94195_e());
                }
            } else {
                StellarLog.LOG.warn("[StellarCore-StitcherCache] Holder `{}` and `{}` are not equal (Height {} \u2260 {}).", (Object)self.func_98150_a().func_94215_i(), (Object)another.func_98150_a().func_94215_i(), (Object)selfAccessor.realHeight(), (Object)anotherHolderAccessor.realHeight());
            }
        } else {
            StellarLog.LOG.warn("[StellarCore-StitcherCache] Holder `{}` and `{}` are not equal (Width {} \u2260 {}).", (Object)self.func_98150_a().func_94215_i(), (Object)another.func_98150_a().func_94215_i(), (Object)selfAccessor.realWidth(), (Object)anotherHolderAccessor.realWidth());
        }
        return false;
    }

    public static enum State {
        UNKNOWN,
        TAG_READY,
        AVAILABLE,
        UNAVAILABLE;

    }
}

