/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.client.pool;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.pool.AsyncCanonicalizePool;
import github.kasuminova.stellarcore.common.util.StellarLog;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Objects;
import net.minecraft.client.model.PositionTextureVertex;

public class TLMPositionTextureVertexPool
extends AsyncCanonicalizePool<PositionTextureVertex> {
    public static final TLMPositionTextureVertexPool INSTANCE = new TLMPositionTextureVertexPool();
    private final ObjectOpenCustomHashSet<PositionTextureVertex> pool = new ObjectOpenCustomHashSet((Hash.Strategy)PTVStrategy.access$000());

    private TLMPositionTextureVertexPool() {
    }

    @Override
    protected PositionTextureVertex canonicalizeInternal(PositionTextureVertex target) {
        return (PositionTextureVertex)this.pool.addOrGet((Object)target);
    }

    @Override
    public void onClearPre() {
        if (StellarCoreConfig.PERFORMANCE.tlm.texturedQuadFloatCanonicalization) {
            StellarLog.LOG.info("[StellarCore-TLMPositionTextureVertexPool] {} PositionTextureVertex processed. {} Unique, {} Deduplicated.", (Object)this.getProcessedCount(), (Object)this.pool.size(), (Object)(this.getProcessedCount() - (long)this.pool.size()));
        }
    }

    @Override
    public void onClearPost() {
        if (StellarCoreConfig.PERFORMANCE.tlm.texturedQuadFloatCanonicalization) {
            StellarLog.LOG.info("[StellarCore-TLMPositionTextureVertexPool] Pool cleared.");
        }
    }

    @Override
    protected String getName() {
        return "TLMPositionTextureVertexPool";
    }

    @Override
    protected ObjectSet<PositionTextureVertex> getPoolKeySet() {
        return this.pool;
    }

    @Override
    protected void clearPool() {
        this.pool.clear();
        this.pool.trim();
        this.worker.stop();
    }

    private static class PTVStrategy
    implements Hash.Strategy<PositionTextureVertex> {
        private static final PTVStrategy INSTANCE = new PTVStrategy();

        private PTVStrategy() {
        }

        public int hashCode(PositionTextureVertex o) {
            return Objects.hash(o.field_78243_a, Float.valueOf(o.field_78241_b), Float.valueOf(o.field_78242_c));
        }

        public boolean equals(PositionTextureVertex a, PositionTextureVertex b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.field_78243_a.equals((Object)b.field_78243_a) && a.field_78241_b == b.field_78241_b && a.field_78242_c == b.field_78242_c;
        }

        static /* synthetic */ PTVStrategy access$000() {
            return INSTANCE;
        }
    }
}

