/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.util.CAML;
import cam72cam.immersiverailroading.util.JSON;
import cam72cam.mod.resource.Identifier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public interface DataBlock {
    public Map<String, Value> getValueMap();

    public Map<String, List<Value>> getValuesMap();

    public Map<String, DataBlock> getBlockMap();

    public Map<String, List<DataBlock>> getBlocksMap();

    default public DataBlock getBlock(String key) {
        return this.getBlockMap().get(key);
    }

    default public List<DataBlock> getBlocks(String key) {
        return this.getBlocksMap().get(key);
    }

    default public Value getValue(String key) {
        return this.getValueMap().getOrDefault(key, Value.NULL);
    }

    default public List<Value> getValues(String key) {
        return this.getValuesMap().get(key);
    }

    public static DataBlock load(Identifier ident) throws IOException {
        return DataBlock.load(ident, false, null);
    }

    public static DataBlock load(Identifier ident, DataBlock parameters) throws IOException {
        return DataBlock.load(ident, false, parameters);
    }

    public static DataBlock load(Identifier ident, boolean last, DataBlock parameters) throws IOException {
        InputStream stream;
        InputStream inputStream = stream = last ? ident.getLastResourceStream() : ident.getResourceStream();
        if (parameters != null) {
            String input = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
            for (String key : parameters.getValueMap().keySet()) {
                input = input.replace(key, parameters.getValue(key).asString());
            }
            stream = IOUtils.toInputStream((String)input, (Charset)Charset.defaultCharset());
        }
        if (ident.getPath().toLowerCase(Locale.ROOT).endsWith(".caml")) {
            return CAML.parse(stream);
        }
        if (!ident.getPath().toLowerCase(Locale.ROOT).endsWith(".json")) {
            ImmersiveRailroading.warn((String)"Unexpected file extension '%s', trying JSON...", (Object[])new Object[]{ident.toString()});
        }
        return JSON.parse(stream);
    }

    public static interface Value {
        public static final Value NULL = new Value(){

            @Override
            public Boolean asBoolean() {
                return null;
            }

            @Override
            public Integer asInteger() {
                return null;
            }

            @Override
            public Float asFloat() {
                return null;
            }

            @Override
            public Double asDouble() {
                return null;
            }

            @Override
            public String asString() {
                return null;
            }
        };

        public Boolean asBoolean();

        default public boolean asBoolean(boolean fallback) {
            Boolean val = this.asBoolean();
            return val != null ? val : fallback;
        }

        public Integer asInteger();

        default public int asInteger(int fallback) {
            Integer val = this.asInteger();
            return val != null ? val : fallback;
        }

        public Float asFloat();

        default public float asFloat(float fallback) {
            Float val = this.asFloat();
            return val != null ? val.floatValue() : fallback;
        }

        public Double asDouble();

        default public double asDouble(double fallback) {
            Double val = this.asDouble();
            return val != null ? val : fallback;
        }

        public String asString();

        default public String asString(String fallback) {
            String val = this.asString();
            return val != null ? val : fallback;
        }

        default public Identifier asIdentifier() {
            String value = this.asString();
            return value != null ? new Identifier("immersiverailroading", new Identifier(value).getPath()) : null;
        }

        default public Identifier asIdentifier(Identifier fallback) {
            Identifier val = this.asIdentifier();
            return val != null && val.canLoad() ? val : fallback;
        }
    }
}

