/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.tile;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRBlocks;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.physics.SimulationState;
import cam72cam.immersiverailroading.items.ItemRailAugment;
import cam72cam.immersiverailroading.items.ItemTrackExchanger;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.CouplerAugmentMode;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.LocoControlMode;
import cam72cam.immersiverailroading.library.Permissions;
import cam72cam.immersiverailroading.library.RedstoneMode;
import cam72cam.immersiverailroading.library.StockDetectorMode;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.model.part.Door;
import cam72cam.immersiverailroading.physics.MovementTrack;
import cam72cam.immersiverailroading.thirdparty.trackapi.BlockEntityTrackTickable;
import cam72cam.immersiverailroading.thirdparty.trackapi.ITrack;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailGag;
import cam72cam.immersiverailroading.util.MathUtil;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.immersiverailroading.util.SwitchUtil;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.block.BlockEntity;
import cam72cam.mod.block.BlockType;
import cam72cam.mod.block.IRedstoneProvider;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.boundingbox.IBoundingBox;
import cam72cam.mod.fluid.FluidTank;
import cam72cam.mod.fluid.ITank;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.IInventory;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.item.ItemStackHandler;
import cam72cam.mod.item.ToolType;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.sound.Audio;
import cam72cam.mod.sound.SoundCategory;
import cam72cam.mod.sound.StandardSound;
import cam72cam.mod.text.PlayerMessage;
import cam72cam.mod.util.Facing;
import cam72cam.mod.util.SingleCache;
import cam72cam.mod.world.World;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class TileRailBase
extends BlockEntityTrackTickable
implements IRedstoneProvider {
    @TagField(value="parent")
    private Vec3i parent;
    @TagField(value="height")
    private float bedHeight = 0.0f;
    @TagField(value="railHeight")
    private float railHeight = 0.0f;
    @TagField(value="augment")
    private Augment augment;
    @TagField(value="augmentFilterID")
    private String augmentFilterID;
    @TagField(value="snowLayers")
    private int snowLayers = 0;
    @TagField(value="flexible")
    protected boolean flexible = false;
    private boolean willBeReplaced = false;
    @TagField(value="replaced")
    private TagCompound replaced;
    private boolean skipNextRefresh = false;
    public ItemStack railBedCache = null;
    private final FluidTank emptyTank = new FluidTank(null, 0);
    private final IInventory emptyInventory = new ItemStackHandler(0);
    private int redstoneLevel = 0;
    @TagField(value="redstoneMode")
    private StockDetectorMode detectorMode = StockDetectorMode.SIMPLE;
    @TagField(value="controlMode")
    private LocoControlMode controlMode = LocoControlMode.THROTTLE;
    @TagField(value="couplerMod")
    private CouplerAugmentMode couplerMode = CouplerAugmentMode.ENGAGED;
    @TagField(value="redstoneSensitivity")
    private RedstoneMode redstoneMode = RedstoneMode.ENABLED;
    private int ticksExisted;
    public boolean blockUpdate;
    private Gauge augmentGauge;
    @TagField(value="stockTag")
    private String stockTag;
    private EntityMoveableRollingStock overhead;
    @TagField(value="pushPull")
    private boolean pushPull = true;
    private final SingleCache<Vec3i, Vec3i> parentCache = new SingleCache(parent -> parent.add(this.getPos()));
    protected Double cachedGauge = null;
    private Collection<TileRail> tiles = null;
    private final SingleCache<Double, IBoundingBox> boundingBox = new SingleCache(height -> IBoundingBox.ORIGIN.expand(new Vec3d(1.0, height.doubleValue(), 1.0)));

    public void setBedHeight(float height) {
        this.bedHeight = height;
    }

    public float getBedHeight() {
        if (this.replaced != null && this.replaced.hasKey("height")) {
            float replacedHeight = this.replaced.getFloat("height").floatValue();
            return Math.min(this.bedHeight, replacedHeight);
        }
        return this.bedHeight;
    }

    public double getRenderGauge() {
        double gauge = 0.0;
        TileRail parent = this.getParentTile();
        if (parent != null && parent.info != null) {
            gauge = parent.info.settings.gauge.value();
        }
        if (this.getParentReplaced() != null && this.getWorld() != null && (parent = (TileRail)this.getWorld().getBlockEntity(this.getParentReplaced(), TileRail.class)) != null && parent.info != null) {
            gauge = Math.min(gauge, parent.info.settings.gauge.value());
        }
        return gauge;
    }

    public void setRailHeight(float height) {
        this.railHeight = height;
    }

    public float getRailHeight() {
        return this.railHeight;
    }

    public void setAugment(Augment augment) {
        this.augment = augment;
        if (this.getParentTile() != null) {
            this.augmentGauge = this.getParentTile().info.settings.gauge;
            if (Config.ConfigDebug.defaultAugmentComputer && augment != null) {
                switch (augment) {
                    case DETECTOR: {
                        this.detectorMode = StockDetectorMode.COMPUTER;
                        break;
                    }
                    case LOCO_CONTROL: {
                        this.controlMode = LocoControlMode.COMPUTER;
                    }
                }
            }
        }
        this.setAugmentFilter(null);
        this.redstoneMode = RedstoneMode.ENABLED;
        this.markDirty();
    }

    public boolean setAugmentFilter(String definitionID) {
        this.augmentFilterID = definitionID != null && !definitionID.equals(this.augmentFilterID) ? definitionID : null;
        this.markDirty();
        return this.augmentFilterID != null;
    }

    public PlayerMessage nextAugmentRedstoneMode(boolean isPiston) {
        if (this.augment == null) {
            return null;
        }
        switch (this.augment) {
            case DETECTOR: {
                this.detectorMode = StockDetectorMode.values()[(this.detectorMode.ordinal() + 1) % StockDetectorMode.values().length];
                return PlayerMessage.translate((String)this.detectorMode.toString(), (Object[])new Object[0]);
            }
            case LOCO_CONTROL: {
                this.controlMode = LocoControlMode.values()[(this.controlMode.ordinal() + 1) % LocoControlMode.values().length];
                return PlayerMessage.translate((String)this.controlMode.toString(), (Object[])new Object[0]);
            }
            case COUPLER: {
                if (isPiston) {
                    this.couplerMode = CouplerAugmentMode.values()[(this.couplerMode.ordinal() + 1) % CouplerAugmentMode.values().length];
                    return PlayerMessage.translate((String)this.couplerMode.toString(), (Object[])new Object[0]);
                }
            }
            case ITEM_LOADER: 
            case ITEM_UNLOADER: 
            case FLUID_LOADER: 
            case FLUID_UNLOADER: {
                if (isPiston) {
                    this.pushPull = !this.pushPull;
                    return PlayerMessage.translate((String)("immersiverailroading:augment.pushpull." + (this.pushPull ? "enabled" : "disabled")), (Object[])new Object[0]);
                }
                this.redstoneMode = RedstoneMode.values()[(this.redstoneMode.ordinal() + 1) % RedstoneMode.values().length];
                return PlayerMessage.translate((String)this.redstoneMode.toString(), (Object[])new Object[0]);
            }
        }
        return null;
    }

    public Augment getAugment() {
        return this.augment;
    }

    public int getSnowLayers() {
        return this.snowLayers;
    }

    public void setSnowLayers(int snowLayers) {
        this.snowLayers = snowLayers;
        this.markDirty();
    }

    public float getFullHeight() {
        return this.bedHeight + (float)this.snowLayers / 8.0f;
    }

    public void handleSnowTick() {
        if (this.snowLayers < (Config.ConfigDebug.deepSnow ? 8 : 1)) {
            ++this.snowLayers;
            this.markDirty();
        }
    }

    public Vec3i getParent() {
        if (this.parent == null) {
            if (this.ticksExisted > 5 && this.getWorld().isServer) {
                ImmersiveRailroading.warn((String)"Invalid block without parent", (Object[])new Object[0]);
                this.getWorld().setToAir(this.getPos());
            }
            return null;
        }
        return (Vec3i)this.parentCache.get((Object)this.parent);
    }

    public void setParent(Vec3i pos) {
        this.parent = pos.subtract(this.getPos());
    }

    public boolean isFlexible() {
        return this.flexible || !(this instanceof TileRail);
    }

    public ItemStack getRenderRailBed() {
        TileRail pt;
        if (this.railBedCache == null && this.getParent() != null && this.getWorld().isBlockLoaded(this.getParent()) && (pt = this.getParentTile()) != null) {
            this.railBedCache = pt.info.settings.railBed;
        }
        return this.railBedCache;
    }

    public void writeUpdate(TagCompound nbt) {
        if (this.getRenderRailBed() != null) {
            nbt.set("renderBed", this.getRenderRailBed().toTag());
        }
    }

    public void readUpdate(TagCompound nbt) {
        if (nbt.hasKey("renderBed")) {
            this.railBedCache = new ItemStack(nbt.get("renderBed"));
        }
    }

    public void load(TagCompound nbt) {
        int version = 0;
        if (nbt.hasKey("version")) {
            version = nbt.getInteger("version");
        }
        switch (version) {
            case 0: 
            case 1: {
                this.parent = this.parent.subtract(this.getPos());
            }
            case 2: 
            case 3: {
                if (nbt.hasKey("railHeight")) break;
                this.railHeight = this.bedHeight;
            }
        }
    }

    public void save(TagCompound nbt) {
        nbt.setInteger("version", Integer.valueOf(4));
    }

    public TileRail getParentTile() {
        if (this.getParent() == null) {
            return null;
        }
        TileRail te = (TileRail)this.getWorld().getBlockEntity(this.getParent(), TileRail.class);
        if (te == null || te.info == null) {
            return null;
        }
        return te;
    }

    public void setReplaced(TagCompound replaced) {
        this.replaced = replaced;
    }

    public TagCompound getReplaced() {
        return this.replaced;
    }

    public TileRailBase getReplacedTile() {
        return this.replaced != null ? (TileRailBase)this.getWorld().reconstituteBlockEntity(this.replaced) : null;
    }

    public void setWillBeReplaced(boolean value) {
        this.willBeReplaced = value;
    }

    public boolean getWillBeReplaced() {
        return this.willBeReplaced;
    }

    public void cleanSnow() {
        int snow = this.getSnowLayers();
        if (snow > 1) {
            this.setSnowLayers(1);
            int snowDown = snow - 1;
            for (int i = 1; i <= 3; ++i) {
                Object[] horiz = (Facing[])Facing.values().clone();
                if (Math.random() > 0.5) {
                    ArrayUtils.reverse((Object[])horiz);
                }
                for (Object facing : horiz) {
                    Vec3i ph = this.getWorld().getPrecipitationHeight(this.getPos().offset((Facing)facing, i));
                    for (int j = 0; j < 3; ++j) {
                        if (this.getWorld().isAir(ph) && !ITrack.isRail(this.getWorld(), ph.down())) {
                            this.getWorld().setSnowLevel(ph, snowDown);
                            return;
                        }
                        int currSnow = this.getWorld().getSnowLevel(ph);
                        if (currSnow > 0 && currSnow < 8) {
                            int toAdd = Math.min(8 - currSnow, snowDown);
                            this.getWorld().setSnowLevel(ph, currSnow + toAdd);
                            if ((snowDown -= toAdd) <= 0) {
                                return;
                            }
                        }
                        ph = ph.down();
                    }
                }
            }
        }
    }

    @Override
    public double getTrackGauge() {
        TileRail parent;
        if (this.cachedGauge == null && this.getParent() != null && (parent = this.getParentTile()) != null) {
            this.cachedGauge = parent.info.settings.gauge.value();
        }
        return this.cachedGauge != null ? this.cachedGauge : 0.0;
    }

    @Override
    public Vec3d getNextPosition(Vec3d currentPosition, Vec3d motion) {
        double maxDistance;
        double distanceMetersSq = motion.lengthSquared();
        if (distanceMetersSq * 0.9 > (maxDistance = 0.25) * maxDistance) {
            return MovementTrack.iterativePathing(this.getWorld(), currentPosition, this, this.getTrackGauge(), motion, maxDistance);
        }
        return this.getNextPositionShort(currentPosition, motion);
    }

    public Vec3d getNextPositionShort(Vec3d currentPosition, Vec3d motion) {
        if (this.getReplaced() == null) {
            Vec3d potential;
            TileRail tile;
            TileRail tileRail = tile = this instanceof TileRail ? (TileRail)this : this.getParentTile();
            if (tile == null) {
                return currentPosition;
            }
            SwitchState state = SwitchUtil.getSwitchState(tile, currentPosition);
            if (state == SwitchState.STRAIGHT) {
                tile = tile.getParentTile();
            }
            if ((potential = MovementTrack.nextPositionDirect(this.getWorld(), currentPosition, tile, motion)) != null) {
                return potential;
            }
            return currentPosition;
        }
        if (this.tiles == null) {
            HashMap<Vec3i, TileRail> tileMap = new HashMap<Vec3i, TileRail>();
            for (TileRailBase current = this; current != null; current = current.getReplacedTile()) {
                TileRail tile;
                TileRail parent;
                for (parent = tile = current instanceof TileRail ? (TileRail)current : current.getParentTile(); parent != null && !parent.getPos().equals((Object)parent.getParent()); parent = parent.getParentTile()) {
                }
                if (tile == null || parent == null) continue;
                tileMap.putIfAbsent(parent.getPos(), tile);
            }
            this.tiles = tileMap.values();
        }
        Vec3d nextPos = currentPosition;
        Vec3d predictedPos = currentPosition.add(motion);
        boolean hasSwitchSet = false;
        for (TileRail tile : this.tiles) {
            Vec3d potential;
            SwitchState state = SwitchUtil.getSwitchState(tile, currentPosition);
            if (state == SwitchState.STRAIGHT) {
                tile = tile.getParentTile();
            }
            if ((potential = MovementTrack.nextPositionDirect(this.getWorld(), currentPosition, tile, motion)) == null) continue;
            if (state == SwitchState.TURN) {
                float other = VecUtil.toWrongYaw(potential.subtract(currentPosition));
                float rotationYaw = VecUtil.toWrongYaw(motion);
                double diff = MathUtil.trueModulus(other - rotationYaw, 360.0);
                if ((diff = Math.min(360.0 - diff, diff)) < 2.5) {
                    hasSwitchSet = true;
                    nextPos = potential;
                }
            }
            if (currentPosition != nextPos && (hasSwitchSet || !(potential.distanceToSquared(predictedPos) < nextPos.distanceToSquared(predictedPos)))) continue;
            nextPos = potential;
        }
        return nextPos;
    }

    public <T extends EntityRollingStock> T getStockNearBy(Class<T> type) {
        if (this.overhead == null) {
            return null;
        }
        if (this.augmentFilterID != null && !this.augmentFilterID.equals(this.overhead.getDefinitionID())) {
            return null;
        }
        if (this.stockTag != null && !this.stockTag.equals(this.overhead.tag)) {
            return null;
        }
        return (T)((Object)((EntityRollingStock)this.overhead.as(type)));
    }

    private boolean canOperate() {
        switch (this.redstoneMode) {
            case ENABLED: {
                return true;
            }
            case REQUIRED: {
                return this.getWorld().getRedstone(this.getPos()) > 0;
            }
            case INVERTED: {
                return this.getWorld().getRedstone(this.getPos()) == 0;
            }
        }
        return false;
    }

    public IInventory getInventory(Facing side) {
        if (this.getAugment() != null) {
            switch (this.getAugment()) {
                case ITEM_LOADER: 
                case ITEM_UNLOADER: {
                    Freight freight;
                    if (this.canOperate() && (freight = this.getStockNearBy(Freight.class)) != null && !freight.isDead()) {
                        return freight.cargoItems;
                    }
                    return this.emptyInventory;
                }
            }
        }
        return null;
    }

    public ITank getTank(Facing side) {
        if (this.getAugment() != null) {
            switch (this.getAugment()) {
                case FLUID_LOADER: 
                case FLUID_UNLOADER: {
                    FreightTank stock;
                    if (this.canOperate() && (stock = this.getStockNearBy(FreightTank.class)) != null) {
                        return stock.theTank;
                    }
                    return this.emptyTank;
                }
            }
        }
        return null;
    }

    public void update() {
        block57: {
            SimulationState state;
            if (this.getWorld().isClient) {
                return;
            }
            ++this.ticksExisted;
            if (Config.ConfigDebug.snowAccumulateRate > 0 && (int)(Math.random() * (double)Config.ConfigDebug.snowAccumulateRate * 10.0) == 0 && this.getWorld().isSnowing(this.getPos()) && this.getWorld().canSeeSky(this.getPos().up())) {
                this.handleSnowTick();
            }
            if (Config.ConfigDebug.snowMeltRate != 0 && this.snowLayers != 0 && (int)(Math.random() * (double)Config.ConfigDebug.snowMeltRate * 10.0) == 0 && !this.getWorld().isSnowing(this.getPos())) {
                this.setSnowLayers(--this.snowLayers);
            }
            if (this.ticksExisted > 5 && this.blockUpdate || this.ticksExisted % 100 == 0 && this.ticksExisted > 400) {
                double floating;
                this.blockUpdate = false;
                if (this.getParent() == null || !this.getWorld().isBlockLoaded(this.getParent())) {
                    return;
                }
                if (this.getParentTile() == null) {
                    if (IRBlocks.BLOCK_RAIL_GAG.tryBreak(this.getWorld(), this.getPos(), null)) {
                        this.getWorld().breakBlock(this.getPos());
                    }
                    return;
                }
                this.augmentGauge = this.getParentTile().info.settings.gauge;
                if (Config.ConfigDamage.requireSolidBlocks && this instanceof TileRail && this.getWorld().isBlock(this.getPos(), (BlockType)IRBlocks.BLOCK_RAIL) && (floating = ((TileRail)this).percentFloating()) > Config.ConfigBalance.trackFloatingPercent) {
                    if (this.tryBreak(null)) {
                        this.getWorld().breakBlock(this.getPos());
                    }
                    return;
                }
            }
            if (this.augment == null) {
                return;
            }
            if (!(this.overhead == null || this.ticksExisted % 5 != 0 || (state = this.overhead.getCurrentState()) != null && state.trackToUpdate.contains(this.getPos()))) {
                this.overhead = null;
            }
            if (this.ticksExisted % 20 == 0) {
                switch (this.augment) {
                    case ITEM_LOADER: 
                    case ITEM_UNLOADER: 
                    case FLUID_LOADER: 
                    case FLUID_UNLOADER: {
                        this.markDirty();
                    }
                }
            }
            if (!this.canOperate()) {
                return;
            }
            try {
                block4 : switch (this.augment) {
                    case ITEM_LOADER: {
                        Freight freight;
                        if (!this.pushPull || (freight = this.getStockNearBy(Freight.class)) == null) break;
                        for (Facing side : Facing.values()) {
                            IInventory inventory = this.getWorld().getInventory(this.getPos().offset(side));
                            if (inventory == null) continue;
                            inventory.transferAllTo((IInventory)freight.cargoItems);
                        }
                        break;
                    }
                    case ITEM_UNLOADER: {
                        Freight freight;
                        if (!this.pushPull || (freight = this.getStockNearBy(Freight.class)) == null) break;
                        for (Facing side : Facing.values()) {
                            IInventory inventory = this.getWorld().getInventory(this.getPos().offset(side));
                            if (inventory == null) continue;
                            inventory.transferAllFrom((IInventory)freight.cargoItems);
                        }
                        break;
                    }
                    case FLUID_LOADER: {
                        FreightTank stock;
                        if (!this.pushPull || (stock = this.getStockNearBy(FreightTank.class)) == null) break;
                        for (Facing side : Facing.values()) {
                            List tanks = this.getWorld().getTank(this.getPos().offset(side));
                            if (tanks == null) continue;
                            tanks.forEach(tank -> stock.theTank.drain(tank, 100, false));
                        }
                        break;
                    }
                    case FLUID_UNLOADER: {
                        FreightTank stock;
                        if (!this.pushPull || (stock = this.getStockNearBy(FreightTank.class)) == null) break;
                        for (Facing side : Facing.values()) {
                            List tanks = this.getWorld().getTank(this.getPos().offset(side));
                            if (tanks == null) continue;
                            tanks.forEach(tank -> stock.theTank.fill(tank, 100, false));
                        }
                        break;
                    }
                    case WATER_TROUGH: {
                        break;
                    }
                    case LOCO_CONTROL: {
                        Locomotive loco = this.getStockNearBy(Locomotive.class);
                        if (loco != null) {
                            int power = this.getWorld().getRedstone(this.getPos());
                            switch (this.controlMode) {
                                case THROTTLE: {
                                    loco.setThrottle((float)power / 15.0f);
                                    break block4;
                                }
                                case REVERSER: {
                                    loco.setReverser(((float)power / 14.0f - 0.5f) * 2.0f);
                                    break block4;
                                }
                                case BRAKE: {
                                    loco.setTrainBrake((float)power / 15.0f);
                                    break block4;
                                }
                                case HORN: {
                                    loco.setHorn(40, (float)power / 15.0f);
                                    break block4;
                                }
                                case BELL: {
                                    loco.setBell(10 * power);
                                    break block4;
                                }
                            }
                        }
                        break;
                    }
                    case DETECTOR: {
                        EntityMoveableRollingStock stock = this.getStockNearBy(EntityMoveableRollingStock.class);
                        int currentRedstone = this.redstoneLevel;
                        int newRedstone = 0;
                        switch (this.detectorMode) {
                            case SIMPLE: {
                                newRedstone = stock != null ? 15 : 0;
                                break;
                            }
                            case SPEED: {
                                newRedstone = stock != null ? (int)Math.floor(Math.abs(stock.getCurrentSpeed().metric()) / 10.0) : 0;
                                break;
                            }
                            case PASSENGERS: {
                                newRedstone = stock != null ? Math.min(15, stock.getPassengerCount()) : 0;
                                break;
                            }
                            case CARGO: {
                                newRedstone = 0;
                                if (!(stock instanceof Freight)) break;
                                newRedstone = ((Freight)stock).getPercentCargoFull() * 15 / 100;
                                break;
                            }
                            case LIQUID: {
                                newRedstone = 0;
                                if (!(stock instanceof FreightTank)) break;
                                newRedstone = ((FreightTank)stock).getPercentLiquidFull() * 15 / 100;
                            }
                        }
                        if (newRedstone != currentRedstone) {
                            this.redstoneLevel = newRedstone;
                            this.markDirty();
                        }
                        break;
                    }
                    case COUPLER: {
                        EntityCoupleableRollingStock stock = this.getStockNearBy(EntityCoupleableRollingStock.class);
                        if (stock == null) break;
                        switch (this.couplerMode) {
                            case ENGAGED: {
                                for (EntityCoupleableRollingStock.CouplerType coupler : EntityCoupleableRollingStock.CouplerType.values()) {
                                    stock.setCouplerEngaged(coupler, true);
                                }
                                break block57;
                            }
                            case DISENGAGED: {
                                for (EntityCoupleableRollingStock.CouplerType coupler : EntityCoupleableRollingStock.CouplerType.values()) {
                                    stock.setCouplerEngaged(coupler, false);
                                }
                            }
                        }
                        break;
                    }
                    case ACTUATOR: {
                        EntityRollingStock stock = this.getStockNearBy(EntityRollingStock.class);
                        if (stock != null) {
                            float value = (float)this.getWorld().getRedstone(this.getPos()) / 15.0f;
                            for (Door<?> d : stock.getDefinition().getModel().getDoors()) {
                                if (d.type != Door.Types.EXTERNAL) continue;
                                stock.setControlPosition(d, value);
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception ex) {
                ImmersiveRailroading.catching((Throwable)ex);
            }
        }
    }

    public int getStrongPower(Facing facing) {
        return this.getAugment() == Augment.DETECTOR ? this.redstoneLevel : 0;
    }

    public int getWeakPower(Facing facing) {
        return this.getAugment() == Augment.DETECTOR ? this.redstoneLevel : 0;
    }

    public Vec3i getParentReplaced() {
        if (this.replaced == null) {
            return null;
        }
        if (!this.replaced.hasKey("parent")) {
            return null;
        }
        return new Vec3i(this.replaced.getLong("parent").longValue()).add(this.getPos());
    }

    public SwitchState cycleSwitchForced() {
        TileRail tileSwitch = this.findSwitchParent();
        SwitchState newForcedState = SwitchState.NONE;
        if (tileSwitch != null) {
            newForcedState = SwitchState.values()[(tileSwitch.info.switchForced.ordinal() + 1) % SwitchState.values().length];
            this.setSwitchForced(newForcedState);
        }
        return newForcedState;
    }

    public void setSwitchForced(SwitchState newForcedState) {
        TileRail tileSwitch = this.findSwitchParent();
        if (tileSwitch != null && newForcedState != tileSwitch.info.switchForced) {
            tileSwitch.info = tileSwitch.info.with(b -> {
                b.switchForced = newForcedState;
            });
        }
    }

    public boolean isSwitchForced() {
        TileRail tileSwitch = this.findSwitchParent();
        if (tileSwitch != null) {
            return tileSwitch.info.switchForced != SwitchState.NONE;
        }
        return false;
    }

    public TileRail findSwitchParent() {
        return this.findSwitchParent(this);
    }

    public TileRail findSwitchParent(TileRailBase cur) {
        if (cur == null) {
            return null;
        }
        if (cur instanceof TileRail) {
            TileRail curTR = (TileRail)cur;
            if (curTR.info.settings.type.equals((Object)TrackItems.SWITCH)) {
                return curTR;
            }
        }
        if (cur.getPos().equals((Object)cur.getParentTile().getPos())) {
            return null;
        }
        return this.findSwitchParent(cur.getParentTile());
    }

    public IBoundingBox getBoundingBox() {
        if (this instanceof TileRailGag && (this.getParent() == null || !this.getWorld().isBlockLoaded(this.getParent()))) {
            return (IBoundingBox)this.boundingBox.get((Object)((double)this.getFullHeight() + 0.1));
        }
        return (IBoundingBox)this.boundingBox.get((Object)((double)this.getFullHeight() + 0.1 * (this.getTrackGauge() / 1.435)));
    }

    public void onBreak() {
        if (this instanceof TileRail) {
            ((TileRail)this).spawnDrops();
        }
        if (this.augment != null && this.augmentGauge != null) {
            ItemStack stack = new ItemStack((CustomItem)IRItems.ITEM_AUGMENT, 1);
            ItemRailAugment.Data data = new ItemRailAugment.Data(stack);
            data.augment = this.augment;
            data.gauge = this.augmentGauge;
            data.write();
            this.getWorld().dropItem(stack, this.getPos());
        }
        this.breakParentIfExists();
    }

    public boolean onClick(Player player, Player.Hand hand, Facing facing, Vec3d hit) {
        PlayerMessage next;
        ItemStack stack = player.getHeldItem(hand);
        if (stack.is((CustomItem)IRItems.ITEM_TRACK_EXCHANGER) && player.hasPermission(Permissions.EXCHANGE_TRACK)) {
            TileRail tileRail = this.getParentTile();
            ItemTrackExchanger.Data stackData = new ItemTrackExchanger.Data(stack);
            String track = stackData.track;
            ItemStack railBed = stackData.railBed;
            Gauge gauge = stackData.gauge;
            if (!(track.equals(tileRail.info.settings.track) && railBed.equals((Object)tileRail.info.settings.railBed) && gauge.equals(tileRail.info.settings.gauge))) {
                RailInfo info = tileRail.info.withSettings(b -> {
                    b.track = track;
                    b.railBed = railBed;
                    b.gauge = gauge;
                });
                Audio.playSound((World)this.getWorld(), (Vec3i)this.getPos(), (StandardSound)StandardSound.BLOCK_ANVIL_PLACE, (SoundCategory)SoundCategory.BLOCKS, (float)0.3f, (float)0.2f);
                if (!player.isCreative()) {
                    List<ItemStack> drops = tileRail.getDrops();
                    List<ItemStack> newDrops = info.build(player, tileRail.getPos(), false);
                    if (newDrops != null) {
                        tileRail.info = info;
                        if (drops != null) {
                            for (ItemStack drop : drops) {
                                this.getWorld().dropItem(drop, player.getPosition());
                            }
                        }
                        tileRail.setDrops(newDrops);
                        tileRail.markAllDirty();
                    }
                } else {
                    tileRail.info = info;
                    tileRail.markAllDirty();
                }
            }
            return true;
        }
        if (stack.is(Fuzzy.NAME_TAG) && player.hasPermission(Permissions.AUGMENT_TRACK)) {
            if (this.getWorld().isServer) {
                if (player.isCrouching()) {
                    this.stockTag = null;
                    player.sendMessage(ChatText.RESET_AUGMENT_FILTER.getMessage(new Object[0]));
                } else {
                    this.stockTag = stack.getDisplayName();
                    player.sendMessage(ChatText.SET_AUGMENT_FILTER.getMessage(this.stockTag));
                }
            }
            return true;
        }
        if (player.hasPermission(Permissions.AUGMENT_TRACK) && (stack.is(Fuzzy.REDSTONE_TORCH) || stack.is(Fuzzy.REDSTONE_DUST) || stack.is(Fuzzy.PISTON)) && (next = this.nextAugmentRedstoneMode(stack.is(Fuzzy.PISTON))) != null) {
            if (this.getWorld().isServer) {
                player.sendMessage(next);
            }
            return true;
        }
        if (stack.is(Fuzzy.SNOW_LAYER)) {
            if (this.getWorld().isServer) {
                this.handleSnowTick();
            }
            return true;
        }
        if (stack.is(Fuzzy.SNOW_BLOCK)) {
            if (this.getWorld().isServer) {
                for (int i = 0; i < 8; ++i) {
                    this.handleSnowTick();
                }
            }
            return true;
        }
        if (stack.isValidTool(ToolType.SHOVEL)) {
            if (this.getWorld().isServer) {
                this.cleanSnow();
                this.setSnowLayers(0);
                stack.damageItem(1, player);
            }
            return true;
        }
        return false;
    }

    public ItemStack onPick() {
        ItemStack stack = new ItemStack((CustomItem)IRItems.ITEM_TRACK_BLUEPRINT, 1);
        TileRail parent = this.getParentTile();
        if (parent == null) {
            return stack;
        }
        parent.info.settings.write(stack);
        return stack;
    }

    public void onNeighborChange(Vec3i neighbor) {
        TileRailBase te = this;
        if (this.getWorld().isClient) {
            return;
        }
        this.blockUpdate = true;
        TagCompound data = te.getReplaced();
        while (true) {
            TileRail teParent;
            if ((teParent = te.getParentTile()) != null && teParent.getParentTile() != null) {
                SwitchState state;
                TileRail switchTile = te.getParentTile();
                if (te instanceof TileRail) {
                    switchTile = (TileRail)te;
                }
                if ((state = SwitchUtil.getSwitchState(switchTile)) != SwitchState.NONE) {
                    switchTile.setSwitchState(state);
                }
            }
            if (data == null || (te = (TileRailBase)this.getWorld().reconstituteBlockEntity(data)) == null) break;
            data = te.getReplaced();
        }
    }

    private void breakParentIfExists() {
        TileRail parent = this.getParentTile();
        if (parent != null && !this.getWillBeReplaced()) {
            parent.spawnDrops();
            this.getWorld().setToAir(parent.getPos());
        }
    }

    public boolean tryBreak(Player player) {
        if (player != null && !player.hasPermission(Permissions.BREAK_TRACK)) {
            return false;
        }
        try {
            TileRailBase rail = this;
            if (rail.getReplaced() != null) {
                TagCompound data;
                TileRailGag newGag = (TileRailGag)this.getWorld().reconstituteBlockEntity(rail.getReplaced());
                if (newGag == null) {
                    return true;
                }
                do {
                    if (newGag.getParent() == null || !this.getWorld().hasBlockEntity(newGag.getParent(), TileRail.class)) continue;
                    this.getWorld().setBlockEntity(this.getPos(), (BlockEntity)newGag);
                    rail.breakParentIfExists();
                    return false;
                } while ((data = newGag.getReplaced()) != null && (newGag = (TileRailGag)this.getWorld().reconstituteBlockEntity(data)) != null);
            }
        }
        catch (StackOverflowError ex) {
            ImmersiveRailroading.error((String)"Invalid recursive rail block at %s", (Object[])new Object[]{this.getPos()});
            ImmersiveRailroading.catching((Throwable)ex);
            this.getWorld().setToAir(this.getPos());
        }
        return true;
    }

    public boolean clacks() {
        return this.getParent() != null && this.getParentTile().clacks();
    }

    public float getBumpiness() {
        return this.getParent() != null ? this.getParentTile().getBumpiness() : 1.0f;
    }

    public boolean isCog() {
        return this.getParentTile() != null ? this.getParentTile().isCog() : false;
    }

    public int getTicksExisted() {
        return this.ticksExisted;
    }

    public void stockOverhead(EntityMoveableRollingStock stock) {
        this.overhead = stock;
    }
}

