/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.model.TrackModel;
import cam72cam.immersiverailroading.registry.CarFreightDefinition;
import cam72cam.immersiverailroading.registry.CarPassengerDefinition;
import cam72cam.immersiverailroading.registry.CarTankDefinition;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.HandCarDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDieselDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveSteamDefinition;
import cam72cam.immersiverailroading.registry.TenderDefinition;
import cam72cam.immersiverailroading.registry.TrackDefinition;
import cam72cam.immersiverailroading.util.CAML;
import cam72cam.immersiverailroading.util.DataBlock;
import cam72cam.immersiverailroading.util.JSON;
import cam72cam.mod.gui.Progress;
import cam72cam.mod.resource.Identifier;
import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class DefinitionManager {
    private static Map<String, EntityRollingStockDefinition> definitions;
    private static Map<String, TrackDefinition> tracks;
    private static final Map<String, StockLoader> stockLoaders;

    private static void initGauges() throws IOException {
        for (Gauge value2 : new ArrayList<Gauge>(Gauge.values())) {
            Gauge.remove(value2.value());
        }
        ArrayList<DataBlock> blocks = new ArrayList<DataBlock>();
        Identifier gauges_json = new Identifier("immersiverailroading", "rolling_stock/gauges.json");
        List inputs = gauges_json.getResourceStreamAll();
        for (Object input : inputs) {
            blocks.add(JSON.parse((InputStream)input));
        }
        Identifier gauges_caml = new Identifier("immersiverailroading", "rolling_stock/gauges.caml");
        inputs = gauges_caml.getResourceStreamAll();
        for (InputStream input : inputs) {
            blocks.add(CAML.parse(input));
        }
        ArrayList<Double> toRemove = new ArrayList<Double>();
        for (DataBlock gauges : blocks) {
            List<DataBlock.Value> remove;
            DataBlock register = gauges.getBlock("register");
            if (register != null) {
                register.getValueMap().forEach((key, value) -> Gauge.register(value.asDouble(), key));
            }
            if ((remove = gauges.getValues("remove")) == null) continue;
            for (DataBlock.Value gauge : remove) {
                toRemove.add(gauge.asDouble());
            }
        }
        Iterator iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            double gauge = (Double)iterator.next();
            Gauge.remove(gauge);
        }
    }

    public static void initDefinitions() {
        if (definitions != null) {
            for (EntityRollingStockDefinition entityRollingStockDefinition : definitions.values()) {
                if (entityRollingStockDefinition.model == null) continue;
                entityRollingStockDefinition.model.free();
            }
        }
        if (tracks != null) {
            for (TrackDefinition trackDefinition : tracks.values()) {
                for (TrackModel model : trackDefinition.models) {
                    model.free();
                }
            }
        }
        try {
            DefinitionManager.initGauges();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load gauges, do you have a broken pack?", e);
        }
        Runtime runtime = Runtime.getRuntime();
        int n = runtime.availableProcessors();
        runtime.gc();
        long maxMemory = runtime.maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = runtime.totalMemory();
        }
        ImmersiveRailroading.info((String)"Detected %sMB of memory free", (Object[])new Object[]{maxMemory / 1024L / 1024L});
        try {
            OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            maxMemory = Math.min(os.getFreePhysicalMemorySize() + runtime.totalMemory(), maxMemory);
            ImmersiveRailroading.info((String)"Adjusted to %sMB of memory free", (Object[])new Object[]{maxMemory / 1024L / 1024L});
        }
        catch (Exception | UnsatisfiedLinkError ex) {
            ImmersiveRailroading.catching((Throwable)ex);
        }
        int loadingThreads = Math.max(1, Math.min(n, (int)(maxMemory / ((long)Config.ConfigPerformance.megabytesReservedPerStockLoadingThread * 1024L * 1024L))));
        ImmersiveRailroading.info((String)"Using %s threads to load Immersive Railroading (%sMB per thread)", (Object[])new Object[]{loadingThreads, Config.ConfigPerformance.megabytesReservedPerStockLoadingThread});
        ForkJoinPool stockLoadingPool = new ForkJoinPool(loadingThreads, pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName("ImmersiveRailroading-" + worker.getPoolIndex());
            return worker;
        }, null, false);
        try {
            ((ForkJoinTask)stockLoadingPool.submit(() -> {
                try {
                    DefinitionManager.initModels();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load rolling stock, do you have a broken pack?", e);
                }
            })).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            stockLoadingPool.shutdown();
        }
        try {
            DefinitionManager.initTracks();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load tracks, do you have a broken pack?", e);
        }
    }

    private static void initModels() throws IOException {
        ImmersiveRailroading.info((String)"Loading stock models.", (Object[])new Object[0]);
        Set<String> defTypes = stockLoaders.keySet();
        List<String> blacklist = DefinitionManager.getModelBlacklist(defTypes);
        LinkedHashMap<String, String> definitionIDMap = new LinkedHashMap<String, String>();
        HashMap<String, DataBlock.Value> definitionIDPacks = new HashMap<String, DataBlock.Value>();
        ArrayList<DataBlock> blocks = new ArrayList<DataBlock>();
        Identifier stock_json = new Identifier("immersiverailroading", "rolling_stock/stock.json");
        List inputs = stock_json.getResourceStreamAll();
        for (Iterator input : inputs) {
            blocks.add(JSON.parse((InputStream)((Object)input)));
        }
        Identifier stock_caml = new Identifier("immersiverailroading", "rolling_stock/stock.caml");
        inputs = stock_caml.getResourceStreamAll();
        for (InputStream input : inputs) {
            blocks.add(CAML.parse(input));
        }
        for (DataBlock stock : blocks) {
            for (String defType : defTypes) {
                List<DataBlock.Value> names = stock.getValues(defType);
                if (names == null) continue;
                for (String defName : names.stream().map(DataBlock.Value::asString).collect(Collectors.toList())) {
                    if (blacklist.contains(defName)) {
                        ImmersiveRailroading.info((String)"Skipping blacklisted %s", (Object[])new Object[]{defName});
                        continue;
                    }
                    String defID = String.format("rolling_stock/%s/%s.json", defType, defName);
                    if (definitionIDMap.containsKey(defID)) continue;
                    definitionIDMap.put(defID, defType);
                    DataBlock.Value pack = stock.getValue("pack");
                    if (pack.asString() == null) continue;
                    definitionIDPacks.put(defID, pack);
                }
            }
        }
        Progress.Bar bar = Progress.push((String)"Loading Models", (int)definitionIDMap.size());
        Map<String, EntityRollingStockDefinition> loaded = DefinitionManager.getStockLoadingStream(definitionIDMap.entrySet()).map(tuple -> {
            String defID = (String)tuple.getKey();
            String defType = (String)tuple.getValue();
            ImmersiveRailroading.debug((String)("Loading stock " + defID), (Object[])new Object[0]);
            Identifier resource = new Identifier("immersiverailroading", defID);
            try {
                if (!resource.canLoad()) {
                    resource = new Identifier(resource.getDomain(), resource.getPath().replace(".json", ".caml"));
                }
                if (!resource.canLoad()) {
                    ImmersiveRailroading.error((String)"Unable to load stock %s: file not found", (Object[])new Object[]{defID});
                    Pair pair = null;
                    return pair;
                }
                DataBlock block = DataBlock.load(resource);
                if (definitionIDPacks.containsKey(defID) && block.getValue("pack").asString() == null) {
                    block.getValueMap().put("pack", (DataBlock.Value)definitionIDPacks.get(defID));
                }
                EntityRollingStockDefinition stockDefinition = stockLoaders.get(defType).apply(defID, block);
                Runtime runtime = Runtime.getRuntime();
                if ((double)runtime.freeMemory() < (double)runtime.maxMemory() * 0.25) {
                    System.out.println("GC");
                    System.gc();
                }
                Pair pair = Pair.of((Object)stockDefinition.defID, (Object)stockDefinition);
                return pair;
            }
            catch (Exception e) {
                ImmersiveRailroading.error((String)"Error loading model %s of type %s", (Object[])new Object[]{defID, defType});
                ImmersiveRailroading.catching((Throwable)e);
                Pair pair = null;
                return pair;
            }
            finally {
                Progress.Bar bar2 = bar;
                synchronized (bar2) {
                    bar.step(defID);
                }
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        definitions = new LinkedHashMap<String, EntityRollingStockDefinition>();
        definitionIDMap.keySet().stream().filter(loaded::containsKey).forEach(x -> definitions.put((String)x, (EntityRollingStockDefinition)loaded.get(x)));
        Progress.pop((Progress.Bar)bar);
    }

    private static List<String> getModelBlacklist(Set<String> defTypes) throws IOException {
        ArrayList<String> blacklist = new ArrayList<String>();
        ArrayList<DataBlock> blocks = new ArrayList<DataBlock>();
        Identifier blacklist_json = new Identifier("immersiverailroading", "rolling_stock/blacklist.json");
        List inputs = blacklist_json.getResourceStreamAll();
        for (InputStream input : inputs) {
            blocks.add(JSON.parse(input));
        }
        Identifier blacklist_caml = new Identifier("immersiverailroading", "rolling_stock/blacklist.caml");
        inputs = blacklist_caml.getResourceStreamAll();
        for (InputStream input : inputs) {
            blocks.add(CAML.parse(input));
        }
        for (DataBlock block : blocks) {
            for (String defType : defTypes) {
                List<DataBlock.Value> found = block.getValues(defType);
                if (found == null) continue;
                blacklist.addAll(found.stream().map(DataBlock.Value::asString).collect(Collectors.toList()));
            }
        }
        return blacklist;
    }

    private static void initTracks() throws IOException {
        tracks = new LinkedHashMap<String, TrackDefinition>();
        ImmersiveRailroading.info((String)"Loading tracks.", (Object[])new Object[0]);
        ArrayList<DataBlock> blocks = new ArrayList<DataBlock>();
        Identifier track_json = new Identifier("immersiverailroading", "track/track.json");
        List inputs = track_json.getResourceStreamAll();
        for (InputStream input : inputs) {
            blocks.add(JSON.parse(input));
        }
        Identifier track_caml = new Identifier("immersiverailroading", "track/track.caml");
        inputs = track_caml.getResourceStreamAll();
        for (InputStream input : inputs) {
            blocks.add(CAML.parse(input));
        }
        for (DataBlock track : blocks) {
            List types = track.getValues("types").stream().map(DataBlock.Value::asString).collect(Collectors.toList());
            Progress.Bar bar = Progress.push((String)"Loading Tracks", (int)types.size());
            for (String def : types) {
                bar.step(def);
                String trackID = String.format("immersiverailroading:track/%s.json", def);
                ImmersiveRailroading.debug((String)"Loading Track %s", (Object[])new Object[]{trackID});
                Identifier identifier = new Identifier(trackID);
                if (!identifier.canLoad()) {
                    identifier = new Identifier(identifier.getDomain(), identifier.getPath().replace(".json", ".caml"));
                }
                if (!identifier.canLoad()) {
                    ImmersiveRailroading.error((String)"Unable to load track '%s': file not found", (Object[])new Object[]{trackID});
                    continue;
                }
                DataBlock block = DataBlock.load(identifier);
                if (track.getValue("pack").asString() != null && block.getValue("pack").asString() != null) {
                    block.getValueMap().put("pack", track.getValue("pack"));
                }
                try {
                    tracks.put(trackID, new TrackDefinition(trackID, block));
                }
                catch (Exception e) {
                    ImmersiveRailroading.catching((Throwable)e);
                }
            }
            Progress.pop((Progress.Bar)bar);
        }
    }

    private static <E> Stream<E> getStockLoadingStream(Collection<E> collection) {
        if (!Config.ConfigPerformance.multithreadedStockLoading) {
            return collection.stream();
        }
        return collection.parallelStream();
    }

    public static EntityRollingStockDefinition getDefinition(String defID) {
        return definitions.get(defID);
    }

    public static Collection<EntityRollingStockDefinition> getDefinitions() {
        return definitions.values();
    }

    public static Set<String> getDefinitionNames() {
        return definitions.keySet();
    }

    public static List<TrackDefinition> getTracks() {
        return new ArrayList<TrackDefinition>(tracks.values());
    }

    public static List<String> getTrackIDs() {
        return new ArrayList<String>(tracks.keySet());
    }

    public static TrackModel getTrack(String track, double value) {
        return DefinitionManager.getTrack(track).getTrackForGauge(value);
    }

    public static TrackDefinition getTrack(String track) {
        TrackDefinition def = tracks.get(track);
        if (def == null) {
            def = tracks.values().stream().findFirst().get();
        }
        return def;
    }

    static {
        stockLoaders = new LinkedHashMap<String, StockLoader>();
        stockLoaders.put("locomotives", (defID, data) -> {
            String era;
            switch (era = data.getValue("era").asString()) {
                case "steam": {
                    return new LocomotiveSteamDefinition(defID, data);
                }
                case "diesel": {
                    return new LocomotiveDieselDefinition(defID, data);
                }
            }
            ImmersiveRailroading.warn((String)"Invalid era %s in %s", (Object[])new Object[]{era, defID});
            return null;
        });
        stockLoaders.put("tender", TenderDefinition::new);
        stockLoaders.put("passenger", CarPassengerDefinition::new);
        stockLoaders.put("freight", CarFreightDefinition::new);
        stockLoaders.put("tank", CarTankDefinition::new);
        stockLoaders.put("hand_car", HandCarDefinition::new);
    }

    @FunctionalInterface
    private static interface StockLoader {
        public EntityRollingStockDefinition apply(String var1, DataBlock var2) throws Exception;
    }
}

