/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.Control;
import cam72cam.immersiverailroading.util.DataBlock;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.boundingbox.IBoundingBox;
import cam72cam.mod.math.Vec3d;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import util.Matrix4;

public class Door<T extends EntityMoveableRollingStock>
extends Control<T> {
    private static final Map<UUID, Integer> cooldown = new HashMap<UUID, Integer>();
    public final Types type;

    public static <T extends EntityMoveableRollingStock> List<Door<T>> get(ComponentProvider provider, ModelState state) {
        return provider.parseAll(ModelComponentType.DOOR_X).stream().map(p -> new Door((ModelComponent)p, state, provider.internal_model_scale, provider.widgetConfig)).collect(Collectors.toList());
    }

    public static <T extends EntityMoveableRollingStock> List<Door<T>> get(ComponentProvider provider, ModelState state, ModelComponentType.ModelPosition pos) {
        return provider.parseAll(ModelComponentType.DOOR_X, pos).stream().map(p -> new Door((ModelComponent)p, state, provider.internal_model_scale, provider.widgetConfig)).collect(Collectors.toList());
    }

    public Door(ModelComponent part, ModelState state, double internal_model_scale, Map<String, DataBlock> widgetConfig) {
        super(part, state, internal_model_scale, widgetConfig);
        this.type = part.modelIDs.stream().anyMatch(g -> g.contains("EXTERNAL")) ? Types.EXTERNAL : (part.modelIDs.stream().anyMatch(g -> g.contains("CONNECTING")) ? Types.CONNECTING : Types.INTERNAL);
    }

    public boolean isOpen(EntityRollingStock stock) {
        return (double)stock.getControlPosition(this) > 0.75;
    }

    public boolean isAtOpenDoor(Player player, EntityRollingStock stock, Types type) {
        IBoundingBox bb;
        if (this.type != type) {
            return false;
        }
        int cool = cooldown.getOrDefault(player.getUUID(), 0);
        if (player.getTickCount() < cool + 10 && player.getTickCount() > cool) {
            return false;
        }
        if (!this.isOpen(stock) || player.getPosition().distanceTo(stock.getPosition()) > stock.getDefinition().getLength(stock.gauge)) {
            return false;
        }
        Matrix4 model = stock.getModelMatrix();
        Matrix4 delta = this.state.getMatrix((EntityMoveableRollingStock)stock, 0.0f);
        if (delta != null) {
            model = model.multiply(delta);
        }
        if (!(bb = IBoundingBox.from((Vec3d)model.apply(this.part.min), (Vec3d)model.apply(this.part.max)).grow(new Vec3d(0.5, 0.5, 0.5))).contains(player.getPositionEyes().add(stock.getVelocity()))) {
            return false;
        }
        cooldown.put(player.getUUID(), player.getTickCount());
        return true;
    }

    public static enum Types {
        INTERNAL,
        CONNECTING,
        EXTERNAL;

    }
}

