/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import java.util.Comparator;
import java.util.List;

public class CargoFill {
    public static CargoFill get(ComponentProvider provider, ModelState state, boolean showCurrentLoadOnly, ModelComponentType.ModelPosition pos) {
        List<ModelComponent> cargoLoads = pos == null ? provider.parseAll(ModelComponentType.CARGO_FILL_X) : provider.parseAll(ModelComponentType.CARGO_FILL_POS_X, pos);
        cargoLoads.sort(Comparator.comparingInt(a -> -a.id.intValue()));
        return cargoLoads.isEmpty() ? null : new CargoFill(cargoLoads, state, showCurrentLoadOnly);
    }

    public CargoFill(List<ModelComponent> cargoLoads, ModelState state, boolean showCurrentLoadOnly) {
        state.push(settings -> settings.add((stock, group) -> {
            int percentFull = stock instanceof Freight ? ((Freight)stock).getPercentCargoFull() : 100;
            for (ModelComponent cargoLoad : cargoLoads) {
                if (cargoLoad.id > percentFull) continue;
                if (cargoLoad.modelIDs.contains(group)) {
                    return true;
                }
                if (!showCurrentLoadOnly) continue;
                break;
            }
            return false;
        })).include(cargoLoads);
    }
}

