/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.mod.model.obj.OBJModel;
import cam72cam.mod.resource.Identifier;
import java.util.ArrayList;

public class TrackModel
extends OBJModel {
    private final String compare;
    private final double size;
    private final double height;
    public final double spacing;

    public TrackModel(String condition, Identifier resource, double model_gauge_m, double spacing) throws Exception {
        super(resource, 0.0f, 1.435 / model_gauge_m);
        this.compare = condition.substring(0, 1);
        this.size = Double.parseDouble(condition.substring(1));
        ArrayList<String> groups = new ArrayList<String>();
        for (String group : this.groups()) {
            if (!group.contains("RAIL_LEFT") && !group.contains("RAIL_RIGHT")) continue;
            groups.add(group);
        }
        this.height = this.maxOfGroup(groups).y;
        this.spacing = spacing * (1.435 / model_gauge_m);
    }

    public boolean canRender(double gauge) {
        switch (this.compare) {
            case ">": {
                return gauge > this.size;
            }
            case "<": {
                return gauge < this.size;
            }
            case "=": {
                return gauge == this.size;
            }
        }
        return true;
    }

    public double getHeight() {
        return this.height;
    }
}

