/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.library;

import cam72cam.immersiverailroading.util.DataBlock;
import cam72cam.mod.resource.Identifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ValveGearConfig {
    public final ValveGearType type;
    public final Map<Float, Identifier> custom;

    public ValveGearConfig(ValveGearType type, Map<Float, Identifier> custom) {
        this.type = type;
        this.custom = custom;
    }

    public static ValveGearConfig get(DataBlock def, String key) {
        DataBlock block = def.getBlock(key);
        if (block != null) {
            DataBlock animatrix = block.getBlock("animatrix");
            HashMap<Float, Identifier> custom = new HashMap<Float, Identifier>();
            animatrix.getValueMap().forEach((percent, anim) -> custom.put(Float.valueOf(Float.parseFloat(percent)), anim.asIdentifier()));
            return new ValveGearConfig(ValveGearType.CUSTOM, custom);
        }
        String name = def.getValue(key).asString();
        if (name != null) {
            return new ValveGearConfig(ValveGearType.from(name.toUpperCase(Locale.ROOT)), null);
        }
        return null;
    }

    public static enum ValveGearType {
        CONNECTING,
        STEPHENSON,
        WALSCHAERTS,
        HIDDEN,
        SHAY,
        CLIMAX,
        CUSTOM;


        public static ValveGearType from(String valveGear) {
            if (valveGear == null) {
                return null;
            }
            switch (valveGear) {
                case "TRI_WALSCHAERTS": 
                case "GARRAT": 
                case "MALLET_WALSCHAERTS": {
                    return WALSCHAERTS;
                }
                case "T1": {
                    return STEPHENSON;
                }
            }
            return ValveGearType.valueOf(valveGear);
        }
    }
}

