/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.library;

public enum PhysicalMaterials {
    STEEL,
    CAST_IRON,
    WOOD;


    private boolean match(PhysicalMaterials materialA, PhysicalMaterials materialB, PhysicalMaterials matchA, PhysicalMaterials matchB) {
        return materialA == matchA && materialB == matchB || materialA == matchB && materialB == matchA;
    }

    private float friction(PhysicalMaterials other, boolean kinetic) {
        if (this.match(STEEL, STEEL, this, other)) {
            return kinetic ? 0.42f : 0.7f;
        }
        if (this.match(STEEL, CAST_IRON, this, other)) {
            return kinetic ? 0.25f : 0.4f;
        }
        if (this.match(STEEL, WOOD, this, other)) {
            return kinetic ? 0.2f : 0.6f;
        }
        return 0.0f;
    }

    public float staticFriction(PhysicalMaterials other) {
        return this.friction(other, false);
    }

    public float kineticFriction(PhysicalMaterials other) {
        return this.friction(other, true);
    }
}

