/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.library.PlateType;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.mod.item.CreativeTab;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.text.TextColor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ItemPlate
extends CustomItem {
    public ItemPlate() {
        super("immersiverailroading", "item_plate");
    }

    public int getStackSize() {
        return 64;
    }

    public List<CreativeTab> getCreativeTabs() {
        return Collections.singletonList(ItemTabs.MAIN_TAB);
    }

    public List<ItemStack> getItemVariants(CreativeTab tab) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tab == null || tab.equals((Object)ItemTabs.MAIN_TAB)) {
            for (PlateType plate : PlateType.values()) {
                ItemStack stack = new ItemStack((CustomItem)this, 1);
                if (plate != PlateType.BOILER) {
                    Data data = new Data(stack);
                    data.type = plate;
                    data.gauge = Gauge.from(1.435);
                    data.write();
                    items.add(stack);
                    continue;
                }
                for (EntityRollingStockDefinition def : DefinitionManager.getDefinitions()) {
                    if (!def.getItemComponents().contains((Object)ItemComponentType.BOILER_SEGMENT)) continue;
                    stack = stack.copy();
                    Data data = new Data(stack);
                    data.type = plate;
                    data.gauge = Gauge.from(1.435);
                    data.def = def;
                    data.write();
                    items.add(stack);
                }
            }
        }
        return items;
    }

    public String getCustomName(ItemStack stack) {
        Data data = new Data(stack);
        if (data.type == PlateType.BOILER) {
            if (data.def != null) {
                return TextColor.RESET.wrap(data.type.toString() + " " + data.def.name());
            }
        } else {
            return TextColor.RESET.wrap(data.type.toString());
        }
        return null;
    }

    public List<String> getTooltip(ItemStack stack) {
        return Collections.singletonList(GuiText.GAUGE_TOOLTIP.toString(new Data((ItemStack)stack).gauge));
    }

    public static class Data
    extends CustomItem.ItemDataSerializer {
        @TagField(value="plate")
        public PlateType type;
        @TagField(value="defID")
        public EntityRollingStockDefinition def;
        @TagField(value="gauge")
        public Gauge gauge;

        public Data(ItemStack stack) {
            super(stack);
            if (this.gauge == null) {
                Gauge gauge = this.gauge = this.def != null ? this.def.recommended_gauge : Gauge.from(1.435);
            }
            if (this.type == null) {
                this.type = PlateType.SMALL;
            }
        }
    }
}

