/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui.overlay;

import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.model.LocomotiveModel;
import cam72cam.immersiverailroading.model.StockModel;

public enum Readouts {
    LIQUID,
    SPEED,
    TEMPERATURE,
    BOILER_PRESSURE,
    THROTTLE,
    REVERSER,
    TRAIN_BRAKE,
    TRAIN_BRAKE_LEVER,
    INDEPENDENT_BRAKE,
    BRAKE_PRESSURE,
    COUPLER_FRONT,
    COUPLER_REAR,
    COUPLED_FRONT,
    COUPLED_REAR,
    COUPLER_SLACK_FRONT,
    COUPLER_SLACK_REAR,
    BELL,
    WHISTLE,
    HORN,
    ENGINE,
    FRONT_BOGEY_ANGLE,
    REAR_BOGEY_ANGLE,
    FRONT_LOCOMOTIVE_ANGLE,
    REAR_LOCOMOTIVE_ANGLE,
    CYLINDER_DRAIN,
    CARGO_FILL,
    ENGINE_RPM;


    public float getValue(EntityRollingStock stock) {
        return this.getValue(stock, 0.0f);
    }

    public float getValue(EntityRollingStock stock, float lever) {
        switch (this) {
            case LIQUID: {
                return stock instanceof FreightTank ? (float)((FreightTank)stock).getPercentLiquidFull() / 100.0f : 0.0f;
            }
            case SPEED: {
                double maxSpeed;
                double d = maxSpeed = stock instanceof Locomotive ? ((Locomotive)stock).getDefinition().getMaxSpeed(stock.gauge).metric() : 0.0;
                if (maxSpeed == 0.0) {
                    maxSpeed = 200.0;
                }
                return (float)Math.abs(((EntityMoveableRollingStock)stock).getCurrentSpeed().metric() / maxSpeed);
            }
            case TEMPERATURE: {
                if (stock instanceof LocomotiveSteam) {
                    return ((LocomotiveSteam)stock).getBoilerTemperature() / 100.0f;
                }
                if (stock instanceof LocomotiveDiesel) {
                    return ((LocomotiveDiesel)stock).getEngineTemperature() / 150.0f;
                }
                return 0.0f;
            }
            case BOILER_PRESSURE: {
                return stock instanceof LocomotiveSteam ? ((LocomotiveSteam)stock).getBoilerPressure() / (float)((LocomotiveSteam)stock).getDefinition().getMaxPSI(stock.gauge) : 0.0f;
            }
            case THROTTLE: {
                return stock instanceof Locomotive ? ((Locomotive)stock).getThrottle() : 0.0f;
            }
            case REVERSER: {
                return stock instanceof Locomotive ? (((Locomotive)stock).getReverser() + 1.0f) / 2.0f : 0.0f;
            }
            case TRAIN_BRAKE: {
                return stock instanceof Locomotive ? ((Locomotive)stock).getTrainBrake() : 0.0f;
            }
            case TRAIN_BRAKE_LEVER: {
                return stock.getDefinition().isLinearBrakeControl() ? TRAIN_BRAKE.getValue(stock) : lever;
            }
            case INDEPENDENT_BRAKE: {
                return stock instanceof EntityMoveableRollingStock ? ((EntityMoveableRollingStock)stock).getIndependentBrake() : 0.0f;
            }
            case BRAKE_PRESSURE: {
                return stock instanceof EntityMoveableRollingStock ? ((EntityMoveableRollingStock)stock).getBrakePressure() : 0.0f;
            }
            case COUPLER_FRONT: {
                return stock instanceof EntityCoupleableRollingStock ? (((EntityCoupleableRollingStock)stock).isCouplerEngaged(EntityCoupleableRollingStock.CouplerType.FRONT) ? 1.0f : 0.0f) : 0.0f;
            }
            case COUPLER_REAR: {
                return stock instanceof EntityCoupleableRollingStock ? (((EntityCoupleableRollingStock)stock).isCouplerEngaged(EntityCoupleableRollingStock.CouplerType.BACK) ? 1.0f : 0.0f) : 0.0f;
            }
            case COUPLED_FRONT: {
                return stock instanceof EntityCoupleableRollingStock ? (((EntityCoupleableRollingStock)stock).isCoupled(EntityCoupleableRollingStock.CouplerType.FRONT) && ((EntityCoupleableRollingStock)stock).isCouplerEngaged(EntityCoupleableRollingStock.CouplerType.FRONT) ? 1.0f : 0.0f) : 0.0f;
            }
            case COUPLED_REAR: {
                return stock instanceof EntityCoupleableRollingStock ? (((EntityCoupleableRollingStock)stock).isCoupled(EntityCoupleableRollingStock.CouplerType.BACK) && ((EntityCoupleableRollingStock)stock).isCouplerEngaged(EntityCoupleableRollingStock.CouplerType.BACK) ? 1.0f : 0.0f) : 0.0f;
            }
            case COUPLER_SLACK_FRONT: {
                return stock instanceof EntityCoupleableRollingStock ? ((EntityCoupleableRollingStock)stock).slackFrontPercent : 0.0f;
            }
            case COUPLER_SLACK_REAR: {
                return stock instanceof EntityCoupleableRollingStock ? ((EntityCoupleableRollingStock)stock).slackRearPercent : 0.0f;
            }
            case BELL: {
                return stock instanceof Locomotive ? (((Locomotive)stock).getBell() > 0 ? 1.0f : 0.0f) : 0.0f;
            }
            case WHISTLE: 
            case HORN: {
                return stock instanceof Locomotive ? ((Locomotive)stock).hornPull : 0.0f;
            }
            case ENGINE: {
                return stock instanceof LocomotiveDiesel ? (((LocomotiveDiesel)stock).isTurnedOn() ? 1.0f : 0.0f) : 0.0f;
            }
            case FRONT_BOGEY_ANGLE: {
                return this.yawToPercent(stock.getDefinition().getModel().getFrontYaw((EntityMoveableRollingStock)stock), 90.0f);
            }
            case REAR_BOGEY_ANGLE: {
                return this.yawToPercent(stock.getDefinition().getModel().getRearYaw((EntityMoveableRollingStock)stock), 90.0f);
            }
            case FRONT_LOCOMOTIVE_ANGLE: {
                StockModel<?, ?> front = stock.getDefinition().getModel();
                return front instanceof LocomotiveModel ? this.yawToPercent(((LocomotiveModel)front).getFrontLocomotiveYaw((EntityMoveableRollingStock)stock), 90.0f) : 0.5f;
            }
            case REAR_LOCOMOTIVE_ANGLE: {
                StockModel<?, ?> rear = stock.getDefinition().getModel();
                return rear instanceof LocomotiveModel ? this.yawToPercent(((LocomotiveModel)rear).getRearLocomotiveYaw((EntityMoveableRollingStock)stock), 90.0f) : 0.5f;
            }
            case CYLINDER_DRAIN: {
                return stock instanceof LocomotiveSteam && ((LocomotiveSteam)stock).cylinderDrainsEnabled() ? 1.0f : 0.0f;
            }
            case CARGO_FILL: {
                return stock instanceof Freight ? (float)((Freight)stock).getPercentCargoFull() / 100.0f : 0.0f;
            }
            case ENGINE_RPM: {
                return stock instanceof LocomotiveDiesel ? ((LocomotiveDiesel)stock).getRelativeRPM() : 0.0f;
            }
        }
        return 0.0f;
    }

    private float yawToPercent(float yaw, float deltaYaw) {
        if ((yaw = (yaw % 360.0f + 360.0f) % 360.0f) > 180.0f) {
            yaw -= 360.0f;
        }
        return 0.5f + yaw / deltaYaw;
    }

    public void setValue(EntityRollingStock stock, float value) {
        switch (this) {
            case THROTTLE: {
                if (!(stock instanceof Locomotive)) break;
                ((Locomotive)stock).setThrottle(value);
                break;
            }
            case REVERSER: {
                if (!(stock instanceof Locomotive)) break;
                ((Locomotive)stock).setReverser(value * 2.0f - 1.0f);
                break;
            }
            case TRAIN_BRAKE: {
                if (!(stock instanceof Locomotive)) break;
                ((Locomotive)stock).setTrainBrake(value);
                break;
            }
            case TRAIN_BRAKE_LEVER: {
                if (stock.getDefinition().isLinearBrakeControl()) {
                    TRAIN_BRAKE.setValue(stock, value);
                    break;
                }
                if (!(stock instanceof Locomotive)) break;
                ((Locomotive)stock).setTrainBrake(Math.max(0.0f, Math.min(1.0f, ((Locomotive)stock).getTrainBrake() + (value - 0.5f) / 80.0f)));
                break;
            }
            case INDEPENDENT_BRAKE: {
                if (!(stock instanceof EntityMoveableRollingStock)) break;
                ((EntityMoveableRollingStock)stock).setIndependentBrake(value);
                break;
            }
            case COUPLER_FRONT: {
                if (!(stock instanceof EntityCoupleableRollingStock)) break;
                ((EntityCoupleableRollingStock)stock).setCouplerEngaged(EntityCoupleableRollingStock.CouplerType.FRONT, value == 0.0f);
                break;
            }
            case COUPLER_REAR: {
                if (!(stock instanceof EntityCoupleableRollingStock)) break;
                ((EntityCoupleableRollingStock)stock).setCouplerEngaged(EntityCoupleableRollingStock.CouplerType.BACK, value == 0.0f);
                break;
            }
            case BELL: {
                if (!(stock instanceof Locomotive)) break;
                ((Locomotive)stock).setBell((int)(value * 10.0f));
                break;
            }
            case WHISTLE: 
            case HORN: {
                if (!(stock instanceof Locomotive)) break;
                if (value != 0.0f) {
                    ((Locomotive)stock).setHorn(10000, value);
                    break;
                }
                ((Locomotive)stock).setHorn(10, value);
                break;
            }
            case ENGINE: {
                if (!(stock instanceof LocomotiveDiesel)) break;
                ((LocomotiveDiesel)stock).setTurnedOn(!((LocomotiveDiesel)stock).isTurnedOn());
                break;
            }
            case CYLINDER_DRAIN: {
                if (!(stock instanceof LocomotiveSteam)) break;
                ((LocomotiveSteam)stock).setCylinderDrains((double)value > 0.9);
            }
        }
    }
}

