/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui.overlay;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.gui.overlay.Readouts;
import cam72cam.immersiverailroading.gui.overlay.Stat;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.util.DataBlock;
import cam72cam.immersiverailroading.util.MergedBlocks;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.config.ConfigFile;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.event.ClientEvents;
import cam72cam.mod.gui.helpers.GUIHelpers;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.net.Packet;
import cam72cam.mod.render.opengl.BlendMode;
import cam72cam.mod.render.opengl.DirectDraw;
import cam72cam.mod.render.opengl.RenderState;
import cam72cam.mod.render.opengl.Texture;
import cam72cam.mod.resource.Identifier;
import cam72cam.mod.serialization.TagField;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import util.Matrix4;

public class GuiBuilder {
    private final float x;
    private final float y;
    private final Horizontal screen_x;
    private final Vertical screen_y;
    private final Identifier image;
    private final int width;
    private final int height;
    private final String text;
    private final float textHeight;
    private final Readouts readout;
    private final String control;
    private final String setting;
    private final String texture_variant;
    private final Float setting_default;
    private final boolean global;
    private final boolean invert;
    private final boolean translucent;
    private final boolean toggle;
    private final ClampMode clamp;
    private final float tlx;
    private final float tly;
    private final float rotx;
    private final float roty;
    private final float rotdeg;
    private final float rotoff;
    private final Float scalex;
    private final Float scaley;
    private final Map<Float, Integer> colors = new HashMap<Float, Integer>();
    private final EntityRollingStockDefinition.ControlSoundsDefinition sound;
    private final List<GuiBuilder> elements;
    private float temporary_value = 0.5f;
    private static GuiBuilder scrollTarget = null;
    private static int lastScrolled = 0;
    private static GuiBuilder target = null;

    private static DataBlock processImports(DataBlock data) throws IOException {
        List<DataBlock> imports;
        List<DataBlock.Value> direct = data.getValues("import");
        if (direct != null) {
            for (DataBlock.Value imp : direct) {
                data = new MergedBlocks(data, GuiBuilder.processImports(DataBlock.load(imp.asIdentifier())));
            }
        }
        if ((imports = data.getBlocks("import")) != null) {
            for (DataBlock imp : imports) {
                data = new MergedBlocks(data, GuiBuilder.processImports(DataBlock.load(imp.getValue("source").asIdentifier(), imp.getBlock("replace"))));
            }
        }
        return data;
    }

    protected GuiBuilder(DataBlock data) throws IOException {
        data = GuiBuilder.processImports(data);
        this.x = data.getValue("x").asFloat(0.0f);
        this.y = data.getValue("y").asFloat(0.0f);
        this.screen_x = Horizontal.from(data.getValue("screen_x").asString());
        this.screen_y = Vertical.from(data.getValue("screen_y").asString());
        DataBlock txt = data.getBlock("text");
        if (txt != null) {
            this.text = txt.getValue("value").asString();
            this.textHeight = txt.getValue("height").asFloat(0.0f);
        } else {
            this.text = null;
            this.textHeight = 0.0f;
        }
        this.image = data.getValue("image").asIdentifier(null);
        if (this.image != null) {
            BufferedImage tmp = ImageIO.read(this.image.getResourceStream());
            this.width = tmp.getWidth();
            this.height = tmp.getHeight();
        } else if (this.text != null) {
            this.width = (int)(this.textHeight / 4.0f * (float)this.text.length());
            this.height = (int)this.textHeight;
        } else {
            this.width = 0;
            this.height = 0;
        }
        String readout = data.getValue("readout").asString();
        this.readout = readout != null ? Readouts.valueOf(readout.toUpperCase(Locale.ROOT)) : null;
        this.control = data.getValue("control").asString();
        this.setting = data.getValue("setting").asString();
        this.setting_default = data.getValue("setting_default").asFloat();
        this.texture_variant = data.getValue("texture_variant").asString();
        DataBlock soundBlock = data.getBlock("sound");
        this.sound = soundBlock != null ? new EntityRollingStockDefinition.ControlSoundsDefinition(soundBlock) : null;
        this.global = data.getValue("global").asBoolean(false);
        this.invert = data.getValue("invert").asBoolean(false);
        this.translucent = data.getValue("translucent").asBoolean(data.getValue("hide").asBoolean(false));
        this.toggle = data.getValue("toggle").asBoolean(false);
        this.clamp = ClampMode.from(data.getValue("clamp").asString());
        DataBlock tl = data.getBlock("translate");
        if (tl != null) {
            this.tlx = tl.getValue("x").asFloat(0.0f);
            this.tly = tl.getValue("y").asFloat(0.0f);
        } else {
            this.tly = 0.0f;
            this.tlx = 0.0f;
        }
        DataBlock rot = data.getBlock("rotate");
        if (rot != null) {
            this.rotx = rot.getValue("x").asFloat(0.0f);
            this.roty = rot.getValue("y").asFloat(0.0f);
            this.rotdeg = rot.getValue("degrees").asFloat(360.0f);
            this.rotoff = rot.getValue("offset").asFloat(0.0f);
        } else {
            this.rotx = 0.0f;
            this.roty = 0.0f;
            this.rotdeg = 0.0f;
            this.rotoff = 0.0f;
        }
        DataBlock scale = data.getBlock("scale");
        if (scale != null) {
            this.scalex = scale.getValue("x").asFloat();
            this.scaley = scale.getValue("y").asFloat();
        } else {
            this.scalex = null;
            this.scaley = null;
        }
        DataBlock color = data.getBlock("color");
        if (color != null) {
            color.getValueMap().forEach((key, value) -> {
                String hex = value.asString();
                if (hex.length() == 8) {
                    hex = hex.replace("0x", "0xFF");
                    hex = hex.replace("0X", "0XFF");
                }
                this.colors.put(Float.valueOf(Float.parseFloat(key)), (int)Long.decode(hex).longValue());
            });
        }
        this.elements = new ArrayList<GuiBuilder>();
        List<DataBlock> elem = data.getBlocks("elements");
        if (elem == null) {
            elem = data.getBlocks("element");
        }
        if (elem != null) {
            for (DataBlock element : elem) {
                this.elements.add(new GuiBuilder(element));
            }
        }
    }

    public static GuiBuilder parse(Identifier overlay) throws IOException {
        return new GuiBuilder(DataBlock.load(overlay));
    }

    private void applyPosition(Matrix4 matrix, int maxx, int maxy) {
        matrix.translate((double)this.x, (double)this.y, 0.0);
        switch (this.screen_x) {
            case LEFT: {
                break;
            }
            case MIDDLE: {
                matrix.translate((double)((float)maxx / 2.0f), 0.0, 0.0);
                break;
            }
            case RIGHT: {
                matrix.translate((double)maxx, 0.0, 0.0);
            }
        }
        switch (this.screen_y) {
            case TOP: {
                break;
            }
            case MIDDLE: {
                matrix.translate(0.0, (double)((float)maxy / 2.0f), 0.0);
                break;
            }
            case BOTTOM: {
                matrix.translate(0.0, (double)maxy, 0.0);
            }
        }
    }

    private float getValue(EntityRollingStock stock) {
        float value = 0.0f;
        if (this.readout != null) {
            value = this.readout.getValue(stock, this.temporary_value);
        } else if (this.control != null) {
            value = stock.getControlPosition(this.control);
        } else if (this.setting != null) {
            if (!ConfigGraphics.settings.containsKey(this.setting) && this.setting_default != null) {
                ConfigGraphics.settings.put(this.setting, this.setting_default);
            }
            value = ConfigGraphics.settings.getOrDefault(this.setting, Float.valueOf(0.0f)).floatValue();
        } else if (this.texture_variant != null) {
            value = this.texture_variant.equals(stock.getTexture()) ? 1.0f : 0.0f;
        }
        switch (this.clamp) {
            case FLOOR: {
                value = (double)value < 0.95 ? 0.0f : 1.0f;
            }
            case CEIL: {
                float f = value = (double)value < 0.05 ? 0.0f : 1.0f;
            }
        }
        if (this.invert) {
            value = 1.0f - value;
        }
        return value;
    }

    private void applyValue(Matrix4 matrix, float value) {
        if (this.tlx != 0.0f || this.tly != 0.0f) {
            matrix.translate((double)(this.tlx * value), (double)(this.tly * value), 0.0);
        }
        if (this.rotdeg != 0.0f) {
            matrix.translate((double)this.rotx, (double)this.roty, 0.0);
            matrix.rotate(Math.toRadians(this.rotdeg * value + this.rotoff), 0.0, 0.0, 1.0);
            matrix.translate((double)(-this.rotx), (double)(-this.roty), 0.0);
        }
        if (this.scalex != null || this.scaley != null) {
            matrix.scale(this.scalex != null ? (double)(this.scalex.floatValue() * value) : 1.0, this.scaley != null ? (double)(this.scaley.floatValue() * value) : 1.0, 1.0);
        }
    }

    public void render(RenderState state, EntityRollingStock stock) {
        this.render(stock, state.clone().color(1.0f, 1.0f, 1.0f, 1.0f), GUIHelpers.getScreenWidth(), GUIHelpers.getScreenHeight(), -1);
    }

    private void render(EntityRollingStock stock, RenderState state, int maxx, int maxy, int baseColor) {
        float value = this.getValue(stock);
        if (this.translucent) {
            if (value == 0.0f) {
                return;
            }
            float alpha = (float)(baseColor >> 24 & 0xFF) / 255.0f * value;
            baseColor = baseColor & 0xFFFFFF | (int)(alpha * 255.0f) << 24;
        }
        state = state.clone();
        this.applyPosition(state.model_view(), maxx, maxy);
        this.applyValue(state.model_view(), value);
        Float colorKey = null;
        Iterator<Object> iterator = this.colors.keySet().iterator();
        while (iterator.hasNext()) {
            float key = iterator.next().floatValue();
            if (!(key <= value) || colorKey != null && !(key > colorKey.floatValue())) continue;
            colorKey = Float.valueOf(key);
        }
        if (colorKey != null && this.colors.containsKey(colorKey)) {
            float oldAlpha = (float)(baseColor >> 24 & 0xFF) / 255.0f;
            int newColor = this.colors.get(colorKey);
            float newAlpha = (float)(newColor >> 24 & 0xFF) / 255.0f;
            baseColor = newColor & 0xFFFFFF | (int)(newAlpha * oldAlpha * 255.0f) << 24;
        }
        if (colorKey != null || this.translucent) {
            state.color((float)(baseColor >> 16 & 0xFF) / 255.0f, (float)(baseColor >> 8 & 0xFF) / 255.0f, (float)(baseColor & 0xFF) / 255.0f, (float)(baseColor >> 24 & 0xFF) / 255.0f);
        }
        if (this.image != null) {
            DirectDraw draw = new DirectDraw();
            draw.vertex(0.0, 0.0, 0.0).uv(0.0, 0.0);
            draw.vertex(0.0, (double)this.height, 0.0).uv(0.0, 1.0);
            draw.vertex((double)this.width, (double)this.height, 0.0).uv(1.0, 1.0);
            draw.vertex((double)this.width, 0.0, 0.0).uv(1.0, 0.0);
            draw.draw(state.clone().texture(Texture.wrap((Identifier)this.image)).alpha_test(false).blend(new BlendMode(770, 771)));
        }
        if (this.text != null) {
            String out = this.text;
            for (Stat stat : Stat.values()) {
                if (!out.contains(stat.toString())) continue;
                out = out.replace(stat.toString(), stat.getValue(stock));
            }
            for (Enum enum_ : new GuiText[]{GuiText.LABEL_THROTTLE, GuiText.LABEL_REVERSER, GuiText.LABEL_BRAKE}) {
                out = out.replace(((GuiText)enum_).getValue(), ((GuiText)enum_).toString());
            }
            float scale = this.textHeight / 8.0f;
            Matrix4 mat = state.model_view().copy();
            mat.scale((double)scale, (double)scale, (double)scale);
            GUIHelpers.drawCenteredString((String)out, (int)0, (int)0, (int)baseColor, (Matrix4)mat);
        }
        for (GuiBuilder element : this.elements) {
            element.render(stock, state, maxx, maxy, baseColor);
        }
    }

    private GuiBuilder find(EntityRollingStock stock, Matrix4 matrix, int maxx, int maxy, int x, int y) {
        float value = this.getValue(stock);
        if (this.translucent && value == 0.0f) {
            return null;
        }
        matrix = matrix.copy();
        this.applyPosition(matrix, maxx, maxy);
        this.applyValue(matrix, value);
        for (GuiBuilder element : this.elements) {
            GuiBuilder found = element.find(stock, matrix, maxx, maxy, x, y);
            if (found == null) continue;
            return found;
        }
        if (this.interactable() && (this.image != null || this.text != null)) {
            if (this.control == null && this.setting == null && this.texture_variant == null) {
                if (this.readout == null) {
                    return null;
                }
                switch (this.readout) {
                    case THROTTLE: 
                    case REVERSER: 
                    case TRAIN_BRAKE: 
                    case TRAIN_BRAKE_LEVER: 
                    case INDEPENDENT_BRAKE: 
                    case COUPLER_FRONT: 
                    case COUPLER_REAR: 
                    case BELL: 
                    case WHISTLE: 
                    case HORN: 
                    case ENGINE: {
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            int border = 2;
            Vec3d cornerA = matrix.apply(new Vec3d((double)((this.image == null ? -this.width : 0) - border), (double)(-border), 0.0));
            Vec3d cornerB = matrix.apply(new Vec3d((double)((this.image == null ? -this.width : 0) - border), (double)(this.height + border), 0.0));
            Vec3d cornerC = matrix.apply(new Vec3d((double)(this.width + border), (double)(-border), 0.0));
            Vec3d cornerD = matrix.apply(new Vec3d((double)(this.width + border), (double)(this.height + border), 0.0));
            Polygon poly = new Polygon(new int[]{(int)cornerA.x, (int)cornerB.x, (int)cornerC.x, (int)cornerD.x}, new int[]{(int)cornerA.y, (int)cornerB.y, (int)cornerC.y, (int)cornerD.y}, 4);
            if (poly.getBounds2D().contains(x, y)) {
                return this;
            }
        }
        return null;
    }

    private boolean interactable() {
        return this.tlx != 0.0f || this.tly != 0.0f || this.rotdeg != 0.0f || this.scalex != null || this.scaley != null || this.toggle;
    }

    private void onMouseClick(EntityRollingStock stock) {
        if (this.sound != null) {
            this.sound.effects(stock, true, this.getValue(stock), MinecraftClient.getPlayer().getPosition());
        }
    }

    private void onMouseMove(EntityRollingStock stock, Matrix4 matrix, GuiBuilder target, int maxx, int maxy, int x, int y) {
        float value = this.getValue(stock);
        matrix = matrix.copy();
        this.applyPosition(matrix, maxx, maxy);
        Matrix4 preApply = matrix.copy();
        this.applyValue(matrix, value);
        if (target == this) {
            if (this.toggle) {
                return;
            }
            float closestValue = value;
            double closestDelta = 999999.0;
            float checkValue = 0.0f;
            while (checkValue <= 1.0f) {
                Vec3d checkMiddle;
                double delta;
                Matrix4 temp = preApply.copy();
                if (this.tlx != 0.0f || this.tly != 0.0f) {
                    temp.translate((double)(this.tlx * checkValue), (double)(this.tly * checkValue), 0.0);
                }
                if (this.rotdeg != 0.0f) {
                    temp.translate((double)this.rotx, (double)this.roty, 0.0);
                    temp.rotate(Math.toRadians(this.rotdeg * checkValue + this.rotoff), 0.0, 0.0, 1.0);
                    temp.translate((double)(-this.rotx), (double)(-this.roty), 0.0);
                }
                if (this.scalex != null || this.scaley != null) {
                    temp.scale(this.scalex != null ? (double)(this.scalex.floatValue() * checkValue) : 1.0, this.scaley != null ? (double)(this.scaley.floatValue() * checkValue) : 1.0, 1.0);
                }
                if ((delta = (checkMiddle = temp.apply(new Vec3d((double)((float)this.width / 2.0f), (double)((float)this.height / 2.0f), 0.0))).distanceTo(new Vec3d((double)x, (double)y, 0.0))) < closestDelta) {
                    closestDelta = delta;
                    closestValue = checkValue;
                }
                checkValue = (float)((double)checkValue + 0.01);
            }
            if (closestValue != value) {
                float val;
                this.temporary_value = val = this.invert ? 1.0f - closestValue : closestValue;
                if (this.setting != null) {
                    ConfigGraphics.settings.put(this.setting, Float.valueOf(val));
                    ConfigFile.write(ConfigGraphics.class);
                } else if (this.readout != Readouts.TRAIN_BRAKE_LEVER) {
                    new ControlChangePacket(stock, this.readout, this.control, this.global, this.texture_variant, val).sendToServer();
                }
            }
            if (target.sound != null) {
                target.sound.effects(stock, true, target.getValue(stock), MinecraftClient.getPlayer().getPosition());
            }
        } else {
            for (GuiBuilder element : this.elements) {
                element.onMouseMove(stock, matrix, target, maxx, maxy, x, y);
            }
        }
    }

    public boolean onMouseScroll(double scroll, EntityRollingStock stock, int maxx, int maxy, int x, int y) {
        if (!MinecraftClient.isReady()) {
            return true;
        }
        int ticks = MinecraftClient.getPlayer().getTickCount();
        GuiBuilder target = this.find(stock, new Matrix4(), maxx, maxy, x, y);
        if (target == null && lastScrolled + 20 > ticks) {
            target = scrollTarget;
        }
        if (target != null && !target.toggle) {
            target.onMouseClick(stock);
            float value = target.getValue(stock);
            value = stock instanceof LocomotiveDiesel && target.readout == Readouts.REVERSER ? (float)((double)value + (scroll > 0.0 ? 0.5 : -0.5)) : (float)((double)value + scroll / -50.0 * (double)ConfigGraphics.ScrollSpeed);
            if (target.setting != null) {
                ConfigGraphics.settings.put(target.setting, Float.valueOf(value));
                ConfigFile.write(ConfigGraphics.class);
            } else if (target.readout != Readouts.TRAIN_BRAKE_LEVER) {
                new ControlChangePacket(stock, target.readout, target.control, target.global, target.texture_variant, value).sendToServer();
            }
            scrollTarget = target;
            lastScrolled = ticks;
            return false;
        }
        return true;
    }

    public void onMouseRelease(EntityRollingStock stock) {
        float value = this.getValue(stock);
        if (this.sound != null) {
            this.sound.effects(stock, false, value, MinecraftClient.getPlayer().getPosition());
        }
        if (this.toggle) {
            value = 1.0f - value;
            if (this.invert) {
                value = 1.0f - value;
            }
        }
        if (this.readout == Readouts.HORN || this.readout == Readouts.WHISTLE) {
            value = 0.0f;
        }
        if (this.setting != null) {
            ConfigGraphics.settings.put(this.setting, Float.valueOf(value));
            ConfigFile.write(ConfigGraphics.class);
        } else {
            new ControlChangePacket(stock, this.readout, this.control, this.global, this.texture_variant, value).sendToServer();
        }
        this.temporary_value = 0.5f;
    }

    public boolean click(ClientEvents.MouseGuiEvent event, EntityRollingStock stock) {
        switch (event.action) {
            case CLICK: {
                if (target != null) {
                    target.onMouseRelease(stock);
                }
                if ((target = this.find(stock, new Matrix4(), GUIHelpers.getScreenWidth(), GUIHelpers.getScreenHeight(), event.x, event.y)) != null) {
                    target.onMouseClick(stock);
                }
                return target == null;
            }
            case RELEASE: {
                if (target == null) break;
                target.onMouseRelease(stock);
                target = null;
                return false;
            }
            case MOVE: {
                if (target == null) break;
                this.onMouseMove(stock, new Matrix4(), target, GUIHelpers.getScreenWidth(), GUIHelpers.getScreenHeight(), event.x, event.y);
                return false;
            }
            case SCROLL: {
                return this.onMouseScroll(event.scroll, stock, GUIHelpers.getScreenWidth(), GUIHelpers.getScreenHeight(), event.x, event.y);
            }
        }
        return true;
    }

    public static void onClientTick() {
        if (target != null && GuiBuilder.target.readout == Readouts.TRAIN_BRAKE_LEVER) {
            if (!MinecraftClient.isReady()) {
                return;
            }
            Entity riding = MinecraftClient.getPlayer().getRiding();
            if (!(riding instanceof EntityRollingStock)) {
                return;
            }
            EntityRollingStock stock = (EntityRollingStock)riding;
            float value = GuiBuilder.target.invert ? target.getValue(stock) : 1.0f - target.getValue(stock);
            new ControlChangePacket(stock, GuiBuilder.target.readout, GuiBuilder.target.control, GuiBuilder.target.global, GuiBuilder.target.texture_variant, value).sendToServer();
        }
    }

    public static class ControlChangePacket
    extends Packet {
        @TagField
        private UUID stockUUID;
        @TagField(typeHint=Readouts.class)
        private Readouts readout;
        @TagField
        private String controlGroup;
        @TagField
        private boolean global;
        @TagField
        private float value;
        @TagField
        private String texture_variant;

        public ControlChangePacket() {
        }

        public ControlChangePacket(EntityRollingStock stock, Readouts readout, String controlGroup, boolean global, String texture_variant, float value) {
            this.stockUUID = stock.getUUID();
            this.readout = readout;
            this.controlGroup = controlGroup;
            this.global = global;
            this.texture_variant = texture_variant;
            this.value = value;
            this.update(stock);
        }

        protected void handle() {
            EntityRollingStock stock = (EntityRollingStock)this.getWorld().getEntity(this.stockUUID, EntityRollingStock.class);
            if (stock != null) {
                this.update(stock);
            }
        }

        public void update(EntityRollingStock stock) {
            if (this.controlGroup != null) {
                switch (this.controlGroup) {
                    case "REVERSERFORWARD": {
                        this.readout = Readouts.REVERSER;
                        this.value = 1.0f;
                        break;
                    }
                    case "REVERSERNEUTRAL": {
                        this.readout = Readouts.REVERSER;
                        this.value = 0.5f;
                        break;
                    }
                    case "REVERSERBACKWARD": {
                        this.readout = Readouts.REVERSER;
                        this.value = 0.0f;
                        break;
                    }
                    default: {
                        if (this.global) {
                            ((EntityCoupleableRollingStock)stock).mapTrain((EntityCoupleableRollingStock)stock, false, target -> target.setControlPosition(this.controlGroup, this.value));
                        } else {
                            stock.setControlPosition(this.controlGroup, this.value);
                        }
                        return;
                    }
                }
            }
            if (this.readout != null) {
                if (this.global) {
                    ((EntityCoupleableRollingStock)stock).mapTrain((EntityCoupleableRollingStock)stock, false, target -> this.readout.setValue((EntityRollingStock)((Object)target), this.value));
                } else {
                    this.readout.setValue(stock, this.value);
                }
            }
            if (this.texture_variant != null && this.value == 1.0f) {
                stock.setTexture(this.texture_variant);
            }
        }
    }

    private static enum ClampMode {
        NONE,
        FLOOR,
        CEIL;


        public static ClampMode from(String value) {
            if (value != null) {
                return ClampMode.valueOf(value.toUpperCase(Locale.ROOT));
            }
            return NONE;
        }
    }

    private static enum Vertical {
        TOP,
        MIDDLE,
        BOTTOM;


        public static Vertical from(String pos_y) {
            if (pos_y == null) {
                return TOP;
            }
            if ((pos_y = pos_y.toUpperCase(Locale.ROOT)).equals("CENTER")) {
                return MIDDLE;
            }
            return Vertical.valueOf(pos_y);
        }
    }

    private static enum Horizontal {
        LEFT,
        RIGHT,
        MIDDLE;


        public static Horizontal from(String pos_x) {
            if (pos_x == null) {
                return LEFT;
            }
            if ((pos_x = pos_x.toUpperCase(Locale.ROOT)).equals("CENTER")) {
                return MIDDLE;
            }
            return Horizontal.valueOf(pos_x);
        }
    }
}

